% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_policy}
\alias{iam_create_policy}
\title{Creates a new managed policy for your AWS account}
\usage{
iam_create_policy(PolicyName, Path, PolicyDocument, Description)
}
\arguments{
\item{PolicyName}{[required] The friendly name of the policy.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}

\item{Path}{The path for the policy.

For more information about paths, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/).

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\code{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{PolicyDocument}{[required] The JSON policy document that you want to use as the content for the new
policy.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} used to validate
this parameter is a string of characters consisting of the following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \code{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\code{U+000A}), and
carriage return (\code{U+000D})
}}

\item{Description}{A friendly description of the policy.

Typically used to store information about the permissions defined in the
policy. For example, "Grants access to production DynamoDB tables."

The policy description is immutable. After a value is assigned, it
cannot be changed.}
}
\description{
Creates a new managed policy for your AWS account.
}
\details{
This operation creates a policy version with a version identifier of
\code{v1} and sets v1 as the policy's default version. For more information
about policy versions, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html}{Versioning for Managed Policies}
in the \emph{IAM User Guide}.

For more information about managed policies in general, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_policy(
  PolicyName = "string",
  Path = "string",
  PolicyDocument = "string",
  Description = "string"
)
}
}

\keyword{internal}
