% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_update_resource_share}
\alias{ram_update_resource_share}
\title{Updates the specified resource share that you own}
\usage{
ram_update_resource_share(resourceShareArn, name,
  allowExternalPrincipals, clientToken)
}
\arguments{
\item{resourceShareArn}{[required] The Amazon Resource Name (ARN) of the resource share.}

\item{name}{The name of the resource share.}

\item{allowExternalPrincipals}{Indicates whether principals outside your AWS organization can be
associated with a resource share.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\value{
A list with the following syntax:\preformatted{list(
  resourceShare = list(
    resourceShareArn = "string",
    name = "string",
    owningAccountId = "string",
    allowExternalPrincipals = TRUE|FALSE,
    status = "PENDING"|"ACTIVE"|"FAILED"|"DELETING"|"DELETED",
    statusMessage = "string",
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    ),
    creationTime = as.POSIXct(
      "2015-01-01"
    ),
    lastUpdatedTime = as.POSIXct(
      "2015-01-01"
    ),
    featureSet = "CREATED_FROM_POLICY"|"PROMOTING_TO_STANDARD"|"STANDARD"
  ),
  clientToken = "string"
)
}
}
\description{
Updates the specified resource share that you own.
}
\section{Request syntax}{
\preformatted{svc$update_resource_share(
  resourceShareArn = "string",
  name = "string",
  allowExternalPrincipals = TRUE|FALSE,
  clientToken = "string"
)
}
}

\keyword{internal}
