% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_create_alias}
\alias{kms_create_alias}
\title{Creates a display name for a customer managed customer master key (CMK)}
\usage{
kms_create_alias(AliasName, TargetKeyId)
}
\arguments{
\item{AliasName}{[required] Specifies the alias name. This value must begin with \code{alias/} followed
by a name, such as \code{alias/ExampleAlias}. The alias name cannot begin
with \code{alias/aws/}. The \code{alias/aws/} prefix is reserved for AWS managed
CMKs.}

\item{TargetKeyId}{[required] Identifies the CMK to which the alias refers. Specify the key ID or the
Amazon Resource Name (ARN) of the CMK. You cannot specify another alias.
For help finding the key ID and ARN, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn}{Finding the Key ID and ARN}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Creates a display name for a customer managed customer master key (CMK).
You can use an alias to identify a CMK in selected operations, such as
Encrypt and GenerateDataKey.
}
\details{
Each CMK can have multiple aliases, but each alias points to only one
CMK. The alias name must be unique in the AWS account and region. To
simplify code that runs in multiple regions, use the same alias name,
but point it to a different CMK in each region.

Because an alias is not a property of a CMK, you can delete and change
the aliases of a CMK without affecting the CMK. Also, aliases do not
appear in the response from the DescribeKey operation. To get the
aliases of all CMKs, use the ListAliases operation.

The alias name must begin with \code{alias/} followed by a name, such as
\code{alias/ExampleAlias}. It can contain only alphanumeric characters,
forward slashes (/), underscores (\_), and dashes (-). The alias name
cannot begin with \code{alias/aws/}. The \code{alias/aws/} prefix is reserved for
\href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk}{AWS managed CMKs}.

The alias and the CMK it is mapped to must be in the same AWS account
and the same region. You cannot perform this operation on an alias in a
different AWS account.

To map an existing alias to a different CMK, call UpdateAlias.

The result of this operation varies with the key state of the CMK. For
details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_alias(
  AliasName = "string",
  TargetKeyId = "string"
)
}
}

\examples{
# The following example creates an alias for the specified customer master
# key (CMK).
\donttest{svc$create_alias(
  AliasName = "alias/ExampleAlias",
  TargetKeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)}

}
\keyword{internal}
