% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_service_last_accessed_details_with_entities}
\alias{iam_get_service_last_accessed_details_with_entities}
\title{After you generate a group or policy report using the
GenerateServiceLastAccessedDetails operation, you can use the JobId
parameter in GetServiceLastAccessedDetailsWithEntities}
\usage{
iam_get_service_last_accessed_details_with_entities(JobId,
  ServiceNamespace, MaxItems, Marker)
}
\arguments{
\item{JobId}{[required] The ID of the request generated by the
\code{GenerateServiceLastAccessedDetails} operation.}

\item{ServiceNamespace}{[required] The service namespace for an AWS service. Provide the service namespace
to learn when the IAM entity last attempted to access the specified
service.

To learn the service namespace for a service, go to \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html}{Actions, Resources, and Condition Keys for AWS Services}
in the \emph{IAM User Guide}. Choose the name of the service to view details
for that service. In the first paragraph, find the service prefix. For
example, \verb{(service prefix: a4b)}. For more information about service
namespaces, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces}{AWS Service Namespaces}
in theÂ \emph{AWS General Reference}.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}
}
\description{
After you generate a group or policy report using the
\code{GenerateServiceLastAccessedDetails} operation, you can use the \code{JobId}
parameter in \code{GetServiceLastAccessedDetailsWithEntities}. This operation
retrieves the status of your report job and a list of entities that
could have used group or policy permissions to access the specified
service.
}
\details{
\itemize{
\item \strong{Group} -- For a group report, this operation returns a list of
users in the group that could have used the group's policies in an
attempt to access the service.
\item \strong{Policy} -- For a policy report, this operation returns a list of
entities (users or roles) that could have used the policy in an
attempt to access the service.
}

You can also use this operation for user or role reports to retrieve
details about those entities.

If the operation fails, the \code{GetServiceLastAccessedDetailsWithEntities}
operation returns the reason that it failed.

By default, the list of associated entities is sorted by date, with the
most recent access listed first.
}
\section{Request syntax}{
\preformatted{svc$get_service_last_accessed_details_with_entities(
  JobId = "string",
  ServiceNamespace = "string",
  MaxItems = 123,
  Marker = "string"
)
}
}

\examples{
# The following operation returns details about the entities that
# attempted to access the IAM service.
\donttest{svc$get_service_last_accessed_details_with_entities(
  JobId = "examplef-1305-c245-eba4-71fe298bcda7",
  ServiceNamespace = "iam"
)}

}
\keyword{internal}
