% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_add_attributes_to_findings}
\alias{inspector_add_attributes_to_findings}
\title{Assigns attributes (key and value pairs) to the findings that are
specified by the ARNs of the findings}
\usage{
inspector_add_attributes_to_findings(findingArns, attributes)
}
\arguments{
\item{findingArns}{[required] The ARNs that specify the findings that you want to assign attributes
to.}

\item{attributes}{[required] The array of attributes that you want to assign to specified findings.}
}
\description{
Assigns attributes (key and value pairs) to the findings that are
specified by the ARNs of the findings.
}
\section{Request syntax}{
\preformatted{svc$add_attributes_to_findings(
  findingArns = list(
    "string"
  ),
  attributes = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# Assigns attributes (key and value pairs) to the findings that are
# specified by the ARNs of the findings.
svc$add_attributes_to_findings(
  attributes = list(
    list(
      key = "Example",
      value = "example"
    )
  ),
  findingArns = list(
    "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-8l1VIE0D/run/0-Z0..."
  )
)
}

}
\keyword{internal}
