# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include directoryservice_service.R
NULL

#' Accepts a directory sharing request that was sent from the directory
#' owner account
#'
#' Accepts a directory sharing request that was sent from the directory
#' owner account.
#'
#' @usage
#' directoryservice_accept_shared_directory(SharedDirectoryId)
#'
#' @param SharedDirectoryId &#91;required&#93; Identifier of the shared directory in the directory consumer account.
#' This identifier is different for each directory owner account.
#'
#' @section Request syntax:
#' ```
#' svc$accept_shared_directory(
#'   SharedDirectoryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_accept_shared_directory
directoryservice_accept_shared_directory <- function(SharedDirectoryId) {
  op <- new_operation(
    name = "AcceptSharedDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$accept_shared_directory_input(SharedDirectoryId = SharedDirectoryId)
  output <- .directoryservice$accept_shared_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$accept_shared_directory <- directoryservice_accept_shared_directory

#' If the DNS server for your on-premises domain uses a publicly
#' addressable IP address, you must add a CIDR address block to correctly
#' route traffic to and from your Microsoft AD on Amazon Web Services
#'
#' If the DNS server for your on-premises domain uses a publicly
#' addressable IP address, you must add a CIDR address block to correctly
#' route traffic to and from your Microsoft AD on Amazon Web Services.
#' *AddIpRoutes* adds this address block. You can also use *AddIpRoutes* to
#' facilitate routing traffic that uses public IP ranges from your
#' Microsoft AD on AWS to a peer VPC.
#' 
#' Before you call *AddIpRoutes*, ensure that all of the required
#' permissions have been explicitly granted through a policy. For details
#' about what permissions are required to run the *AddIpRoutes* operation,
#' see [AWS Directory Service API Permissions: Actions, Resources, and
#' Conditions
#' Reference](http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
#'
#' @usage
#' directoryservice_add_ip_routes(DirectoryId, IpRoutes,
#'   UpdateSecurityGroupForDirectoryControllers)
#'
#' @param DirectoryId &#91;required&#93; Identifier (ID) of the directory to which to add the address block.
#' @param IpRoutes &#91;required&#93; IP address blocks, using CIDR format, of the traffic to route. This is
#' often the IP address block of the DNS server used for your on-premises
#' domain.
#' @param UpdateSecurityGroupForDirectoryControllers If set to true, updates the inbound and outbound rules of the security
#' group that has the description: \"AWS created security group for
#' *directory ID* directory controllers.\" Following are the new rules:
#' 
#' Inbound:
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source:
#'     0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source:
#'     0.0.0.0/0
#' 
#' -   Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0
#' 
#' -   Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0
#' 
#' -   Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0
#' 
#' -   Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0
#' 
#' Outbound:
#' 
#' -   Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0
#' 
#' These security rules impact an internal network interface that is not
#' exposed publicly.
#'
#' @section Request syntax:
#' ```
#' svc$add_ip_routes(
#'   DirectoryId = "string",
#'   IpRoutes = list(
#'     list(
#'       CidrIp = "string",
#'       Description = "string"
#'     )
#'   ),
#'   UpdateSecurityGroupForDirectoryControllers = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_add_ip_routes
directoryservice_add_ip_routes <- function(DirectoryId, IpRoutes, UpdateSecurityGroupForDirectoryControllers = NULL) {
  op <- new_operation(
    name = "AddIpRoutes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$add_ip_routes_input(DirectoryId = DirectoryId, IpRoutes = IpRoutes, UpdateSecurityGroupForDirectoryControllers = UpdateSecurityGroupForDirectoryControllers)
  output <- .directoryservice$add_ip_routes_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$add_ip_routes <- directoryservice_add_ip_routes

#' Adds or overwrites one or more tags for the specified directory
#'
#' Adds or overwrites one or more tags for the specified directory. Each
#' directory can have a maximum of 50 tags. Each tag consists of a key and
#' optional value. Tag keys must be unique to each resource.
#'
#' @usage
#' directoryservice_add_tags_to_resource(ResourceId, Tags)
#'
#' @param ResourceId &#91;required&#93; Identifier (ID) for the directory to which to add the tag.
#' @param Tags &#91;required&#93; The tags to be assigned to the directory.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_resource(
#'   ResourceId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_add_tags_to_resource
directoryservice_add_tags_to_resource <- function(ResourceId, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$add_tags_to_resource_input(ResourceId = ResourceId, Tags = Tags)
  output <- .directoryservice$add_tags_to_resource_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$add_tags_to_resource <- directoryservice_add_tags_to_resource

#' Cancels an in-progress schema extension to a Microsoft AD directory
#'
#' Cancels an in-progress schema extension to a Microsoft AD directory.
#' Once a schema extension has started replicating to all domain
#' controllers, the task can no longer be canceled. A schema extension can
#' be canceled during any of the following states; `Initializing`,
#' `CreatingSnapshot`, and `UpdatingSchema`.
#'
#' @usage
#' directoryservice_cancel_schema_extension(DirectoryId, SchemaExtensionId)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory whose schema extension will be canceled.
#' @param SchemaExtensionId &#91;required&#93; The identifier of the schema extension that will be canceled.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_schema_extension(
#'   DirectoryId = "string",
#'   SchemaExtensionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_cancel_schema_extension
directoryservice_cancel_schema_extension <- function(DirectoryId, SchemaExtensionId) {
  op <- new_operation(
    name = "CancelSchemaExtension",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$cancel_schema_extension_input(DirectoryId = DirectoryId, SchemaExtensionId = SchemaExtensionId)
  output <- .directoryservice$cancel_schema_extension_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$cancel_schema_extension <- directoryservice_cancel_schema_extension

#' Creates an AD Connector to connect to an on-premises directory
#'
#' Creates an AD Connector to connect to an on-premises directory.
#' 
#' Before you call `ConnectDirectory`, ensure that all of the required
#' permissions have been explicitly granted through a policy. For details
#' about what permissions are required to run the `ConnectDirectory`
#' operation, see [AWS Directory Service API Permissions: Actions,
#' Resources, and Conditions
#' Reference](http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
#'
#' @usage
#' directoryservice_connect_directory(Name, ShortName, Password,
#'   Description, Size, ConnectSettings, Tags)
#'
#' @param Name &#91;required&#93; The fully qualified name of the on-premises directory, such as
#' `corp.example.com`.
#' @param ShortName The NetBIOS name of the on-premises directory, such as `CORP`.
#' @param Password &#91;required&#93; The password for the on-premises user account.
#' @param Description A description for the directory.
#' @param Size &#91;required&#93; The size of the directory.
#' @param ConnectSettings &#91;required&#93; A DirectoryConnectSettings object that contains additional information
#' for the operation.
#' @param Tags The tags to be assigned to AD Connector.
#'
#' @section Request syntax:
#' ```
#' svc$connect_directory(
#'   Name = "string",
#'   ShortName = "string",
#'   Password = "string",
#'   Description = "string",
#'   Size = "Small"|"Large",
#'   ConnectSettings = list(
#'     VpcId = "string",
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     CustomerDnsIps = list(
#'       "string"
#'     ),
#'     CustomerUserName = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_connect_directory
directoryservice_connect_directory <- function(Name, ShortName = NULL, Password, Description = NULL, Size, ConnectSettings, Tags = NULL) {
  op <- new_operation(
    name = "ConnectDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$connect_directory_input(Name = Name, ShortName = ShortName, Password = Password, Description = Description, Size = Size, ConnectSettings = ConnectSettings, Tags = Tags)
  output <- .directoryservice$connect_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$connect_directory <- directoryservice_connect_directory

#' Creates an alias for a directory and assigns the alias to the directory
#'
#' Creates an alias for a directory and assigns the alias to the directory.
#' The alias is used to construct the access URL for the directory, such as
#' `http://&lt;alias&gt;.awsapps.com`.
#' 
#' After an alias has been created, it cannot be deleted or reused, so this
#' operation should only be used when absolutely necessary.
#'
#' @usage
#' directoryservice_create_alias(DirectoryId, Alias)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to create the alias.
#' @param Alias &#91;required&#93; The requested alias.
#' 
#' The alias must be unique amongst all aliases in AWS. This operation
#' throws an `EntityAlreadyExistsException` error if the alias already
#' exists.
#'
#' @section Request syntax:
#' ```
#' svc$create_alias(
#'   DirectoryId = "string",
#'   Alias = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_alias
directoryservice_create_alias <- function(DirectoryId, Alias) {
  op <- new_operation(
    name = "CreateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_alias_input(DirectoryId = DirectoryId, Alias = Alias)
  output <- .directoryservice$create_alias_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_alias <- directoryservice_create_alias

#' Creates a computer account in the specified directory, and joins the
#' computer to the directory
#'
#' Creates a computer account in the specified directory, and joins the
#' computer to the directory.
#'
#' @usage
#' directoryservice_create_computer(DirectoryId, ComputerName, Password,
#'   OrganizationalUnitDistinguishedName, ComputerAttributes)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory in which to create the computer account.
#' @param ComputerName &#91;required&#93; The name of the computer account.
#' @param Password &#91;required&#93; A one-time password that is used to join the computer to the directory.
#' You should generate a random, strong password to use for this parameter.
#' @param OrganizationalUnitDistinguishedName The fully-qualified distinguished name of the organizational unit to
#' place the computer account in.
#' @param ComputerAttributes An array of Attribute objects that contain any LDAP attributes to apply
#' to the computer account.
#'
#' @section Request syntax:
#' ```
#' svc$create_computer(
#'   DirectoryId = "string",
#'   ComputerName = "string",
#'   Password = "string",
#'   OrganizationalUnitDistinguishedName = "string",
#'   ComputerAttributes = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_computer
directoryservice_create_computer <- function(DirectoryId, ComputerName, Password, OrganizationalUnitDistinguishedName = NULL, ComputerAttributes = NULL) {
  op <- new_operation(
    name = "CreateComputer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_computer_input(DirectoryId = DirectoryId, ComputerName = ComputerName, Password = Password, OrganizationalUnitDistinguishedName = OrganizationalUnitDistinguishedName, ComputerAttributes = ComputerAttributes)
  output <- .directoryservice$create_computer_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_computer <- directoryservice_create_computer

#' Creates a conditional forwarder associated with your AWS directory
#'
#' Creates a conditional forwarder associated with your AWS directory.
#' Conditional forwarders are required in order to set up a trust
#' relationship with another domain. The conditional forwarder points to
#' the trusted domain.
#'
#' @usage
#' directoryservice_create_conditional_forwarder(DirectoryId,
#'   RemoteDomainName, DnsIpAddrs)
#'
#' @param DirectoryId &#91;required&#93; The directory ID of the AWS directory for which you are creating the
#' conditional forwarder.
#' @param RemoteDomainName &#91;required&#93; The fully qualified domain name (FQDN) of the remote domain with which
#' you will set up a trust relationship.
#' @param DnsIpAddrs &#91;required&#93; The IP addresses of the remote DNS server associated with
#' RemoteDomainName.
#'
#' @section Request syntax:
#' ```
#' svc$create_conditional_forwarder(
#'   DirectoryId = "string",
#'   RemoteDomainName = "string",
#'   DnsIpAddrs = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_conditional_forwarder
directoryservice_create_conditional_forwarder <- function(DirectoryId, RemoteDomainName, DnsIpAddrs) {
  op <- new_operation(
    name = "CreateConditionalForwarder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_conditional_forwarder_input(DirectoryId = DirectoryId, RemoteDomainName = RemoteDomainName, DnsIpAddrs = DnsIpAddrs)
  output <- .directoryservice$create_conditional_forwarder_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_conditional_forwarder <- directoryservice_create_conditional_forwarder

#' Creates a Simple AD directory
#'
#' Creates a Simple AD directory. For more information, see [Simple Active
#' Directory](https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html)
#' in the *AWS Directory Service Admin Guide*.
#' 
#' Before you call `CreateDirectory`, ensure that all of the required
#' permissions have been explicitly granted through a policy. For details
#' about what permissions are required to run the `CreateDirectory`
#' operation, see [AWS Directory Service API Permissions: Actions,
#' Resources, and Conditions
#' Reference](http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
#'
#' @usage
#' directoryservice_create_directory(Name, ShortName, Password,
#'   Description, Size, VpcSettings, Tags)
#'
#' @param Name &#91;required&#93; The fully qualified name for the directory, such as `corp.example.com`.
#' @param ShortName The NetBIOS name of the directory, such as `CORP`.
#' @param Password &#91;required&#93; The password for the directory administrator. The directory creation
#' process creates a directory administrator account with the user name
#' `Administrator` and this password.
#' 
#' If you need to change the password for the administrator account, you
#' can use the ResetUserPassword API call.
#' @param Description A description for the directory.
#' @param Size &#91;required&#93; The size of the directory.
#' @param VpcSettings A DirectoryVpcSettings object that contains additional information for
#' the operation.
#' @param Tags The tags to be assigned to the Simple AD directory.
#'
#' @section Request syntax:
#' ```
#' svc$create_directory(
#'   Name = "string",
#'   ShortName = "string",
#'   Password = "string",
#'   Description = "string",
#'   Size = "Small"|"Large",
#'   VpcSettings = list(
#'     VpcId = "string",
#'     SubnetIds = list(
#'       "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_directory
directoryservice_create_directory <- function(Name, ShortName = NULL, Password, Description = NULL, Size, VpcSettings = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_directory_input(Name = Name, ShortName = ShortName, Password = Password, Description = Description, Size = Size, VpcSettings = VpcSettings, Tags = Tags)
  output <- .directoryservice$create_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_directory <- directoryservice_create_directory

#' Creates a subscription to forward real-time Directory Service domain
#' controller security logs to the specified Amazon CloudWatch log group in
#' your AWS account
#'
#' Creates a subscription to forward real-time Directory Service domain
#' controller security logs to the specified Amazon CloudWatch log group in
#' your AWS account.
#'
#' @usage
#' directoryservice_create_log_subscription(DirectoryId, LogGroupName)
#'
#' @param DirectoryId &#91;required&#93; Identifier of the directory to which you want to subscribe and receive
#' real-time logs to your specified CloudWatch log group.
#' @param LogGroupName &#91;required&#93; The name of the CloudWatch log group where the real-time domain
#' controller logs are forwarded.
#'
#' @section Request syntax:
#' ```
#' svc$create_log_subscription(
#'   DirectoryId = "string",
#'   LogGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_log_subscription
directoryservice_create_log_subscription <- function(DirectoryId, LogGroupName) {
  op <- new_operation(
    name = "CreateLogSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_log_subscription_input(DirectoryId = DirectoryId, LogGroupName = LogGroupName)
  output <- .directoryservice$create_log_subscription_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_log_subscription <- directoryservice_create_log_subscription

#' Creates a Microsoft AD directory in the AWS Cloud
#'
#' Creates a Microsoft AD directory in the AWS Cloud. For more information,
#' see [AWS Managed Microsoft
#' AD](https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html)
#' in the *AWS Directory Service Admin Guide*.
#' 
#' Before you call *CreateMicrosoftAD*, ensure that all of the required
#' permissions have been explicitly granted through a policy. For details
#' about what permissions are required to run the *CreateMicrosoftAD*
#' operation, see [AWS Directory Service API Permissions: Actions,
#' Resources, and Conditions
#' Reference](http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
#'
#' @usage
#' directoryservice_create_microsoft_ad(Name, ShortName, Password,
#'   Description, VpcSettings, Edition, Tags)
#'
#' @param Name &#91;required&#93; The fully qualified domain name for the AWS Managed Microsoft AD
#' directory, such as `corp.example.com`. This name will resolve inside
#' your VPC only. It does not need to be publicly resolvable.
#' @param ShortName The NetBIOS name for your domain, such as `CORP`. If you don\'t specify
#' a NetBIOS name, it will default to the first part of your directory DNS.
#' For example, `CORP` for the directory DNS `corp.example.com`.
#' @param Password &#91;required&#93; The password for the default administrative user named `Admin`.
#' 
#' If you need to change the password for the administrator account, you
#' can use the ResetUserPassword API call.
#' @param Description A description for the directory. This label will appear on the AWS
#' console `Directory Details` page after the directory is created.
#' @param VpcSettings &#91;required&#93; Contains VPC information for the CreateDirectory or CreateMicrosoftAD
#' operation.
#' @param Edition AWS Managed Microsoft AD is available in two editions: `Standard` and
#' `Enterprise`. `Enterprise` is the default.
#' @param Tags The tags to be assigned to the AWS Managed Microsoft AD directory.
#'
#' @section Request syntax:
#' ```
#' svc$create_microsoft_ad(
#'   Name = "string",
#'   ShortName = "string",
#'   Password = "string",
#'   Description = "string",
#'   VpcSettings = list(
#'     VpcId = "string",
#'     SubnetIds = list(
#'       "string"
#'     )
#'   ),
#'   Edition = "Enterprise"|"Standard",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_microsoft_ad
directoryservice_create_microsoft_ad <- function(Name, ShortName = NULL, Password, Description = NULL, VpcSettings, Edition = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateMicrosoftAD",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_microsoft_ad_input(Name = Name, ShortName = ShortName, Password = Password, Description = Description, VpcSettings = VpcSettings, Edition = Edition, Tags = Tags)
  output <- .directoryservice$create_microsoft_ad_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_microsoft_ad <- directoryservice_create_microsoft_ad

#' Creates a snapshot of a Simple AD or Microsoft AD directory in the AWS
#' cloud
#'
#' Creates a snapshot of a Simple AD or Microsoft AD directory in the AWS
#' cloud.
#' 
#' You cannot take snapshots of AD Connector directories.
#'
#' @usage
#' directoryservice_create_snapshot(DirectoryId, Name)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory of which to take a snapshot.
#' @param Name The descriptive name to apply to the snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$create_snapshot(
#'   DirectoryId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_snapshot
directoryservice_create_snapshot <- function(DirectoryId, Name = NULL) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_snapshot_input(DirectoryId = DirectoryId, Name = Name)
  output <- .directoryservice$create_snapshot_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_snapshot <- directoryservice_create_snapshot

#' AWS Directory Service for Microsoft Active Directory allows you to
#' configure trust relationships
#'
#' AWS Directory Service for Microsoft Active Directory allows you to
#' configure trust relationships. For example, you can establish a trust
#' between your AWS Managed Microsoft AD directory, and your existing
#' on-premises Microsoft Active Directory. This would allow you to provide
#' users and groups access to resources in either domain, with a single set
#' of credentials.
#' 
#' This action initiates the creation of the AWS side of a trust
#' relationship between an AWS Managed Microsoft AD directory and an
#' external domain. You can create either a forest trust or an external
#' trust.
#'
#' @usage
#' directoryservice_create_trust(DirectoryId, RemoteDomainName,
#'   TrustPassword, TrustDirection, TrustType, ConditionalForwarderIpAddrs,
#'   SelectiveAuth)
#'
#' @param DirectoryId &#91;required&#93; The Directory ID of the AWS Managed Microsoft AD directory for which to
#' establish the trust relationship.
#' @param RemoteDomainName &#91;required&#93; The Fully Qualified Domain Name (FQDN) of the external domain for which
#' to create the trust relationship.
#' @param TrustPassword &#91;required&#93; The trust password. The must be the same password that was used when
#' creating the trust relationship on the external domain.
#' @param TrustDirection &#91;required&#93; The direction of the trust relationship.
#' @param TrustType The trust relationship type. `Forest` is the default.
#' @param ConditionalForwarderIpAddrs The IP addresses of the remote DNS server associated with
#' RemoteDomainName.
#' @param SelectiveAuth Optional parameter to enable selective authentication for the trust.
#'
#' @section Request syntax:
#' ```
#' svc$create_trust(
#'   DirectoryId = "string",
#'   RemoteDomainName = "string",
#'   TrustPassword = "string",
#'   TrustDirection = "One-Way: Outgoing"|"One-Way: Incoming"|"Two-Way",
#'   TrustType = "Forest"|"External",
#'   ConditionalForwarderIpAddrs = list(
#'     "string"
#'   ),
#'   SelectiveAuth = "Enabled"|"Disabled"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_trust
directoryservice_create_trust <- function(DirectoryId, RemoteDomainName, TrustPassword, TrustDirection, TrustType = NULL, ConditionalForwarderIpAddrs = NULL, SelectiveAuth = NULL) {
  op <- new_operation(
    name = "CreateTrust",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_trust_input(DirectoryId = DirectoryId, RemoteDomainName = RemoteDomainName, TrustPassword = TrustPassword, TrustDirection = TrustDirection, TrustType = TrustType, ConditionalForwarderIpAddrs = ConditionalForwarderIpAddrs, SelectiveAuth = SelectiveAuth)
  output <- .directoryservice$create_trust_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_trust <- directoryservice_create_trust

#' Deletes a conditional forwarder that has been set up for your AWS
#' directory
#'
#' Deletes a conditional forwarder that has been set up for your AWS
#' directory.
#'
#' @usage
#' directoryservice_delete_conditional_forwarder(DirectoryId,
#'   RemoteDomainName)
#'
#' @param DirectoryId &#91;required&#93; The directory ID for which you are deleting the conditional forwarder.
#' @param RemoteDomainName &#91;required&#93; The fully qualified domain name (FQDN) of the remote domain with which
#' you are deleting the conditional forwarder.
#'
#' @section Request syntax:
#' ```
#' svc$delete_conditional_forwarder(
#'   DirectoryId = "string",
#'   RemoteDomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_delete_conditional_forwarder
directoryservice_delete_conditional_forwarder <- function(DirectoryId, RemoteDomainName) {
  op <- new_operation(
    name = "DeleteConditionalForwarder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$delete_conditional_forwarder_input(DirectoryId = DirectoryId, RemoteDomainName = RemoteDomainName)
  output <- .directoryservice$delete_conditional_forwarder_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$delete_conditional_forwarder <- directoryservice_delete_conditional_forwarder

#' Deletes an AWS Directory Service directory
#'
#' Deletes an AWS Directory Service directory.
#' 
#' Before you call `DeleteDirectory`, ensure that all of the required
#' permissions have been explicitly granted through a policy. For details
#' about what permissions are required to run the `DeleteDirectory`
#' operation, see [AWS Directory Service API Permissions: Actions,
#' Resources, and Conditions
#' Reference](http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
#'
#' @usage
#' directoryservice_delete_directory(DirectoryId)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_directory(
#'   DirectoryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_delete_directory
directoryservice_delete_directory <- function(DirectoryId) {
  op <- new_operation(
    name = "DeleteDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$delete_directory_input(DirectoryId = DirectoryId)
  output <- .directoryservice$delete_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$delete_directory <- directoryservice_delete_directory

#' Deletes the specified log subscription
#'
#' Deletes the specified log subscription.
#'
#' @usage
#' directoryservice_delete_log_subscription(DirectoryId)
#'
#' @param DirectoryId &#91;required&#93; Identifier of the directory whose log subscription you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_log_subscription(
#'   DirectoryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_delete_log_subscription
directoryservice_delete_log_subscription <- function(DirectoryId) {
  op <- new_operation(
    name = "DeleteLogSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$delete_log_subscription_input(DirectoryId = DirectoryId)
  output <- .directoryservice$delete_log_subscription_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$delete_log_subscription <- directoryservice_delete_log_subscription

#' Deletes a directory snapshot
#'
#' Deletes a directory snapshot.
#'
#' @usage
#' directoryservice_delete_snapshot(SnapshotId)
#'
#' @param SnapshotId &#91;required&#93; The identifier of the directory snapshot to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_snapshot(
#'   SnapshotId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_delete_snapshot
directoryservice_delete_snapshot <- function(SnapshotId) {
  op <- new_operation(
    name = "DeleteSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$delete_snapshot_input(SnapshotId = SnapshotId)
  output <- .directoryservice$delete_snapshot_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$delete_snapshot <- directoryservice_delete_snapshot

#' Deletes an existing trust relationship between your AWS Managed
#' Microsoft AD directory and an external domain
#'
#' Deletes an existing trust relationship between your AWS Managed
#' Microsoft AD directory and an external domain.
#'
#' @usage
#' directoryservice_delete_trust(TrustId,
#'   DeleteAssociatedConditionalForwarder)
#'
#' @param TrustId &#91;required&#93; The Trust ID of the trust relationship to be deleted.
#' @param DeleteAssociatedConditionalForwarder Delete a conditional forwarder as part of a DeleteTrustRequest.
#'
#' @section Request syntax:
#' ```
#' svc$delete_trust(
#'   TrustId = "string",
#'   DeleteAssociatedConditionalForwarder = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_delete_trust
directoryservice_delete_trust <- function(TrustId, DeleteAssociatedConditionalForwarder = NULL) {
  op <- new_operation(
    name = "DeleteTrust",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$delete_trust_input(TrustId = TrustId, DeleteAssociatedConditionalForwarder = DeleteAssociatedConditionalForwarder)
  output <- .directoryservice$delete_trust_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$delete_trust <- directoryservice_delete_trust

#' Deletes from the system the certificate that was registered for a
#' secured LDAP connection
#'
#' Deletes from the system the certificate that was registered for a
#' secured LDAP connection.
#'
#' @usage
#' directoryservice_deregister_certificate(DirectoryId, CertificateId)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param CertificateId &#91;required&#93; The identifier of the certificate.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_certificate(
#'   DirectoryId = "string",
#'   CertificateId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_deregister_certificate
directoryservice_deregister_certificate <- function(DirectoryId, CertificateId) {
  op <- new_operation(
    name = "DeregisterCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$deregister_certificate_input(DirectoryId = DirectoryId, CertificateId = CertificateId)
  output <- .directoryservice$deregister_certificate_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$deregister_certificate <- directoryservice_deregister_certificate

#' Removes the specified directory as a publisher to the specified SNS
#' topic
#'
#' Removes the specified directory as a publisher to the specified SNS
#' topic.
#'
#' @usage
#' directoryservice_deregister_event_topic(DirectoryId, TopicName)
#'
#' @param DirectoryId &#91;required&#93; The Directory ID to remove as a publisher. This directory will no longer
#' send messages to the specified SNS topic.
#' @param TopicName &#91;required&#93; The name of the SNS topic from which to remove the directory as a
#' publisher.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_event_topic(
#'   DirectoryId = "string",
#'   TopicName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_deregister_event_topic
directoryservice_deregister_event_topic <- function(DirectoryId, TopicName) {
  op <- new_operation(
    name = "DeregisterEventTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$deregister_event_topic_input(DirectoryId = DirectoryId, TopicName = TopicName)
  output <- .directoryservice$deregister_event_topic_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$deregister_event_topic <- directoryservice_deregister_event_topic

#' Displays information about the certificate registered for a secured LDAP
#' connection
#'
#' Displays information about the certificate registered for a secured LDAP
#' connection.
#'
#' @usage
#' directoryservice_describe_certificate(DirectoryId, CertificateId)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param CertificateId &#91;required&#93; The identifier of the certificate.
#'
#' @section Request syntax:
#' ```
#' svc$describe_certificate(
#'   DirectoryId = "string",
#'   CertificateId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_certificate
directoryservice_describe_certificate <- function(DirectoryId, CertificateId) {
  op <- new_operation(
    name = "DescribeCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_certificate_input(DirectoryId = DirectoryId, CertificateId = CertificateId)
  output <- .directoryservice$describe_certificate_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_certificate <- directoryservice_describe_certificate

#' Obtains information about the conditional forwarders for this account
#'
#' Obtains information about the conditional forwarders for this account.
#' 
#' If no input parameters are provided for RemoteDomainNames, this request
#' describes all conditional forwarders for the specified directory ID.
#'
#' @usage
#' directoryservice_describe_conditional_forwarders(DirectoryId,
#'   RemoteDomainNames)
#'
#' @param DirectoryId &#91;required&#93; The directory ID for which to get the list of associated conditional
#' forwarders.
#' @param RemoteDomainNames The fully qualified domain names (FQDN) of the remote domains for which
#' to get the list of associated conditional forwarders. If this member is
#' null, all conditional forwarders are returned.
#'
#' @section Request syntax:
#' ```
#' svc$describe_conditional_forwarders(
#'   DirectoryId = "string",
#'   RemoteDomainNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_conditional_forwarders
directoryservice_describe_conditional_forwarders <- function(DirectoryId, RemoteDomainNames = NULL) {
  op <- new_operation(
    name = "DescribeConditionalForwarders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_conditional_forwarders_input(DirectoryId = DirectoryId, RemoteDomainNames = RemoteDomainNames)
  output <- .directoryservice$describe_conditional_forwarders_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_conditional_forwarders <- directoryservice_describe_conditional_forwarders

#' Obtains information about the directories that belong to this account
#'
#' Obtains information about the directories that belong to this account.
#' 
#' You can retrieve information about specific directories by passing the
#' directory identifiers in the `DirectoryIds` parameter. Otherwise, all
#' directories that belong to the current account are returned.
#' 
#' This operation supports pagination with the use of the `NextToken`
#' request and response parameters. If more results are available, the
#' `DescribeDirectoriesResult.NextToken` member contains a token that you
#' pass in the next call to DescribeDirectories to retrieve the next set of
#' items.
#' 
#' You can also specify a maximum number of return results with the `Limit`
#' parameter.
#'
#' @usage
#' directoryservice_describe_directories(DirectoryIds, NextToken, Limit)
#'
#' @param DirectoryIds A list of identifiers of the directories for which to obtain the
#' information. If this member is null, all directories that belong to the
#' current account are returned.
#' 
#' An empty list results in an `InvalidParameterException` being thrown.
#' @param NextToken The `DescribeDirectoriesResult.NextToken` value from a previous call to
#' DescribeDirectories. Pass null if this is the first call.
#' @param Limit The maximum number of items to return. If this value is zero, the
#' maximum number of items is specified by the limitations of the
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$describe_directories(
#'   DirectoryIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_directories
directoryservice_describe_directories <- function(DirectoryIds = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeDirectories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_directories_input(DirectoryIds = DirectoryIds, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_directories_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_directories <- directoryservice_describe_directories

#' Provides information about any domain controllers in your directory
#'
#' Provides information about any domain controllers in your directory.
#'
#' @usage
#' directoryservice_describe_domain_controllers(DirectoryId,
#'   DomainControllerIds, NextToken, Limit)
#'
#' @param DirectoryId &#91;required&#93; Identifier of the directory for which to retrieve the domain controller
#' information.
#' @param DomainControllerIds A list of identifiers for the domain controllers whose information will
#' be provided.
#' @param NextToken The *DescribeDomainControllers.NextToken* value from a previous call to
#' DescribeDomainControllers. Pass null if this is the first call.
#' @param Limit The maximum number of items to return.
#'
#' @section Request syntax:
#' ```
#' svc$describe_domain_controllers(
#'   DirectoryId = "string",
#'   DomainControllerIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_domain_controllers
directoryservice_describe_domain_controllers <- function(DirectoryId, DomainControllerIds = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeDomainControllers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_domain_controllers_input(DirectoryId = DirectoryId, DomainControllerIds = DomainControllerIds, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_domain_controllers_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_domain_controllers <- directoryservice_describe_domain_controllers

#' Obtains information about which SNS topics receive status messages from
#' the specified directory
#'
#' Obtains information about which SNS topics receive status messages from
#' the specified directory.
#' 
#' If no input parameters are provided, such as DirectoryId or TopicName,
#' this request describes all of the associations in the account.
#'
#' @usage
#' directoryservice_describe_event_topics(DirectoryId, TopicNames)
#'
#' @param DirectoryId The Directory ID for which to get the list of associated SNS topics. If
#' this member is null, associations for all Directory IDs are returned.
#' @param TopicNames A list of SNS topic names for which to obtain the information. If this
#' member is null, all associations for the specified Directory ID are
#' returned.
#' 
#' An empty list results in an `InvalidParameterException` being thrown.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_topics(
#'   DirectoryId = "string",
#'   TopicNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_event_topics
directoryservice_describe_event_topics <- function(DirectoryId = NULL, TopicNames = NULL) {
  op <- new_operation(
    name = "DescribeEventTopics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_event_topics_input(DirectoryId = DirectoryId, TopicNames = TopicNames)
  output <- .directoryservice$describe_event_topics_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_event_topics <- directoryservice_describe_event_topics

#' Describes the status of LDAP security for the specified directory
#'
#' Describes the status of LDAP security for the specified directory.
#'
#' @usage
#' directoryservice_describe_ldaps_settings(DirectoryId, Type, NextToken,
#'   Limit)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param Type The type of LDAP security to enable. Currently only the value `Client`
#' is supported.
#' @param NextToken The type of next token used for pagination.
#' @param Limit Specifies the number of items that should be displayed on one page.
#'
#' @section Request syntax:
#' ```
#' svc$describe_ldaps_settings(
#'   DirectoryId = "string",
#'   Type = "Client",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_ldaps_settings
directoryservice_describe_ldaps_settings <- function(DirectoryId, Type = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeLDAPSSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_ldaps_settings_input(DirectoryId = DirectoryId, Type = Type, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_ldaps_settings_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_ldaps_settings <- directoryservice_describe_ldaps_settings

#' Returns the shared directories in your account
#'
#' Returns the shared directories in your account.
#'
#' @usage
#' directoryservice_describe_shared_directories(OwnerDirectoryId,
#'   SharedDirectoryIds, NextToken, Limit)
#'
#' @param OwnerDirectoryId &#91;required&#93; Returns the identifier of the directory in the directory owner account.
#' @param SharedDirectoryIds A list of identifiers of all shared directories in your account.
#' @param NextToken The `DescribeSharedDirectoriesResult.NextToken` value from a previous
#' call to DescribeSharedDirectories. Pass null if this is the first call.
#' @param Limit The number of shared directories to return in the response object.
#'
#' @section Request syntax:
#' ```
#' svc$describe_shared_directories(
#'   OwnerDirectoryId = "string",
#'   SharedDirectoryIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_shared_directories
directoryservice_describe_shared_directories <- function(OwnerDirectoryId, SharedDirectoryIds = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeSharedDirectories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_shared_directories_input(OwnerDirectoryId = OwnerDirectoryId, SharedDirectoryIds = SharedDirectoryIds, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_shared_directories_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_shared_directories <- directoryservice_describe_shared_directories

#' Obtains information about the directory snapshots that belong to this
#' account
#'
#' Obtains information about the directory snapshots that belong to this
#' account.
#' 
#' This operation supports pagination with the use of the *NextToken*
#' request and response parameters. If more results are available, the
#' *DescribeSnapshots.NextToken* member contains a token that you pass in
#' the next call to DescribeSnapshots to retrieve the next set of items.
#' 
#' You can also specify a maximum number of return results with the *Limit*
#' parameter.
#'
#' @usage
#' directoryservice_describe_snapshots(DirectoryId, SnapshotIds, NextToken,
#'   Limit)
#'
#' @param DirectoryId The identifier of the directory for which to retrieve snapshot
#' information.
#' @param SnapshotIds A list of identifiers of the snapshots to obtain the information for. If
#' this member is null or empty, all snapshots are returned using the
#' *Limit* and *NextToken* members.
#' @param NextToken The *DescribeSnapshotsResult.NextToken* value from a previous call to
#' DescribeSnapshots. Pass null if this is the first call.
#' @param Limit The maximum number of objects to return.
#'
#' @section Request syntax:
#' ```
#' svc$describe_snapshots(
#'   DirectoryId = "string",
#'   SnapshotIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_snapshots
directoryservice_describe_snapshots <- function(DirectoryId = NULL, SnapshotIds = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_snapshots_input(DirectoryId = DirectoryId, SnapshotIds = SnapshotIds, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_snapshots_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_snapshots <- directoryservice_describe_snapshots

#' Obtains information about the trust relationships for this account
#'
#' Obtains information about the trust relationships for this account.
#' 
#' If no input parameters are provided, such as DirectoryId or TrustIds,
#' this request describes all the trust relationships belonging to the
#' account.
#'
#' @usage
#' directoryservice_describe_trusts(DirectoryId, TrustIds, NextToken,
#'   Limit)
#'
#' @param DirectoryId The Directory ID of the AWS directory that is a part of the requested
#' trust relationship.
#' @param TrustIds A list of identifiers of the trust relationships for which to obtain the
#' information. If this member is null, all trust relationships that belong
#' to the current account are returned.
#' 
#' An empty list results in an `InvalidParameterException` being thrown.
#' @param NextToken The *DescribeTrustsResult.NextToken* value from a previous call to
#' DescribeTrusts. Pass null if this is the first call.
#' @param Limit The maximum number of objects to return.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trusts(
#'   DirectoryId = "string",
#'   TrustIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_trusts
directoryservice_describe_trusts <- function(DirectoryId = NULL, TrustIds = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeTrusts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_trusts_input(DirectoryId = DirectoryId, TrustIds = TrustIds, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_trusts_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_trusts <- directoryservice_describe_trusts

#' Deactivates LDAP secure calls for the specified directory
#'
#' Deactivates LDAP secure calls for the specified directory.
#'
#' @usage
#' directoryservice_disable_ldaps(DirectoryId, Type)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param Type &#91;required&#93; The type of LDAP security to enable. Currently only the value `Client`
#' is supported.
#'
#' @section Request syntax:
#' ```
#' svc$disable_ldaps(
#'   DirectoryId = "string",
#'   Type = "Client"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_disable_ldaps
directoryservice_disable_ldaps <- function(DirectoryId, Type) {
  op <- new_operation(
    name = "DisableLDAPS",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$disable_ldaps_input(DirectoryId = DirectoryId, Type = Type)
  output <- .directoryservice$disable_ldaps_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$disable_ldaps <- directoryservice_disable_ldaps

#' Disables multi-factor authentication (MFA) with the Remote
#' Authentication Dial In User Service (RADIUS) server for an AD Connector
#' or Microsoft AD directory
#'
#' Disables multi-factor authentication (MFA) with the Remote
#' Authentication Dial In User Service (RADIUS) server for an AD Connector
#' or Microsoft AD directory.
#'
#' @usage
#' directoryservice_disable_radius(DirectoryId)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to disable MFA.
#'
#' @section Request syntax:
#' ```
#' svc$disable_radius(
#'   DirectoryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_disable_radius
directoryservice_disable_radius <- function(DirectoryId) {
  op <- new_operation(
    name = "DisableRadius",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$disable_radius_input(DirectoryId = DirectoryId)
  output <- .directoryservice$disable_radius_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$disable_radius <- directoryservice_disable_radius

#' Disables single-sign on for a directory
#'
#' Disables single-sign on for a directory.
#'
#' @usage
#' directoryservice_disable_sso(DirectoryId, UserName, Password)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to disable single-sign on.
#' @param UserName The username of an alternate account to use to disable single-sign on.
#' This is only used for AD Connector directories. This account must have
#' privileges to remove a service principal name.
#' 
#' If the AD Connector service account does not have privileges to remove a
#' service principal name, you can specify an alternate account with the
#' *UserName* and *Password* parameters. These credentials are only used to
#' disable single sign-on and are not stored by the service. The AD
#' Connector service account is not changed.
#' @param Password The password of an alternate account to use to disable single-sign on.
#' This is only used for AD Connector directories. For more information,
#' see the *UserName* parameter.
#'
#' @section Request syntax:
#' ```
#' svc$disable_sso(
#'   DirectoryId = "string",
#'   UserName = "string",
#'   Password = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_disable_sso
directoryservice_disable_sso <- function(DirectoryId, UserName = NULL, Password = NULL) {
  op <- new_operation(
    name = "DisableSso",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$disable_sso_input(DirectoryId = DirectoryId, UserName = UserName, Password = Password)
  output <- .directoryservice$disable_sso_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$disable_sso <- directoryservice_disable_sso

#' Activates the switch for the specific directory to always use LDAP
#' secure calls
#'
#' Activates the switch for the specific directory to always use LDAP
#' secure calls.
#'
#' @usage
#' directoryservice_enable_ldaps(DirectoryId, Type)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param Type &#91;required&#93; The type of LDAP security to enable. Currently only the value `Client`
#' is supported.
#'
#' @section Request syntax:
#' ```
#' svc$enable_ldaps(
#'   DirectoryId = "string",
#'   Type = "Client"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_enable_ldaps
directoryservice_enable_ldaps <- function(DirectoryId, Type) {
  op <- new_operation(
    name = "EnableLDAPS",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$enable_ldaps_input(DirectoryId = DirectoryId, Type = Type)
  output <- .directoryservice$enable_ldaps_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$enable_ldaps <- directoryservice_enable_ldaps

#' Enables multi-factor authentication (MFA) with the Remote Authentication
#' Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD
#' directory
#'
#' Enables multi-factor authentication (MFA) with the Remote Authentication
#' Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD
#' directory.
#'
#' @usage
#' directoryservice_enable_radius(DirectoryId, RadiusSettings)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to enable MFA.
#' @param RadiusSettings &#91;required&#93; A RadiusSettings object that contains information about the RADIUS
#' server.
#'
#' @section Request syntax:
#' ```
#' svc$enable_radius(
#'   DirectoryId = "string",
#'   RadiusSettings = list(
#'     RadiusServers = list(
#'       "string"
#'     ),
#'     RadiusPort = 123,
#'     RadiusTimeout = 123,
#'     RadiusRetries = 123,
#'     SharedSecret = "string",
#'     AuthenticationProtocol = "PAP"|"CHAP"|"MS-CHAPv1"|"MS-CHAPv2",
#'     DisplayLabel = "string",
#'     UseSameUsername = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_enable_radius
directoryservice_enable_radius <- function(DirectoryId, RadiusSettings) {
  op <- new_operation(
    name = "EnableRadius",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$enable_radius_input(DirectoryId = DirectoryId, RadiusSettings = RadiusSettings)
  output <- .directoryservice$enable_radius_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$enable_radius <- directoryservice_enable_radius

#' Enables single sign-on for a directory
#'
#' Enables single sign-on for a directory. Single sign-on allows users in
#' your directory to access certain AWS services from a computer joined to
#' the directory without having to enter their credentials separately.
#'
#' @usage
#' directoryservice_enable_sso(DirectoryId, UserName, Password)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to enable single-sign on.
#' @param UserName The username of an alternate account to use to enable single-sign on.
#' This is only used for AD Connector directories. This account must have
#' privileges to add a service principal name.
#' 
#' If the AD Connector service account does not have privileges to add a
#' service principal name, you can specify an alternate account with the
#' *UserName* and *Password* parameters. These credentials are only used to
#' enable single sign-on and are not stored by the service. The AD
#' Connector service account is not changed.
#' @param Password The password of an alternate account to use to enable single-sign on.
#' This is only used for AD Connector directories. For more information,
#' see the *UserName* parameter.
#'
#' @section Request syntax:
#' ```
#' svc$enable_sso(
#'   DirectoryId = "string",
#'   UserName = "string",
#'   Password = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_enable_sso
directoryservice_enable_sso <- function(DirectoryId, UserName = NULL, Password = NULL) {
  op <- new_operation(
    name = "EnableSso",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$enable_sso_input(DirectoryId = DirectoryId, UserName = UserName, Password = Password)
  output <- .directoryservice$enable_sso_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$enable_sso <- directoryservice_enable_sso

#' Obtains directory limit information for the current Region
#'
#' Obtains directory limit information for the current Region.
#'
#' @usage
#' directoryservice_get_directory_limits()
#'
#' @section Request syntax:
#' ```
#' svc$get_directory_limits()
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_get_directory_limits
directoryservice_get_directory_limits <- function() {
  op <- new_operation(
    name = "GetDirectoryLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$get_directory_limits_input()
  output <- .directoryservice$get_directory_limits_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$get_directory_limits <- directoryservice_get_directory_limits

#' Obtains the manual snapshot limits for a directory
#'
#' Obtains the manual snapshot limits for a directory.
#'
#' @usage
#' directoryservice_get_snapshot_limits(DirectoryId)
#'
#' @param DirectoryId &#91;required&#93; Contains the identifier of the directory to obtain the limits for.
#'
#' @section Request syntax:
#' ```
#' svc$get_snapshot_limits(
#'   DirectoryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_get_snapshot_limits
directoryservice_get_snapshot_limits <- function(DirectoryId) {
  op <- new_operation(
    name = "GetSnapshotLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$get_snapshot_limits_input(DirectoryId = DirectoryId)
  output <- .directoryservice$get_snapshot_limits_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$get_snapshot_limits <- directoryservice_get_snapshot_limits

#' For the specified directory, lists all the certificates registered for a
#' secured LDAP connection
#'
#' For the specified directory, lists all the certificates registered for a
#' secured LDAP connection.
#'
#' @usage
#' directoryservice_list_certificates(DirectoryId, NextToken, Limit)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param NextToken A token for requesting another page of certificates if the `NextToken`
#' response element indicates that more certificates are available. Use the
#' value of the returned `NextToken` element in your request until the
#' token comes back as `null`. Pass `null` if this is the first call.
#' @param Limit The number of items that should show up on one page
#'
#' @section Request syntax:
#' ```
#' svc$list_certificates(
#'   DirectoryId = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_list_certificates
directoryservice_list_certificates <- function(DirectoryId, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$list_certificates_input(DirectoryId = DirectoryId, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$list_certificates_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$list_certificates <- directoryservice_list_certificates

#' Lists the address blocks that you have added to a directory
#'
#' Lists the address blocks that you have added to a directory.
#'
#' @usage
#' directoryservice_list_ip_routes(DirectoryId, NextToken, Limit)
#'
#' @param DirectoryId &#91;required&#93; Identifier (ID) of the directory for which you want to retrieve the IP
#' addresses.
#' @param NextToken The *ListIpRoutes.NextToken* value from a previous call to ListIpRoutes.
#' Pass null if this is the first call.
#' @param Limit Maximum number of items to return. If this value is zero, the maximum
#' number of items is specified by the limitations of the operation.
#'
#' @section Request syntax:
#' ```
#' svc$list_ip_routes(
#'   DirectoryId = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_list_ip_routes
directoryservice_list_ip_routes <- function(DirectoryId, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListIpRoutes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$list_ip_routes_input(DirectoryId = DirectoryId, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$list_ip_routes_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$list_ip_routes <- directoryservice_list_ip_routes

#' Lists the active log subscriptions for the AWS account
#'
#' Lists the active log subscriptions for the AWS account.
#'
#' @usage
#' directoryservice_list_log_subscriptions(DirectoryId, NextToken, Limit)
#'
#' @param DirectoryId If a *DirectoryID* is provided, lists only the log subscription
#' associated with that directory. If no *DirectoryId* is provided, lists
#' all log subscriptions associated with your AWS account. If there are no
#' log subscriptions for the AWS account or the directory, an empty list
#' will be returned.
#' @param NextToken The token for the next set of items to return.
#' @param Limit The maximum number of items returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_log_subscriptions(
#'   DirectoryId = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_list_log_subscriptions
directoryservice_list_log_subscriptions <- function(DirectoryId = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListLogSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$list_log_subscriptions_input(DirectoryId = DirectoryId, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$list_log_subscriptions_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$list_log_subscriptions <- directoryservice_list_log_subscriptions

#' Lists all schema extensions applied to a Microsoft AD Directory
#'
#' Lists all schema extensions applied to a Microsoft AD Directory.
#'
#' @usage
#' directoryservice_list_schema_extensions(DirectoryId, NextToken, Limit)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory from which to retrieve the schema
#' extension information.
#' @param NextToken The `ListSchemaExtensions.NextToken` value from a previous call to
#' `ListSchemaExtensions`. Pass null if this is the first call.
#' @param Limit The maximum number of items to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_schema_extensions(
#'   DirectoryId = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_list_schema_extensions
directoryservice_list_schema_extensions <- function(DirectoryId, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListSchemaExtensions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$list_schema_extensions_input(DirectoryId = DirectoryId, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$list_schema_extensions_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$list_schema_extensions <- directoryservice_list_schema_extensions

#' Lists all tags on a directory
#'
#' Lists all tags on a directory.
#'
#' @usage
#' directoryservice_list_tags_for_resource(ResourceId, NextToken, Limit)
#'
#' @param ResourceId &#91;required&#93; Identifier (ID) of the directory for which you want to retrieve tags.
#' @param NextToken Reserved for future use.
#' @param Limit Reserved for future use.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceId = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_list_tags_for_resource
directoryservice_list_tags_for_resource <- function(ResourceId, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$list_tags_for_resource_input(ResourceId = ResourceId, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$list_tags_for_resource <- directoryservice_list_tags_for_resource

#' Registers a certificate for secured LDAP connection
#'
#' Registers a certificate for secured LDAP connection.
#'
#' @usage
#' directoryservice_register_certificate(DirectoryId, CertificateData)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param CertificateData &#91;required&#93; The certificate PEM string that needs to be registered.
#'
#' @section Request syntax:
#' ```
#' svc$register_certificate(
#'   DirectoryId = "string",
#'   CertificateData = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_register_certificate
directoryservice_register_certificate <- function(DirectoryId, CertificateData) {
  op <- new_operation(
    name = "RegisterCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$register_certificate_input(DirectoryId = DirectoryId, CertificateData = CertificateData)
  output <- .directoryservice$register_certificate_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$register_certificate <- directoryservice_register_certificate

#' Associates a directory with an SNS topic
#'
#' Associates a directory with an SNS topic. This establishes the directory
#' as a publisher to the specified SNS topic. You can then receive email or
#' text (SMS) messages when the status of your directory changes. You get
#' notified if your directory goes from an Active status to an Impaired or
#' Inoperable status. You also receive a notification when the directory
#' returns to an Active status.
#'
#' @usage
#' directoryservice_register_event_topic(DirectoryId, TopicName)
#'
#' @param DirectoryId &#91;required&#93; The Directory ID that will publish status messages to the SNS topic.
#' @param TopicName &#91;required&#93; The SNS topic name to which the directory will publish status messages.
#' This SNS topic must be in the same region as the specified Directory ID.
#'
#' @section Request syntax:
#' ```
#' svc$register_event_topic(
#'   DirectoryId = "string",
#'   TopicName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_register_event_topic
directoryservice_register_event_topic <- function(DirectoryId, TopicName) {
  op <- new_operation(
    name = "RegisterEventTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$register_event_topic_input(DirectoryId = DirectoryId, TopicName = TopicName)
  output <- .directoryservice$register_event_topic_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$register_event_topic <- directoryservice_register_event_topic

#' Rejects a directory sharing request that was sent from the directory
#' owner account
#'
#' Rejects a directory sharing request that was sent from the directory
#' owner account.
#'
#' @usage
#' directoryservice_reject_shared_directory(SharedDirectoryId)
#'
#' @param SharedDirectoryId &#91;required&#93; Identifier of the shared directory in the directory consumer account.
#' This identifier is different for each directory owner account.
#'
#' @section Request syntax:
#' ```
#' svc$reject_shared_directory(
#'   SharedDirectoryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_reject_shared_directory
directoryservice_reject_shared_directory <- function(SharedDirectoryId) {
  op <- new_operation(
    name = "RejectSharedDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$reject_shared_directory_input(SharedDirectoryId = SharedDirectoryId)
  output <- .directoryservice$reject_shared_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$reject_shared_directory <- directoryservice_reject_shared_directory

#' Removes IP address blocks from a directory
#'
#' Removes IP address blocks from a directory.
#'
#' @usage
#' directoryservice_remove_ip_routes(DirectoryId, CidrIps)
#'
#' @param DirectoryId &#91;required&#93; Identifier (ID) of the directory from which you want to remove the IP
#' addresses.
#' @param CidrIps &#91;required&#93; IP address blocks that you want to remove.
#'
#' @section Request syntax:
#' ```
#' svc$remove_ip_routes(
#'   DirectoryId = "string",
#'   CidrIps = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_remove_ip_routes
directoryservice_remove_ip_routes <- function(DirectoryId, CidrIps) {
  op <- new_operation(
    name = "RemoveIpRoutes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$remove_ip_routes_input(DirectoryId = DirectoryId, CidrIps = CidrIps)
  output <- .directoryservice$remove_ip_routes_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$remove_ip_routes <- directoryservice_remove_ip_routes

#' Removes tags from a directory
#'
#' Removes tags from a directory.
#'
#' @usage
#' directoryservice_remove_tags_from_resource(ResourceId, TagKeys)
#'
#' @param ResourceId &#91;required&#93; Identifier (ID) of the directory from which to remove the tag.
#' @param TagKeys &#91;required&#93; The tag key (name) of the tag to be removed.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_resource(
#'   ResourceId = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_remove_tags_from_resource
directoryservice_remove_tags_from_resource <- function(ResourceId, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$remove_tags_from_resource_input(ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .directoryservice$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$remove_tags_from_resource <- directoryservice_remove_tags_from_resource

#' Resets the password for any user in your AWS Managed Microsoft AD or
#' Simple AD directory
#'
#' Resets the password for any user in your AWS Managed Microsoft AD or
#' Simple AD directory.
#' 
#' You can reset the password for any user in your directory with the
#' following exceptions:
#' 
#' -   For Simple AD, you cannot reset the password for any user that is a
#'     member of either the **Domain Admins** or **Enterprise Admins**
#'     group except for the administrator user.
#' 
#' -   For AWS Managed Microsoft AD, you can only reset the password for a
#'     user that is in an OU based off of the NetBIOS name that you typed
#'     when you created your directory. For example, you cannot reset the
#'     password for a user in the **AWS Reserved** OU. For more information
#'     about the OU structure for an AWS Managed Microsoft AD directory,
#'     see [What Gets
#'     Created](https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ms_ad_getting_started_what_gets_created.html)
#'     in the *AWS Directory Service Administration Guide*.
#'
#' @usage
#' directoryservice_reset_user_password(DirectoryId, UserName, NewPassword)
#'
#' @param DirectoryId &#91;required&#93; Identifier of the AWS Managed Microsoft AD or Simple AD directory in
#' which the user resides.
#' @param UserName &#91;required&#93; The user name of the user whose password will be reset.
#' @param NewPassword &#91;required&#93; The new password that will be reset.
#'
#' @section Request syntax:
#' ```
#' svc$reset_user_password(
#'   DirectoryId = "string",
#'   UserName = "string",
#'   NewPassword = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_reset_user_password
directoryservice_reset_user_password <- function(DirectoryId, UserName, NewPassword) {
  op <- new_operation(
    name = "ResetUserPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$reset_user_password_input(DirectoryId = DirectoryId, UserName = UserName, NewPassword = NewPassword)
  output <- .directoryservice$reset_user_password_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$reset_user_password <- directoryservice_reset_user_password

#' Restores a directory using an existing directory snapshot
#'
#' Restores a directory using an existing directory snapshot.
#' 
#' When you restore a directory from a snapshot, any changes made to the
#' directory after the snapshot date are overwritten.
#' 
#' This action returns as soon as the restore operation is initiated. You
#' can monitor the progress of the restore operation by calling the
#' DescribeDirectories operation with the directory identifier. When the
#' **DirectoryDescription.Stage** value changes to `Active`, the restore
#' operation is complete.
#'
#' @usage
#' directoryservice_restore_from_snapshot(SnapshotId)
#'
#' @param SnapshotId &#91;required&#93; The identifier of the snapshot to restore from.
#'
#' @section Request syntax:
#' ```
#' svc$restore_from_snapshot(
#'   SnapshotId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_restore_from_snapshot
directoryservice_restore_from_snapshot <- function(SnapshotId) {
  op <- new_operation(
    name = "RestoreFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$restore_from_snapshot_input(SnapshotId = SnapshotId)
  output <- .directoryservice$restore_from_snapshot_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$restore_from_snapshot <- directoryservice_restore_from_snapshot

#' Shares a specified directory (DirectoryId) in your AWS account
#' (directory owner) with another AWS account (directory consumer)
#'
#' Shares a specified directory (`DirectoryId`) in your AWS account
#' (directory owner) with another AWS account (directory consumer). With
#' this operation you can use your directory from any AWS account and from
#' any Amazon VPC within an AWS Region.
#' 
#' When you share your AWS Managed Microsoft AD directory, AWS Directory
#' Service creates a shared directory in the directory consumer account.
#' This shared directory contains the metadata to provide access to the
#' directory within the directory owner account. The shared directory is
#' visible in all VPCs in the directory consumer account.
#' 
#' The `ShareMethod` parameter determines whether the specified directory
#' can be shared between AWS accounts inside the same AWS organization
#' (`ORGANIZATIONS`). It also determines whether you can share the
#' directory with any other AWS account either inside or outside of the
#' organization (`HANDSHAKE`).
#' 
#' The `ShareNotes` parameter is only used when `HANDSHAKE` is called,
#' which sends a directory sharing request to the directory consumer.
#'
#' @usage
#' directoryservice_share_directory(DirectoryId, ShareNotes, ShareTarget,
#'   ShareMethod)
#'
#' @param DirectoryId &#91;required&#93; Identifier of the AWS Managed Microsoft AD directory that you want to
#' share with other AWS accounts.
#' @param ShareNotes A directory share request that is sent by the directory owner to the
#' directory consumer. The request includes a typed message to help the
#' directory consumer administrator determine whether to approve or reject
#' the share invitation.
#' @param ShareTarget &#91;required&#93; Identifier for the directory consumer account with whom the directory is
#' to be shared.
#' @param ShareMethod &#91;required&#93; The method used when sharing a directory to determine whether the
#' directory should be shared within your AWS organization
#' (`ORGANIZATIONS`) or with any AWS account by sending a directory sharing
#' request (`HANDSHAKE`).
#'
#' @section Request syntax:
#' ```
#' svc$share_directory(
#'   DirectoryId = "string",
#'   ShareNotes = "string",
#'   ShareTarget = list(
#'     Id = "string",
#'     Type = "ACCOUNT"
#'   ),
#'   ShareMethod = "ORGANIZATIONS"|"HANDSHAKE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_share_directory
directoryservice_share_directory <- function(DirectoryId, ShareNotes = NULL, ShareTarget, ShareMethod) {
  op <- new_operation(
    name = "ShareDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$share_directory_input(DirectoryId = DirectoryId, ShareNotes = ShareNotes, ShareTarget = ShareTarget, ShareMethod = ShareMethod)
  output <- .directoryservice$share_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$share_directory <- directoryservice_share_directory

#' Applies a schema extension to a Microsoft AD directory
#'
#' Applies a schema extension to a Microsoft AD directory.
#'
#' @usage
#' directoryservice_start_schema_extension(DirectoryId,
#'   CreateSnapshotBeforeSchemaExtension, LdifContent, Description)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which the schema extension will be
#' applied to.
#' @param CreateSnapshotBeforeSchemaExtension &#91;required&#93; If true, creates a snapshot of the directory before applying the schema
#' extension.
#' @param LdifContent &#91;required&#93; The LDIF file represented as a string. To construct the LdifContent
#' string, precede each line as it would be formatted in an ldif file with
#' `\\n`. See the example request below for more details. The file size can
#' be no larger than 1MB.
#' @param Description &#91;required&#93; A description of the schema extension.
#'
#' @section Request syntax:
#' ```
#' svc$start_schema_extension(
#'   DirectoryId = "string",
#'   CreateSnapshotBeforeSchemaExtension = TRUE|FALSE,
#'   LdifContent = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_start_schema_extension
directoryservice_start_schema_extension <- function(DirectoryId, CreateSnapshotBeforeSchemaExtension, LdifContent, Description) {
  op <- new_operation(
    name = "StartSchemaExtension",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$start_schema_extension_input(DirectoryId = DirectoryId, CreateSnapshotBeforeSchemaExtension = CreateSnapshotBeforeSchemaExtension, LdifContent = LdifContent, Description = Description)
  output <- .directoryservice$start_schema_extension_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$start_schema_extension <- directoryservice_start_schema_extension

#' Stops the directory sharing between the directory owner and consumer
#' accounts
#'
#' Stops the directory sharing between the directory owner and consumer
#' accounts.
#'
#' @usage
#' directoryservice_unshare_directory(DirectoryId, UnshareTarget)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the AWS Managed Microsoft AD directory that you want
#' to stop sharing.
#' @param UnshareTarget &#91;required&#93; Identifier for the directory consumer account with whom the directory
#' has to be unshared.
#'
#' @section Request syntax:
#' ```
#' svc$unshare_directory(
#'   DirectoryId = "string",
#'   UnshareTarget = list(
#'     Id = "string",
#'     Type = "ACCOUNT"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_unshare_directory
directoryservice_unshare_directory <- function(DirectoryId, UnshareTarget) {
  op <- new_operation(
    name = "UnshareDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$unshare_directory_input(DirectoryId = DirectoryId, UnshareTarget = UnshareTarget)
  output <- .directoryservice$unshare_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$unshare_directory <- directoryservice_unshare_directory

#' Updates a conditional forwarder that has been set up for your AWS
#' directory
#'
#' Updates a conditional forwarder that has been set up for your AWS
#' directory.
#'
#' @usage
#' directoryservice_update_conditional_forwarder(DirectoryId,
#'   RemoteDomainName, DnsIpAddrs)
#'
#' @param DirectoryId &#91;required&#93; The directory ID of the AWS directory for which to update the
#' conditional forwarder.
#' @param RemoteDomainName &#91;required&#93; The fully qualified domain name (FQDN) of the remote domain with which
#' you will set up a trust relationship.
#' @param DnsIpAddrs &#91;required&#93; The updated IP addresses of the remote DNS server associated with the
#' conditional forwarder.
#'
#' @section Request syntax:
#' ```
#' svc$update_conditional_forwarder(
#'   DirectoryId = "string",
#'   RemoteDomainName = "string",
#'   DnsIpAddrs = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_update_conditional_forwarder
directoryservice_update_conditional_forwarder <- function(DirectoryId, RemoteDomainName, DnsIpAddrs) {
  op <- new_operation(
    name = "UpdateConditionalForwarder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$update_conditional_forwarder_input(DirectoryId = DirectoryId, RemoteDomainName = RemoteDomainName, DnsIpAddrs = DnsIpAddrs)
  output <- .directoryservice$update_conditional_forwarder_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$update_conditional_forwarder <- directoryservice_update_conditional_forwarder

#' Adds or removes domain controllers to or from the directory
#'
#' Adds or removes domain controllers to or from the directory. Based on
#' the difference between current value and new value (provided through
#' this API call), domain controllers will be added or removed. It may take
#' up to 45 minutes for any new domain controllers to become fully active
#' once the requested number of domain controllers is updated. During this
#' time, you cannot make another update request.
#'
#' @usage
#' directoryservice_update_number_of_domain_controllers(DirectoryId,
#'   DesiredNumber)
#'
#' @param DirectoryId &#91;required&#93; Identifier of the directory to which the domain controllers will be
#' added or removed.
#' @param DesiredNumber &#91;required&#93; The number of domain controllers desired in the directory.
#'
#' @section Request syntax:
#' ```
#' svc$update_number_of_domain_controllers(
#'   DirectoryId = "string",
#'   DesiredNumber = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_update_number_of_domain_controllers
directoryservice_update_number_of_domain_controllers <- function(DirectoryId, DesiredNumber) {
  op <- new_operation(
    name = "UpdateNumberOfDomainControllers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$update_number_of_domain_controllers_input(DirectoryId = DirectoryId, DesiredNumber = DesiredNumber)
  output <- .directoryservice$update_number_of_domain_controllers_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$update_number_of_domain_controllers <- directoryservice_update_number_of_domain_controllers

#' Updates the Remote Authentication Dial In User Service (RADIUS) server
#' information for an AD Connector or Microsoft AD directory
#'
#' Updates the Remote Authentication Dial In User Service (RADIUS) server
#' information for an AD Connector or Microsoft AD directory.
#'
#' @usage
#' directoryservice_update_radius(DirectoryId, RadiusSettings)
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to update the RADIUS server
#' information.
#' @param RadiusSettings &#91;required&#93; A RadiusSettings object that contains information about the RADIUS
#' server.
#'
#' @section Request syntax:
#' ```
#' svc$update_radius(
#'   DirectoryId = "string",
#'   RadiusSettings = list(
#'     RadiusServers = list(
#'       "string"
#'     ),
#'     RadiusPort = 123,
#'     RadiusTimeout = 123,
#'     RadiusRetries = 123,
#'     SharedSecret = "string",
#'     AuthenticationProtocol = "PAP"|"CHAP"|"MS-CHAPv1"|"MS-CHAPv2",
#'     DisplayLabel = "string",
#'     UseSameUsername = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_update_radius
directoryservice_update_radius <- function(DirectoryId, RadiusSettings) {
  op <- new_operation(
    name = "UpdateRadius",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$update_radius_input(DirectoryId = DirectoryId, RadiusSettings = RadiusSettings)
  output <- .directoryservice$update_radius_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$update_radius <- directoryservice_update_radius

#' Updates the trust that has been set up between your AWS Managed
#' Microsoft AD directory and an on-premises Active Directory
#'
#' Updates the trust that has been set up between your AWS Managed
#' Microsoft AD directory and an on-premises Active Directory.
#'
#' @usage
#' directoryservice_update_trust(TrustId, SelectiveAuth)
#'
#' @param TrustId &#91;required&#93; Identifier of the trust relationship.
#' @param SelectiveAuth Updates selective authentication for the trust.
#'
#' @section Request syntax:
#' ```
#' svc$update_trust(
#'   TrustId = "string",
#'   SelectiveAuth = "Enabled"|"Disabled"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_update_trust
directoryservice_update_trust <- function(TrustId, SelectiveAuth = NULL) {
  op <- new_operation(
    name = "UpdateTrust",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$update_trust_input(TrustId = TrustId, SelectiveAuth = SelectiveAuth)
  output <- .directoryservice$update_trust_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$update_trust <- directoryservice_update_trust

#' AWS Directory Service for Microsoft Active Directory allows you to
#' configure and verify trust relationships
#'
#' AWS Directory Service for Microsoft Active Directory allows you to
#' configure and verify trust relationships.
#' 
#' This action verifies a trust relationship between your AWS Managed
#' Microsoft AD directory and an external domain.
#'
#' @usage
#' directoryservice_verify_trust(TrustId)
#'
#' @param TrustId &#91;required&#93; The unique Trust ID of the trust relationship to verify.
#'
#' @section Request syntax:
#' ```
#' svc$verify_trust(
#'   TrustId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname directoryservice_verify_trust
directoryservice_verify_trust <- function(TrustId) {
  op <- new_operation(
    name = "VerifyTrust",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$verify_trust_input(TrustId = TrustId)
  output <- .directoryservice$verify_trust_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$verify_trust <- directoryservice_verify_trust
