% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_list_object_parents}
\alias{clouddirectory_list_object_parents}
\title{Lists parent objects that are associated with a given object in
pagination fashion}
\usage{
clouddirectory_list_object_parents(DirectoryArn, ObjectReference,
  NextToken, MaxResults, ConsistencyLevel, IncludeAllLinksToEachParent)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
where the object resides. For more information, see arns.}

\item{ObjectReference}{[required] The reference that identifies the object for which parent objects are
being listed.}

\item{NextToken}{The pagination token.}

\item{MaxResults}{The maximum number of items to be retrieved in a single call. This is an
approximate number.}

\item{ConsistencyLevel}{Represents the manner and timing in which the successful write or update
of an object is reflected in a subsequent read operation of that same
object.}

\item{IncludeAllLinksToEachParent}{When set to True, returns all ListObjectParentsResponse\\$ParentLinks.
There could be multiple links between a parent-child pair.}
}
\description{
Lists parent objects that are associated with a given object in
pagination fashion.
}
\section{Request syntax}{
\preformatted{svc$list_object_parents(
  DirectoryArn = "string",
  ObjectReference = list(
    Selector = "string"
  ),
  NextToken = "string",
  MaxResults = 123,
  ConsistencyLevel = "SERIALIZABLE"|"EVENTUAL",
  IncludeAllLinksToEachParent = TRUE|FALSE
)
}
}

\keyword{internal}
