% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_encrypt}
\alias{kms_encrypt}
\title{Encrypts plaintext of up to 4,096 bytes using a KMS key}
\usage{
kms_encrypt(
  KeyId,
  Plaintext,
  EncryptionContext = NULL,
  GrantTokens = NULL,
  EncryptionAlgorithm = NULL
)
}
\arguments{
\item{KeyId}{[required] Identifies the KMS key to use in the encryption operation. The KMS key
must have a \code{KeyUsage} of \code{ENCRYPT_DECRYPT}. To find the \code{KeyUsage} of a
KMS key, use the \code{\link[=kms_describe_key]{describe_key}} operation.

To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
When using an alias name, prefix it with \code{"alias/"}. To specify a KMS
key in a different Amazon Web Services account, you must use the key ARN
or alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}. To
get the alias name and alias ARN, use
\code{\link[=kms_list_aliases]{list_aliases}}.}

\item{Plaintext}{[required] Data to be encrypted.}

\item{EncryptionContext}{Specifies the encryption context that will be used to encrypt the data.
An encryption context is valid only for \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations}{cryptographic operations}
with a symmetric encryption KMS key. The standard asymmetric encryption
algorithms and HMAC algorithms that KMS uses do not support an
encryption context.

An \emph{encryption context} is a collection of non-secret key-value pairs
that represent additional authenticated data. When you use an encryption
context to encrypt data, you must specify the same (an exact
case-sensitive match) encryption context to decrypt the data. An
encryption context is supported only on operations with symmetric
encryption KMS keys. On operations with symmetric encryption KMS keys,
an encryption context is optional, but it is strongly recommended.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{Encryption context}
in the \emph{Key Management Service Developer Guide}.}

\item{GrantTokens}{A list of grant tokens.

Use a grant token when your permission to call this operation comes from
a new grant that has not yet achieved \emph{eventual consistency}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token}{Grant token}
and \href{https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token}{Using a grant token}
in the \emph{Key Management Service Developer Guide}.}

\item{EncryptionAlgorithm}{Specifies the encryption algorithm that KMS will use to encrypt the
plaintext message. The algorithm must be compatible with the KMS key
that you specify.

This parameter is required only for asymmetric KMS keys. The default
value, \code{SYMMETRIC_DEFAULT}, is the algorithm used for symmetric
encryption KMS keys. If you are using an asymmetric KMS key, we
recommend RSAES_OAEP_SHA_256.}
}
\description{
Encrypts plaintext of up to 4,096 bytes using a KMS key. You can use a symmetric or asymmetric KMS key with a \code{KeyUsage} of \code{ENCRYPT_DECRYPT}.

See \url{https://paws-r.github.io/docs/kms/encrypt.html} for full documentation.
}
\keyword{internal}
