# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include secretsmanager_service.R
NULL

#' Turns off automatic rotation, and if a rotation is currently in
#' progress, cancels the rotation
#'
#' @description
#' Turns off automatic rotation, and if a rotation is currently in progress, cancels the rotation.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_cancel_rotate_secret/](https://www.paws-r-sdk.com/docs/secretsmanager_cancel_rotate_secret/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#'
#' @keywords internal
#'
#' @rdname secretsmanager_cancel_rotate_secret
secretsmanager_cancel_rotate_secret <- function(SecretId) {
  op <- new_operation(
    name = "CancelRotateSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$cancel_rotate_secret_input(SecretId = SecretId)
  output <- .secretsmanager$cancel_rotate_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$cancel_rotate_secret <- secretsmanager_cancel_rotate_secret

#' Creates a new secret
#'
#' @description
#' Creates a new secret. A *secret* can be a password, a set of credentials such as a user name and password, an OAuth token, or other secret information that you store in an encrypted form in Secrets Manager. The secret also includes the connection information to access a database or other service, which Secrets Manager doesn't encrypt. A secret in Secrets Manager consists of both the protected secret data and the important information needed to manage the secret.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_create_secret/](https://www.paws-r-sdk.com/docs/secretsmanager_create_secret/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the new secret.
#' 
#' The secret name can contain ASCII letters, numbers, and the following
#' characters: /_+=.@@-
#' 
#' Do not end your secret name with a hyphen followed by six characters. If
#' you do so, you risk confusion and unexpected results when searching for
#' a secret by partial ARN. Secrets Manager automatically adds a hyphen and
#' six random characters after the secret name at the end of the ARN.
#' @param ClientRequestToken If you include `SecretString` or `SecretBinary`, then Secrets Manager
#' creates an initial version for the secret, and this parameter specifies
#' the unique identifier for the new version.
#' 
#' If you use the Amazon Web Services CLI or one of the Amazon Web Services
#' SDKs to call this operation, then you can leave this parameter empty.
#' The CLI or SDK generates a random UUID for you and includes it as the
#' value for this parameter in the request. If you don't use the SDK and
#' instead generate a raw HTTP request to the Secrets Manager service
#' endpoint, then you must generate a `ClientRequestToken` yourself for the
#' new version and include the value in the request.
#' 
#' This value helps ensure idempotency. Secrets Manager uses this value to
#' prevent the accidental creation of duplicate versions if there are
#' failures and retries during a rotation. We recommend that you generate a
#' [UUID-type](https://en.wikipedia.org/wiki/Universally_unique_identifier)
#' value to ensure uniqueness of your versions within the specified secret.
#' 
#' -   If the `ClientRequestToken` value isn't already associated with a
#'     version of the secret then a new version of the secret is created.
#' 
#' -   If a version with this value already exists and the version
#'     `SecretString` and `SecretBinary` values are the same as those in
#'     the request, then the request is ignored.
#' 
#' -   If a version with this value already exists and that version's
#'     `SecretString` and `SecretBinary` values are different from those in
#'     the request, then the request fails because you cannot modify an
#'     existing version. Instead, use
#'     [`put_secret_value`][secretsmanager_put_secret_value] to create a
#'     new version.
#' 
#' This value becomes the `VersionId` of the new version.
#' @param Description The description of the secret.
#' @param KmsKeyId The ARN, key ID, or alias of the KMS key that Secrets Manager uses to
#' encrypt the secret value in the secret. An alias is always prefixed by
#' `alias/`, for example `alias/aws/secretsmanager`. For more information,
#' see [About
#' aliases](https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html).
#' 
#' To use a KMS key in a different account, use the key ARN or the alias
#' ARN.
#' 
#' If you don't specify this value, then Secrets Manager uses the key
#' `aws/secretsmanager`. If that key doesn't yet exist, then Secrets
#' Manager creates it for you automatically the first time it encrypts the
#' secret value.
#' 
#' If the secret is in a different Amazon Web Services account from the
#' credentials calling the API, then you can't use `aws/secretsmanager` to
#' encrypt the secret, and you must create and use a customer managed KMS
#' key.
#' @param SecretBinary The binary data to encrypt and store in the new version of the secret.
#' We recommend that you store your binary data in a file and then pass the
#' contents of the file as a parameter.
#' 
#' Either `SecretString` or `SecretBinary` must have a value, but not both.
#' 
#' This parameter is not available in the Secrets Manager console.
#' @param SecretString The text data to encrypt and store in this new version of the secret. We
#' recommend you use a JSON structure of key/value pairs for your secret
#' value.
#' 
#' Either `SecretString` or `SecretBinary` must have a value, but not both.
#' 
#' If you create a secret by using the Secrets Manager console then Secrets
#' Manager puts the protected secret text in only the `SecretString`
#' parameter. The Secrets Manager console stores the information as a JSON
#' structure of key/value pairs that a Lambda rotation function can parse.
#' @param Tags A list of tags to attach to the secret. Each tag is a key and value pair
#' of strings in a JSON text string, for example:
#' 
#' `[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]`
#' 
#' Secrets Manager tag key names are case sensitive. A tag with the key
#' "ABC" is a different tag from one with key "abc".
#' 
#' If you check tags in permissions policies as part of your security
#' strategy, then adding or removing a tag can change permissions. If the
#' completion of this operation would result in you losing your permissions
#' for this secret, then Secrets Manager blocks the operation and returns
#' an `Access Denied` error. For more information, see [Control access to
#' secrets using
#' tags](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac)
#' and [Limit access to identities with tags that match secrets'
#' tags](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2).
#' 
#' For information about how to format a JSON parameter for the various
#' command line tool environments, see [Using JSON for
#' Parameters](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json).
#' If your command-line tool or SDK requires quotation marks around the
#' parameter, you should use single quotes to avoid confusion with the
#' double quotes required in the JSON text.
#' 
#' The following restrictions apply to tags:
#' 
#' -   Maximum number of tags per secret: 50
#' 
#' -   Maximum key length: 127 Unicode characters in UTF-8
#' 
#' -   Maximum value length: 255 Unicode characters in UTF-8
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use the `aws:` prefix in your tag names or values because
#'     Amazon Web Services reserves it for Amazon Web Services use. You
#'     can't edit or delete tag names or values with this prefix. Tags with
#'     this prefix do not count against your tags per secret limit.
#' 
#' -   If you use your tagging schema across multiple services and
#'     resources, other services might have restrictions on allowed
#'     characters. Generally allowed characters: letters, spaces, and
#'     numbers representable in UTF-8, plus the following special
#'     characters: + - = . _ : / @@.
#' @param AddReplicaRegions A list of Regions and KMS keys to replicate secrets.
#' @param ForceOverwriteReplicaSecret Specifies whether to overwrite a secret with the same name in the
#' destination Region. By default, secrets aren't overwritten.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_create_secret
secretsmanager_create_secret <- function(Name, ClientRequestToken = NULL, Description = NULL, KmsKeyId = NULL, SecretBinary = NULL, SecretString = NULL, Tags = NULL, AddReplicaRegions = NULL, ForceOverwriteReplicaSecret = NULL) {
  op <- new_operation(
    name = "CreateSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$create_secret_input(Name = Name, ClientRequestToken = ClientRequestToken, Description = Description, KmsKeyId = KmsKeyId, SecretBinary = SecretBinary, SecretString = SecretString, Tags = Tags, AddReplicaRegions = AddReplicaRegions, ForceOverwriteReplicaSecret = ForceOverwriteReplicaSecret)
  output <- .secretsmanager$create_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$create_secret <- secretsmanager_create_secret

#' Deletes the resource-based permission policy attached to the secret
#'
#' @description
#' Deletes the resource-based permission policy attached to the secret. To attach a policy to a secret, use [`put_resource_policy`][secretsmanager_put_resource_policy].
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_delete_resource_policy/](https://www.paws-r-sdk.com/docs/secretsmanager_delete_resource_policy/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret to delete the attached resource-based
#' policy for.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#'
#' @keywords internal
#'
#' @rdname secretsmanager_delete_resource_policy
secretsmanager_delete_resource_policy <- function(SecretId) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$delete_resource_policy_input(SecretId = SecretId)
  output <- .secretsmanager$delete_resource_policy_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$delete_resource_policy <- secretsmanager_delete_resource_policy

#' Deletes a secret and all of its versions
#'
#' @description
#' Deletes a secret and all of its versions. You can specify a recovery window during which you can restore the secret. The minimum recovery window is 7 days. The default recovery window is 30 days. Secrets Manager attaches a `DeletionDate` stamp to the secret that specifies the end of the recovery window. At the end of the recovery window, Secrets Manager deletes the secret permanently.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_delete_secret/](https://www.paws-r-sdk.com/docs/secretsmanager_delete_secret/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret to delete.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#' @param RecoveryWindowInDays The number of days from 7 to 30 that Secrets Manager waits before
#' permanently deleting the secret. You can't use both this parameter and
#' `ForceDeleteWithoutRecovery` in the same call. If you don't use either,
#' then by default Secrets Manager uses a 30 day recovery window.
#' @param ForceDeleteWithoutRecovery Specifies whether to delete the secret without any recovery window. You
#' can't use both this parameter and `RecoveryWindowInDays` in the same
#' call. If you don't use either, then by default Secrets Manager uses a 30
#' day recovery window.
#' 
#' Secrets Manager performs the actual deletion with an asynchronous
#' background process, so there might be a short delay before the secret is
#' permanently deleted. If you delete a secret and then immediately create
#' a secret with the same name, use appropriate back off and retry logic.
#' 
#' If you forcibly delete an already deleted or nonexistent secret, the
#' operation does not return `ResourceNotFoundException`.
#' 
#' Use this parameter with caution. This parameter causes the operation to
#' skip the normal recovery window before the permanent deletion that
#' Secrets Manager would normally impose with the `RecoveryWindowInDays`
#' parameter. If you delete a secret with the `ForceDeleteWithoutRecovery`
#' parameter, then you have no opportunity to recover the secret. You lose
#' the secret permanently.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_delete_secret
secretsmanager_delete_secret <- function(SecretId, RecoveryWindowInDays = NULL, ForceDeleteWithoutRecovery = NULL) {
  op <- new_operation(
    name = "DeleteSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$delete_secret_input(SecretId = SecretId, RecoveryWindowInDays = RecoveryWindowInDays, ForceDeleteWithoutRecovery = ForceDeleteWithoutRecovery)
  output <- .secretsmanager$delete_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$delete_secret <- secretsmanager_delete_secret

#' Retrieves the details of a secret
#'
#' @description
#' Retrieves the details of a secret. It does not include the encrypted secret value. Secrets Manager only returns fields that have a value in the response.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_describe_secret/](https://www.paws-r-sdk.com/docs/secretsmanager_describe_secret/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#'
#' @keywords internal
#'
#' @rdname secretsmanager_describe_secret
secretsmanager_describe_secret <- function(SecretId) {
  op <- new_operation(
    name = "DescribeSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$describe_secret_input(SecretId = SecretId)
  output <- .secretsmanager$describe_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$describe_secret <- secretsmanager_describe_secret

#' Generates a random password
#'
#' @description
#' Generates a random password. We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_get_random_password/](https://www.paws-r-sdk.com/docs/secretsmanager_get_random_password/) for full documentation.
#'
#' @param PasswordLength The length of the password. If you don't include this parameter, the
#' default length is 32 characters.
#' @param ExcludeCharacters A string of the characters that you don't want in the password.
#' @param ExcludeNumbers Specifies whether to exclude numbers from the password. If you don't
#' include this switch, the password can contain numbers.
#' @param ExcludePunctuation Specifies whether to exclude the following punctuation characters from
#' the password:
#' `` ! \" # $ % & \' ( ) * + , - . / : ; < = > ? @@ [ \ ] ^ _ \` { | } ~ ``.
#' If you don't include this switch, the password can contain punctuation.
#' @param ExcludeUppercase Specifies whether to exclude uppercase letters from the password. If you
#' don't include this switch, the password can contain uppercase letters.
#' @param ExcludeLowercase Specifies whether to exclude lowercase letters from the password. If you
#' don't include this switch, the password can contain lowercase letters.
#' @param IncludeSpace Specifies whether to include the space character. If you include this
#' switch, the password can contain space characters.
#' @param RequireEachIncludedType Specifies whether to include at least one upper and lowercase letter,
#' one number, and one punctuation. If you don't include this switch, the
#' password contains at least one of every character type.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_get_random_password
secretsmanager_get_random_password <- function(PasswordLength = NULL, ExcludeCharacters = NULL, ExcludeNumbers = NULL, ExcludePunctuation = NULL, ExcludeUppercase = NULL, ExcludeLowercase = NULL, IncludeSpace = NULL, RequireEachIncludedType = NULL) {
  op <- new_operation(
    name = "GetRandomPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$get_random_password_input(PasswordLength = PasswordLength, ExcludeCharacters = ExcludeCharacters, ExcludeNumbers = ExcludeNumbers, ExcludePunctuation = ExcludePunctuation, ExcludeUppercase = ExcludeUppercase, ExcludeLowercase = ExcludeLowercase, IncludeSpace = IncludeSpace, RequireEachIncludedType = RequireEachIncludedType)
  output <- .secretsmanager$get_random_password_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$get_random_password <- secretsmanager_get_random_password

#' Retrieves the JSON text of the resource-based policy document attached
#' to the secret
#'
#' @description
#' Retrieves the JSON text of the resource-based policy document attached to the secret. For more information about permissions policies attached to a secret, see [Permissions policies attached to a secret](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-policies.html).
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_get_resource_policy/](https://www.paws-r-sdk.com/docs/secretsmanager_get_resource_policy/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret to retrieve the attached resource-based
#' policy for.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#'
#' @keywords internal
#'
#' @rdname secretsmanager_get_resource_policy
secretsmanager_get_resource_policy <- function(SecretId) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$get_resource_policy_input(SecretId = SecretId)
  output <- .secretsmanager$get_resource_policy_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$get_resource_policy <- secretsmanager_get_resource_policy

#' Retrieves the contents of the encrypted fields SecretString or
#' SecretBinary from the specified version of a secret, whichever contains
#' content
#'
#' @description
#' Retrieves the contents of the encrypted fields `SecretString` or `SecretBinary` from the specified version of a secret, whichever contains content.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_get_secret_value/](https://www.paws-r-sdk.com/docs/secretsmanager_get_secret_value/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret to retrieve.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#' @param VersionId The unique identifier of the version of the secret to retrieve. If you
#' include both this parameter and `VersionStage`, the two parameters must
#' refer to the same secret version. If you don't specify either a
#' `VersionStage` or `VersionId`, then Secrets Manager returns the
#' `AWSCURRENT` version.
#' 
#' This value is typically a
#' [UUID-type](https://en.wikipedia.org/wiki/Universally_unique_identifier)
#' value with 32 hexadecimal digits.
#' @param VersionStage The staging label of the version of the secret to retrieve.
#' 
#' Secrets Manager uses staging labels to keep track of different versions
#' during the rotation process. If you include both this parameter and
#' `VersionId`, the two parameters must refer to the same secret version.
#' If you don't specify either a `VersionStage` or `VersionId`, Secrets
#' Manager returns the `AWSCURRENT` version.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_get_secret_value
secretsmanager_get_secret_value <- function(SecretId, VersionId = NULL, VersionStage = NULL) {
  op <- new_operation(
    name = "GetSecretValue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$get_secret_value_input(SecretId = SecretId, VersionId = VersionId, VersionStage = VersionStage)
  output <- .secretsmanager$get_secret_value_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$get_secret_value <- secretsmanager_get_secret_value

#' Lists the versions of a secret
#'
#' @description
#' Lists the versions of a secret. Secrets Manager uses staging labels to indicate the different versions of a secret. For more information, see [Secrets Manager concepts: Versions](https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version).
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_list_secret_version_ids/](https://www.paws-r-sdk.com/docs/secretsmanager_list_secret_version_ids/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret whose versions you want to list.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#' @param MaxResults The number of results to include in the response.
#' 
#' If there are more results available, in the response, Secrets Manager
#' includes `NextToken`. To get the next results, call
#' [`list_secret_version_ids`][secretsmanager_list_secret_version_ids]
#' again with the value from `NextToken`.
#' @param NextToken A token that indicates where the output should continue from, if a
#' previous call did not show all results. To get the next results, call
#' [`list_secret_version_ids`][secretsmanager_list_secret_version_ids]
#' again with this value.
#' @param IncludeDeprecated Specifies whether to include versions of secrets that don't have any
#' staging labels attached to them. Versions without staging labels are
#' considered deprecated and are subject to deletion by Secrets Manager. By
#' default, versions without staging labels aren't included.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_list_secret_version_ids
secretsmanager_list_secret_version_ids <- function(SecretId, MaxResults = NULL, NextToken = NULL, IncludeDeprecated = NULL) {
  op <- new_operation(
    name = "ListSecretVersionIds",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .secretsmanager$list_secret_version_ids_input(SecretId = SecretId, MaxResults = MaxResults, NextToken = NextToken, IncludeDeprecated = IncludeDeprecated)
  output <- .secretsmanager$list_secret_version_ids_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$list_secret_version_ids <- secretsmanager_list_secret_version_ids

#' Lists the secrets that are stored by Secrets Manager in the Amazon Web
#' Services account, not including secrets that are marked for deletion
#'
#' @description
#' Lists the secrets that are stored by Secrets Manager in the Amazon Web Services account, not including secrets that are marked for deletion. To see secrets marked for deletion, use the Secrets Manager console.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_list_secrets/](https://www.paws-r-sdk.com/docs/secretsmanager_list_secrets/) for full documentation.
#'
#' @param IncludePlannedDeletion Specifies whether to include secrets scheduled for deletion. By default,
#' secrets scheduled for deletion aren't included.
#' @param MaxResults The number of results to include in the response.
#' 
#' If there are more results available, in the response, Secrets Manager
#' includes `NextToken`. To get the next results, call
#' [`list_secrets`][secretsmanager_list_secrets] again with the value from
#' `NextToken`.
#' @param NextToken A token that indicates where the output should continue from, if a
#' previous call did not show all results. To get the next results, call
#' [`list_secrets`][secretsmanager_list_secrets] again with this value.
#' @param Filters The filters to apply to the list of secrets.
#' @param SortOrder Secrets are listed by `CreatedDate`.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_list_secrets
secretsmanager_list_secrets <- function(IncludePlannedDeletion = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListSecrets",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .secretsmanager$list_secrets_input(IncludePlannedDeletion = IncludePlannedDeletion, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, SortOrder = SortOrder)
  output <- .secretsmanager$list_secrets_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$list_secrets <- secretsmanager_list_secrets

#' Attaches a resource-based permission policy to a secret
#'
#' @description
#' Attaches a resource-based permission policy to a secret. A resource-based policy is optional. For more information, see [Authentication and access control for Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html)
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_put_resource_policy/](https://www.paws-r-sdk.com/docs/secretsmanager_put_resource_policy/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret to attach the resource-based policy.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#' @param ResourcePolicy &#91;required&#93; A JSON-formatted string for an Amazon Web Services resource-based
#' policy. For example policies, see [Permissions policy
#' examples](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html).
#' @param BlockPublicPolicy Specifies whether to block resource-based policies that allow broad
#' access to the secret, for example those that use a wildcard for the
#' principal. By default, public policies aren't blocked.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_put_resource_policy
secretsmanager_put_resource_policy <- function(SecretId, ResourcePolicy, BlockPublicPolicy = NULL) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$put_resource_policy_input(SecretId = SecretId, ResourcePolicy = ResourcePolicy, BlockPublicPolicy = BlockPublicPolicy)
  output <- .secretsmanager$put_resource_policy_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$put_resource_policy <- secretsmanager_put_resource_policy

#' Creates a new version with a new encrypted secret value and attaches it
#' to the secret
#'
#' @description
#' Creates a new version with a new encrypted secret value and attaches it to the secret. The version can contain a new `SecretString` value or a new `SecretBinary` value.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_put_secret_value/](https://www.paws-r-sdk.com/docs/secretsmanager_put_secret_value/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret to add a new version to.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#' 
#' If the secret doesn't already exist, use
#' [`create_secret`][secretsmanager_create_secret] instead.
#' @param ClientRequestToken A unique identifier for the new version of the secret.
#' 
#' If you use the Amazon Web Services CLI or one of the Amazon Web Services
#' SDKs to call this operation, then you can leave this parameter empty
#' because they generate a random UUID for you. If you don't use the SDK
#' and instead generate a raw HTTP request to the Secrets Manager service
#' endpoint, then you must generate a `ClientRequestToken` yourself for new
#' versions and include that value in the request.
#' 
#' This value helps ensure idempotency. Secrets Manager uses this value to
#' prevent the accidental creation of duplicate versions if there are
#' failures and retries during the Lambda rotation function processing. We
#' recommend that you generate a
#' [UUID-type](https://en.wikipedia.org/wiki/Universally_unique_identifier)
#' value to ensure uniqueness within the specified secret.
#' 
#' -   If the `ClientRequestToken` value isn't already associated with a
#'     version of the secret then a new version of the secret is created.
#' 
#' -   If a version with this value already exists and that version's
#'     `SecretString` or `SecretBinary` values are the same as those in the
#'     request then the request is ignored. The operation is idempotent.
#' 
#' -   If a version with this value already exists and the version of the
#'     `SecretString` and `SecretBinary` values are different from those in
#'     the request, then the request fails because you can't modify a
#'     secret version. You can only create new versions to store new secret
#'     values.
#' 
#' This value becomes the `VersionId` of the new version.
#' @param SecretBinary The binary data to encrypt and store in the new version of the secret.
#' To use this parameter in the command-line tools, we recommend that you
#' store your binary data in a file and then pass the contents of the file
#' as a parameter.
#' 
#' You must include `SecretBinary` or `SecretString`, but not both.
#' 
#' You can't access this value from the Secrets Manager console.
#' @param SecretString The text to encrypt and store in the new version of the secret.
#' 
#' You must include `SecretBinary` or `SecretString`, but not both.
#' 
#' We recommend you create the secret string as JSON key/value pairs, as
#' shown in the example.
#' @param VersionStages A list of staging labels to attach to this version of the secret.
#' Secrets Manager uses staging labels to track versions of a secret
#' through the rotation process.
#' 
#' If you specify a staging label that's already associated with a
#' different version of the same secret, then Secrets Manager removes the
#' label from the other version and attaches it to this version. If you
#' specify `AWSCURRENT`, and it is already attached to another version,
#' then Secrets Manager also moves the staging label `AWSPREVIOUS` to the
#' version that `AWSCURRENT` was removed from.
#' 
#' If you don't include `VersionStages`, then Secrets Manager automatically
#' moves the staging label `AWSCURRENT` to this version.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_put_secret_value
secretsmanager_put_secret_value <- function(SecretId, ClientRequestToken = NULL, SecretBinary = NULL, SecretString = NULL, VersionStages = NULL) {
  op <- new_operation(
    name = "PutSecretValue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$put_secret_value_input(SecretId = SecretId, ClientRequestToken = ClientRequestToken, SecretBinary = SecretBinary, SecretString = SecretString, VersionStages = VersionStages)
  output <- .secretsmanager$put_secret_value_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$put_secret_value <- secretsmanager_put_secret_value

#' For a secret that is replicated to other Regions, deletes the secret
#' replicas from the Regions you specify
#'
#' @description
#' For a secret that is replicated to other Regions, deletes the secret replicas from the Regions you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_remove_regions_from_replication/](https://www.paws-r-sdk.com/docs/secretsmanager_remove_regions_from_replication/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret.
#' @param RemoveReplicaRegions &#91;required&#93; The Regions of the replicas to remove.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_remove_regions_from_replication
secretsmanager_remove_regions_from_replication <- function(SecretId, RemoveReplicaRegions) {
  op <- new_operation(
    name = "RemoveRegionsFromReplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$remove_regions_from_replication_input(SecretId = SecretId, RemoveReplicaRegions = RemoveReplicaRegions)
  output <- .secretsmanager$remove_regions_from_replication_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$remove_regions_from_replication <- secretsmanager_remove_regions_from_replication

#' Replicates the secret to a new Regions
#'
#' @description
#' Replicates the secret to a new Regions. See [Multi-Region secrets](https://docs.aws.amazon.com/secretsmanager/latest/userguide/create-manage-multi-region-secrets.html).
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_replicate_secret_to_regions/](https://www.paws-r-sdk.com/docs/secretsmanager_replicate_secret_to_regions/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret to replicate.
#' @param AddReplicaRegions &#91;required&#93; A list of Regions in which to replicate the secret.
#' @param ForceOverwriteReplicaSecret Specifies whether to overwrite a secret with the same name in the
#' destination Region. By default, secrets aren't overwritten.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_replicate_secret_to_regions
secretsmanager_replicate_secret_to_regions <- function(SecretId, AddReplicaRegions, ForceOverwriteReplicaSecret = NULL) {
  op <- new_operation(
    name = "ReplicateSecretToRegions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$replicate_secret_to_regions_input(SecretId = SecretId, AddReplicaRegions = AddReplicaRegions, ForceOverwriteReplicaSecret = ForceOverwriteReplicaSecret)
  output <- .secretsmanager$replicate_secret_to_regions_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$replicate_secret_to_regions <- secretsmanager_replicate_secret_to_regions

#' Cancels the scheduled deletion of a secret by removing the DeletedDate
#' time stamp
#'
#' @description
#' Cancels the scheduled deletion of a secret by removing the `DeletedDate` time stamp. You can access a secret again after it has been restored.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_restore_secret/](https://www.paws-r-sdk.com/docs/secretsmanager_restore_secret/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret to restore.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#'
#' @keywords internal
#'
#' @rdname secretsmanager_restore_secret
secretsmanager_restore_secret <- function(SecretId) {
  op <- new_operation(
    name = "RestoreSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$restore_secret_input(SecretId = SecretId)
  output <- .secretsmanager$restore_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$restore_secret <- secretsmanager_restore_secret

#' Configures and starts the asynchronous process of rotating the secret
#'
#' @description
#' Configures and starts the asynchronous process of rotating the secret. For information about rotation, see [Rotate secrets](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html) in the *Secrets Manager User Guide*. If you include the configuration parameters, the operation sets the values for the secret and then immediately starts a rotation. If you don't include the configuration parameters, the operation starts a rotation with the values already stored in the secret.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_rotate_secret/](https://www.paws-r-sdk.com/docs/secretsmanager_rotate_secret/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret to rotate.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#' @param ClientRequestToken A unique identifier for the new version of the secret that helps ensure
#' idempotency. Secrets Manager uses this value to prevent the accidental
#' creation of duplicate versions if there are failures and retries during
#' rotation. This value becomes the `VersionId` of the new version.
#' 
#' If you use the Amazon Web Services CLI or one of the Amazon Web Services
#' SDK to call this operation, then you can leave this parameter empty. The
#' CLI or SDK generates a random UUID for you and includes that in the
#' request for this parameter. If you don't use the SDK and instead
#' generate a raw HTTP request to the Secrets Manager service endpoint,
#' then you must generate a `ClientRequestToken` yourself for new versions
#' and include that value in the request.
#' 
#' You only need to specify this value if you implement your own retry
#' logic and you want to ensure that Secrets Manager doesn't attempt to
#' create a secret version twice. We recommend that you generate a
#' [UUID-type](https://en.wikipedia.org/wiki/Universally_unique_identifier)
#' value to ensure uniqueness within the specified secret.
#' @param RotationLambdaARN For secrets that use a Lambda rotation function to rotate, the ARN of
#' the Lambda rotation function.
#' 
#' For secrets that use *managed rotation*, omit this field. For more
#' information, see [Managed
#' rotation](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_managed.html)
#' in the *Secrets Manager User Guide*.
#' @param RotationRules A structure that defines the rotation configuration for this secret.
#' @param RotateImmediately Specifies whether to rotate the secret immediately or wait until the
#' next scheduled rotation window. The rotation schedule is defined in
#' RotateSecretRequest$RotationRules.
#' 
#' For secrets that use a Lambda rotation function to rotate, if you don't
#' immediately rotate the secret, Secrets Manager tests the rotation
#' configuration by running the [`testSecret`
#' step](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html#rotate-secrets_how)
#' of the Lambda rotation function. The test creates an `AWSPENDING`
#' version of the secret and then removes it.
#' 
#' By default, Secrets Manager rotates the secret immediately.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_rotate_secret
secretsmanager_rotate_secret <- function(SecretId, ClientRequestToken = NULL, RotationLambdaARN = NULL, RotationRules = NULL, RotateImmediately = NULL) {
  op <- new_operation(
    name = "RotateSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$rotate_secret_input(SecretId = SecretId, ClientRequestToken = ClientRequestToken, RotationLambdaARN = RotationLambdaARN, RotationRules = RotationRules, RotateImmediately = RotateImmediately)
  output <- .secretsmanager$rotate_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$rotate_secret <- secretsmanager_rotate_secret

#' Removes the link between the replica secret and the primary secret and
#' promotes the replica to a primary secret in the replica Region
#'
#' @description
#' Removes the link between the replica secret and the primary secret and promotes the replica to a primary secret in the replica Region.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_stop_replication_to_replica/](https://www.paws-r-sdk.com/docs/secretsmanager_stop_replication_to_replica/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN of the primary secret.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_stop_replication_to_replica
secretsmanager_stop_replication_to_replica <- function(SecretId) {
  op <- new_operation(
    name = "StopReplicationToReplica",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$stop_replication_to_replica_input(SecretId = SecretId)
  output <- .secretsmanager$stop_replication_to_replica_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$stop_replication_to_replica <- secretsmanager_stop_replication_to_replica

#' Attaches tags to a secret
#'
#' @description
#' Attaches tags to a secret. Tags consist of a key name and a value. Tags are part of the secret's metadata. They are not associated with specific versions of the secret. This operation appends tags to the existing list of tags.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_tag_resource/](https://www.paws-r-sdk.com/docs/secretsmanager_tag_resource/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The identifier for the secret to attach tags to. You can specify either
#' the Amazon Resource Name (ARN) or the friendly name of the secret.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#' @param Tags &#91;required&#93; The tags to attach to the secret as a JSON text string argument. Each
#' element in the list consists of a `Key` and a `Value`.
#' 
#' For storing multiple values, we recommend that you use a JSON text
#' string argument and specify key/value pairs. For more information, see
#' [Specifying parameter values for the Amazon Web Services
#' CLI](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html)
#' in the Amazon Web Services CLI User Guide.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_tag_resource
secretsmanager_tag_resource <- function(SecretId, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$tag_resource_input(SecretId = SecretId, Tags = Tags)
  output <- .secretsmanager$tag_resource_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$tag_resource <- secretsmanager_tag_resource

#' Removes specific tags from a secret
#'
#' @description
#' Removes specific tags from a secret.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_untag_resource/](https://www.paws-r-sdk.com/docs/secretsmanager_untag_resource/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#' @param TagKeys &#91;required&#93; A list of tag key names to remove from the secret. You don't specify the
#' value. Both the key and its associated value are removed.
#' 
#' This parameter requires a JSON text string argument.
#' 
#' For storing multiple values, we recommend that you use a JSON text
#' string argument and specify key/value pairs. For more information, see
#' [Specifying parameter values for the Amazon Web Services
#' CLI](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html)
#' in the Amazon Web Services CLI User Guide.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_untag_resource
secretsmanager_untag_resource <- function(SecretId, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$untag_resource_input(SecretId = SecretId, TagKeys = TagKeys)
  output <- .secretsmanager$untag_resource_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$untag_resource <- secretsmanager_untag_resource

#' Modifies the details of a secret, including metadata and the secret
#' value
#'
#' @description
#' Modifies the details of a secret, including metadata and the secret value. To change the secret value, you can also use [`put_secret_value`][secretsmanager_put_secret_value].
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_update_secret/](https://www.paws-r-sdk.com/docs/secretsmanager_update_secret/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or name of the secret.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#' @param ClientRequestToken If you include `SecretString` or `SecretBinary`, then Secrets Manager
#' creates a new version for the secret, and this parameter specifies the
#' unique identifier for the new version.
#' 
#' If you use the Amazon Web Services CLI or one of the Amazon Web Services
#' SDKs to call this operation, then you can leave this parameter empty.
#' The CLI or SDK generates a random UUID for you and includes it as the
#' value for this parameter in the request. If you don't use the SDK and
#' instead generate a raw HTTP request to the Secrets Manager service
#' endpoint, then you must generate a `ClientRequestToken` yourself for the
#' new version and include the value in the request.
#' 
#' This value becomes the `VersionId` of the new version.
#' @param Description The description of the secret.
#' @param KmsKeyId The ARN, key ID, or alias of the KMS key that Secrets Manager uses to
#' encrypt new secret versions as well as any existing versions with the
#' staging labels `AWSCURRENT`, `AWSPENDING`, or `AWSPREVIOUS`. If you
#' don't have `kms:Encrypt` permission to the new key, Secrets Manager does
#' not re-ecrypt existing secret versions with the new key. For more
#' information about versions and staging labels, see [Concepts:
#' Version](https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version).
#' 
#' A key alias is always prefixed by `alias/`, for example
#' `alias/aws/secretsmanager`. For more information, see [About
#' aliases](https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html).
#' 
#' If you set this to an empty string, Secrets Manager uses the Amazon Web
#' Services managed key `aws/secretsmanager`. If this key doesn't already
#' exist in your account, then Secrets Manager creates it for you
#' automatically. All users and roles in the Amazon Web Services account
#' automatically have access to use `aws/secretsmanager`. Creating
#' `aws/secretsmanager` can result in a one-time significant delay in
#' returning the result.
#' 
#' You can only use the Amazon Web Services managed key
#' `aws/secretsmanager` if you call this operation using credentials from
#' the same Amazon Web Services account that owns the secret. If the secret
#' is in a different account, then you must use a customer managed key and
#' provide the ARN of that KMS key in this field. The user making the call
#' must have permissions to both the secret and the KMS key in their
#' respective accounts.
#' @param SecretBinary The binary data to encrypt and store in the new version of the secret.
#' We recommend that you store your binary data in a file and then pass the
#' contents of the file as a parameter.
#' 
#' Either `SecretBinary` or `SecretString` must have a value, but not both.
#' 
#' You can't access this parameter in the Secrets Manager console.
#' @param SecretString The text data to encrypt and store in the new version of the secret. We
#' recommend you use a JSON structure of key/value pairs for your secret
#' value.
#' 
#' Either `SecretBinary` or `SecretString` must have a value, but not both.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_update_secret
secretsmanager_update_secret <- function(SecretId, ClientRequestToken = NULL, Description = NULL, KmsKeyId = NULL, SecretBinary = NULL, SecretString = NULL) {
  op <- new_operation(
    name = "UpdateSecret",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$update_secret_input(SecretId = SecretId, ClientRequestToken = ClientRequestToken, Description = Description, KmsKeyId = KmsKeyId, SecretBinary = SecretBinary, SecretString = SecretString)
  output <- .secretsmanager$update_secret_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$update_secret <- secretsmanager_update_secret

#' Modifies the staging labels attached to a version of a secret
#'
#' @description
#' Modifies the staging labels attached to a version of a secret. Secrets Manager uses staging labels to track a version as it progresses through the secret rotation process. Each staging label can be attached to only one version at a time. To add a staging label to a version when it is already attached to another version, Secrets Manager first removes it from the other version first and then attaches it to this one. For more information about versions and staging labels, see [Concepts: Version](https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version).
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_update_secret_version_stage/](https://www.paws-r-sdk.com/docs/secretsmanager_update_secret_version_stage/) for full documentation.
#'
#' @param SecretId &#91;required&#93; The ARN or the name of the secret with the version and staging labelsto
#' modify.
#' 
#' For an ARN, we recommend that you specify a complete ARN rather than a
#' partial ARN. See [Finding a secret from a partial
#' ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
#' @param VersionStage &#91;required&#93; The staging label to add to this version.
#' @param RemoveFromVersionId The ID of the version that the staging label is to be removed from. If
#' the staging label you are trying to attach to one version is already
#' attached to a different version, then you must include this parameter
#' and specify the version that the label is to be removed from. If the
#' label is attached and you either do not specify this parameter, or the
#' version ID does not match, then the operation fails.
#' @param MoveToVersionId The ID of the version to add the staging label to. To remove a label
#' from a version, then do not specify this parameter.
#' 
#' If the staging label is already attached to a different version of the
#' secret, then you must also specify the `RemoveFromVersionId` parameter.
#'
#' @keywords internal
#'
#' @rdname secretsmanager_update_secret_version_stage
secretsmanager_update_secret_version_stage <- function(SecretId, VersionStage, RemoveFromVersionId = NULL, MoveToVersionId = NULL) {
  op <- new_operation(
    name = "UpdateSecretVersionStage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$update_secret_version_stage_input(SecretId = SecretId, VersionStage = VersionStage, RemoveFromVersionId = RemoveFromVersionId, MoveToVersionId = MoveToVersionId)
  output <- .secretsmanager$update_secret_version_stage_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$update_secret_version_stage <- secretsmanager_update_secret_version_stage

#' Validates that a resource policy does not grant a wide range of
#' principals access to your secret
#'
#' @description
#' Validates that a resource policy does not grant a wide range of principals access to your secret. A resource-based policy is optional for secrets.
#'
#' See [https://www.paws-r-sdk.com/docs/secretsmanager_validate_resource_policy/](https://www.paws-r-sdk.com/docs/secretsmanager_validate_resource_policy/) for full documentation.
#'
#' @param SecretId This field is reserved for internal use.
#' @param ResourcePolicy &#91;required&#93; A JSON-formatted string that contains an Amazon Web Services
#' resource-based policy. The policy in the string identifies who can
#' access or manage this secret and its versions. For example policies, see
#' [Permissions policy
#' examples](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html).
#'
#' @keywords internal
#'
#' @rdname secretsmanager_validate_resource_policy
secretsmanager_validate_resource_policy <- function(SecretId = NULL, ResourcePolicy) {
  op <- new_operation(
    name = "ValidateResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .secretsmanager$validate_resource_policy_input(SecretId = SecretId, ResourcePolicy = ResourcePolicy)
  output <- .secretsmanager$validate_resource_policy_output()
  config <- get_config()
  svc <- .secretsmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.secretsmanager$operations$validate_resource_policy <- secretsmanager_validate_resource_policy
