# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include inspector2_service.R
NULL

#' Associates an Amazon Web Services account with an Amazon Inspector
#' delegated administrator
#'
#' @description
#' Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check if the association completed by using [`list_members`][inspector2_list_members] for multiple accounts or [GetMembers](https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html) for a single account.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_associate_member/](https://www.paws-r-sdk.com/docs/inspector2_associate_member/) for full documentation.
#'
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the member account to be
#' associated.
#'
#' @keywords internal
#'
#' @rdname inspector2_associate_member
inspector2_associate_member <- function(accountId) {
  op <- new_operation(
    name = "AssociateMember",
    http_method = "POST",
    http_path = "/members/associate",
    paginator = list()
  )
  input <- .inspector2$associate_member_input(accountId = accountId)
  output <- .inspector2$associate_member_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$associate_member <- inspector2_associate_member

#' Retrieves the Amazon Inspector status of multiple Amazon Web Services
#' accounts within your environment
#'
#' @description
#' Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_batch_get_account_status/](https://www.paws-r-sdk.com/docs/inspector2_batch_get_account_status/) for full documentation.
#'
#' @param accountIds The 12-digit Amazon Web Services account IDs of the accounts to retrieve
#' Amazon Inspector status for.
#'
#' @keywords internal
#'
#' @rdname inspector2_batch_get_account_status
inspector2_batch_get_account_status <- function(accountIds = NULL) {
  op <- new_operation(
    name = "BatchGetAccountStatus",
    http_method = "POST",
    http_path = "/status/batch/get",
    paginator = list()
  )
  input <- .inspector2$batch_get_account_status_input(accountIds = accountIds)
  output <- .inspector2$batch_get_account_status_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$batch_get_account_status <- inspector2_batch_get_account_status

#' Retrieves code snippets from findings that Amazon Inspector detected
#' code vulnerabilities in
#'
#' @description
#' Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_batch_get_code_snippet/](https://www.paws-r-sdk.com/docs/inspector2_batch_get_code_snippet/) for full documentation.
#'
#' @param findingArns &#91;required&#93; An array of finding ARNs for the findings you want to retrieve code
#' snippets from.
#'
#' @keywords internal
#'
#' @rdname inspector2_batch_get_code_snippet
inspector2_batch_get_code_snippet <- function(findingArns) {
  op <- new_operation(
    name = "BatchGetCodeSnippet",
    http_method = "POST",
    http_path = "/codesnippet/batchget",
    paginator = list()
  )
  input <- .inspector2$batch_get_code_snippet_input(findingArns = findingArns)
  output <- .inspector2$batch_get_code_snippet_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$batch_get_code_snippet <- inspector2_batch_get_code_snippet

#' Gets vulnerability details for findings
#'
#' @description
#' Gets vulnerability details for findings.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_batch_get_finding_details/](https://www.paws-r-sdk.com/docs/inspector2_batch_get_finding_details/) for full documentation.
#'
#' @param findingArns &#91;required&#93; A list of finding ARNs.
#'
#' @keywords internal
#'
#' @rdname inspector2_batch_get_finding_details
inspector2_batch_get_finding_details <- function(findingArns) {
  op <- new_operation(
    name = "BatchGetFindingDetails",
    http_method = "POST",
    http_path = "/findings/details/batch/get",
    paginator = list()
  )
  input <- .inspector2$batch_get_finding_details_input(findingArns = findingArns)
  output <- .inspector2$batch_get_finding_details_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$batch_get_finding_details <- inspector2_batch_get_finding_details

#' Gets free trial status for multiple Amazon Web Services accounts
#'
#' @description
#' Gets free trial status for multiple Amazon Web Services accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_batch_get_free_trial_info/](https://www.paws-r-sdk.com/docs/inspector2_batch_get_free_trial_info/) for full documentation.
#'
#' @param accountIds &#91;required&#93; The account IDs to get free trial status for.
#'
#' @keywords internal
#'
#' @rdname inspector2_batch_get_free_trial_info
inspector2_batch_get_free_trial_info <- function(accountIds) {
  op <- new_operation(
    name = "BatchGetFreeTrialInfo",
    http_method = "POST",
    http_path = "/freetrialinfo/batchget",
    paginator = list()
  )
  input <- .inspector2$batch_get_free_trial_info_input(accountIds = accountIds)
  output <- .inspector2$batch_get_free_trial_info_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$batch_get_free_trial_info <- inspector2_batch_get_free_trial_info

#' Retrieves Amazon Inspector deep inspection activation status of multiple
#' member accounts within your organization
#'
#' @description
#' Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_batch_get_member_ec_2_deep_inspection_status/](https://www.paws-r-sdk.com/docs/inspector2_batch_get_member_ec_2_deep_inspection_status/) for full documentation.
#'
#' @param accountIds The unique identifiers for the Amazon Web Services accounts to retrieve
#' Amazon Inspector deep inspection activation status for.
#' 
#'      </p> 
#'
#' @keywords internal
#'
#' @rdname inspector2_batch_get_member_ec_2_deep_inspection_status
inspector2_batch_get_member_ec_2_deep_inspection_status <- function(accountIds = NULL) {
  op <- new_operation(
    name = "BatchGetMemberEc2DeepInspectionStatus",
    http_method = "POST",
    http_path = "/ec2deepinspectionstatus/member/batch/get",
    paginator = list()
  )
  input <- .inspector2$batch_get_member_ec_2_deep_inspection_status_input(accountIds = accountIds)
  output <- .inspector2$batch_get_member_ec_2_deep_inspection_status_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$batch_get_member_ec_2_deep_inspection_status <- inspector2_batch_get_member_ec_2_deep_inspection_status

#' Activates or deactivates Amazon Inspector deep inspection for the
#' provided member accounts in your organization
#'
#' @description
#' Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_batch_update_member_ec_2_deep_inspection_status/](https://www.paws-r-sdk.com/docs/inspector2_batch_update_member_ec_2_deep_inspection_status/) for full documentation.
#'
#' @param accountIds &#91;required&#93; The unique identifiers for the Amazon Web Services accounts to change
#' Amazon Inspector deep inspection status for.
#'
#' @keywords internal
#'
#' @rdname inspector2_batch_update_member_ec_2_deep_inspection_status
inspector2_batch_update_member_ec_2_deep_inspection_status <- function(accountIds) {
  op <- new_operation(
    name = "BatchUpdateMemberEc2DeepInspectionStatus",
    http_method = "POST",
    http_path = "/ec2deepinspectionstatus/member/batch/update",
    paginator = list()
  )
  input <- .inspector2$batch_update_member_ec_2_deep_inspection_status_input(accountIds = accountIds)
  output <- .inspector2$batch_update_member_ec_2_deep_inspection_status_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$batch_update_member_ec_2_deep_inspection_status <- inspector2_batch_update_member_ec_2_deep_inspection_status

#' Cancels the given findings report
#'
#' @description
#' Cancels the given findings report.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_cancel_findings_report/](https://www.paws-r-sdk.com/docs/inspector2_cancel_findings_report/) for full documentation.
#'
#' @param reportId &#91;required&#93; The ID of the report to be canceled.
#'
#' @keywords internal
#'
#' @rdname inspector2_cancel_findings_report
inspector2_cancel_findings_report <- function(reportId) {
  op <- new_operation(
    name = "CancelFindingsReport",
    http_method = "POST",
    http_path = "/reporting/cancel",
    paginator = list()
  )
  input <- .inspector2$cancel_findings_report_input(reportId = reportId)
  output <- .inspector2$cancel_findings_report_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$cancel_findings_report <- inspector2_cancel_findings_report

#' Cancels a software bill of materials (SBOM) report
#'
#' @description
#' Cancels a software bill of materials (SBOM) report.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_cancel_sbom_export/](https://www.paws-r-sdk.com/docs/inspector2_cancel_sbom_export/) for full documentation.
#'
#' @param reportId &#91;required&#93; The report ID of the SBOM export to cancel.
#'
#' @keywords internal
#'
#' @rdname inspector2_cancel_sbom_export
inspector2_cancel_sbom_export <- function(reportId) {
  op <- new_operation(
    name = "CancelSbomExport",
    http_method = "POST",
    http_path = "/sbomexport/cancel",
    paginator = list()
  )
  input <- .inspector2$cancel_sbom_export_input(reportId = reportId)
  output <- .inspector2$cancel_sbom_export_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$cancel_sbom_export <- inspector2_cancel_sbom_export

#' Creates a filter resource using specified filter criteria
#'
#' @description
#' Creates a filter resource using specified filter criteria. When the filter action is set to `SUPPRESS` this action creates a suppression rule.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_create_filter/](https://www.paws-r-sdk.com/docs/inspector2_create_filter/) for full documentation.
#'
#' @param action &#91;required&#93; Defines the action that is to be applied to the findings that match the
#' filter.
#' @param description A description of the filter.
#' @param filterCriteria &#91;required&#93; Defines the criteria to be used in the filter for querying findings.
#' @param name &#91;required&#93; The name of the filter. Minimum length of 3. Maximum length of 64. Valid
#' characters include alphanumeric characters, dot (.), underscore (_),
#' and dash (-). Spaces are not allowed.
#' @param reason The reason for creating the filter.
#' @param tags A list of tags for the filter.
#'
#' @keywords internal
#'
#' @rdname inspector2_create_filter
inspector2_create_filter <- function(action, description = NULL, filterCriteria, name, reason = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateFilter",
    http_method = "POST",
    http_path = "/filters/create",
    paginator = list()
  )
  input <- .inspector2$create_filter_input(action = action, description = description, filterCriteria = filterCriteria, name = name, reason = reason, tags = tags)
  output <- .inspector2$create_filter_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$create_filter <- inspector2_create_filter

#' Creates a finding report
#'
#' @description
#' Creates a finding report. By default only `ACTIVE` findings are returned in the report. To see `SUPRESSED` or `CLOSED` findings you must specify a value for the `findingStatus` filter criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_create_findings_report/](https://www.paws-r-sdk.com/docs/inspector2_create_findings_report/) for full documentation.
#'
#' @param filterCriteria The filter criteria to apply to the results of the finding report.
#' @param reportFormat &#91;required&#93; The format to generate the report in.
#' @param s3Destination &#91;required&#93; The Amazon S3 export destination for the report.
#'
#' @keywords internal
#'
#' @rdname inspector2_create_findings_report
inspector2_create_findings_report <- function(filterCriteria = NULL, reportFormat, s3Destination) {
  op <- new_operation(
    name = "CreateFindingsReport",
    http_method = "POST",
    http_path = "/reporting/create",
    paginator = list()
  )
  input <- .inspector2$create_findings_report_input(filterCriteria = filterCriteria, reportFormat = reportFormat, s3Destination = s3Destination)
  output <- .inspector2$create_findings_report_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$create_findings_report <- inspector2_create_findings_report

#' Creates a software bill of materials (SBOM) report
#'
#' @description
#' Creates a software bill of materials (SBOM) report.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_create_sbom_export/](https://www.paws-r-sdk.com/docs/inspector2_create_sbom_export/) for full documentation.
#'
#' @param reportFormat &#91;required&#93; The output format for the software bill of materials (SBOM) report.
#' @param resourceFilterCriteria The resource filter criteria for the software bill of materials (SBOM)
#' report.
#' @param s3Destination &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname inspector2_create_sbom_export
inspector2_create_sbom_export <- function(reportFormat, resourceFilterCriteria = NULL, s3Destination) {
  op <- new_operation(
    name = "CreateSbomExport",
    http_method = "POST",
    http_path = "/sbomexport/create",
    paginator = list()
  )
  input <- .inspector2$create_sbom_export_input(reportFormat = reportFormat, resourceFilterCriteria = resourceFilterCriteria, s3Destination = s3Destination)
  output <- .inspector2$create_sbom_export_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$create_sbom_export <- inspector2_create_sbom_export

#' Deletes a filter resource
#'
#' @description
#' Deletes a filter resource.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_delete_filter/](https://www.paws-r-sdk.com/docs/inspector2_delete_filter/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Number (ARN) of the filter to be deleted.
#'
#' @keywords internal
#'
#' @rdname inspector2_delete_filter
inspector2_delete_filter <- function(arn) {
  op <- new_operation(
    name = "DeleteFilter",
    http_method = "POST",
    http_path = "/filters/delete",
    paginator = list()
  )
  input <- .inspector2$delete_filter_input(arn = arn)
  output <- .inspector2$delete_filter_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$delete_filter <- inspector2_delete_filter

#' Describe Amazon Inspector configuration settings for an Amazon Web
#' Services organization
#'
#' @description
#' Describe Amazon Inspector configuration settings for an Amazon Web Services organization.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_describe_organization_configuration/](https://www.paws-r-sdk.com/docs/inspector2_describe_organization_configuration/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname inspector2_describe_organization_configuration
inspector2_describe_organization_configuration <- function() {
  op <- new_operation(
    name = "DescribeOrganizationConfiguration",
    http_method = "POST",
    http_path = "/organizationconfiguration/describe",
    paginator = list()
  )
  input <- .inspector2$describe_organization_configuration_input()
  output <- .inspector2$describe_organization_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$describe_organization_configuration <- inspector2_describe_organization_configuration

#' Disables Amazon Inspector scans for one or more Amazon Web Services
#' accounts
#'
#' @description
#' Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_disable/](https://www.paws-r-sdk.com/docs/inspector2_disable/) for full documentation.
#'
#' @param accountIds An array of account IDs you want to disable Amazon Inspector scans for.
#' @param resourceTypes The resource scan types you want to disable.
#'
#' @keywords internal
#'
#' @rdname inspector2_disable
inspector2_disable <- function(accountIds = NULL, resourceTypes = NULL) {
  op <- new_operation(
    name = "Disable",
    http_method = "POST",
    http_path = "/disable",
    paginator = list()
  )
  input <- .inspector2$disable_input(accountIds = accountIds, resourceTypes = resourceTypes)
  output <- .inspector2$disable_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$disable <- inspector2_disable

#' Disables the Amazon Inspector delegated administrator for your
#' organization
#'
#' @description
#' Disables the Amazon Inspector delegated administrator for your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_disable_delegated_admin_account/](https://www.paws-r-sdk.com/docs/inspector2_disable_delegated_admin_account/) for full documentation.
#'
#' @param delegatedAdminAccountId &#91;required&#93; The Amazon Web Services account ID of the current Amazon Inspector
#' delegated administrator.
#'
#' @keywords internal
#'
#' @rdname inspector2_disable_delegated_admin_account
inspector2_disable_delegated_admin_account <- function(delegatedAdminAccountId) {
  op <- new_operation(
    name = "DisableDelegatedAdminAccount",
    http_method = "POST",
    http_path = "/delegatedadminaccounts/disable",
    paginator = list()
  )
  input <- .inspector2$disable_delegated_admin_account_input(delegatedAdminAccountId = delegatedAdminAccountId)
  output <- .inspector2$disable_delegated_admin_account_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$disable_delegated_admin_account <- inspector2_disable_delegated_admin_account

#' Disassociates a member account from an Amazon Inspector delegated
#' administrator
#'
#' @description
#' Disassociates a member account from an Amazon Inspector delegated administrator.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_disassociate_member/](https://www.paws-r-sdk.com/docs/inspector2_disassociate_member/) for full documentation.
#'
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the member account to
#' disassociate.
#'
#' @keywords internal
#'
#' @rdname inspector2_disassociate_member
inspector2_disassociate_member <- function(accountId) {
  op <- new_operation(
    name = "DisassociateMember",
    http_method = "POST",
    http_path = "/members/disassociate",
    paginator = list()
  )
  input <- .inspector2$disassociate_member_input(accountId = accountId)
  output <- .inspector2$disassociate_member_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$disassociate_member <- inspector2_disassociate_member

#' Enables Amazon Inspector scans for one or more Amazon Web Services
#' accounts
#'
#' @description
#' Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_enable/](https://www.paws-r-sdk.com/docs/inspector2_enable/) for full documentation.
#'
#' @param accountIds A list of account IDs you want to enable Amazon Inspector scans for.
#' @param clientToken The idempotency token for the request.
#' @param resourceTypes &#91;required&#93; The resource scan types you want to enable.
#'
#' @keywords internal
#'
#' @rdname inspector2_enable
inspector2_enable <- function(accountIds = NULL, clientToken = NULL, resourceTypes) {
  op <- new_operation(
    name = "Enable",
    http_method = "POST",
    http_path = "/enable",
    paginator = list()
  )
  input <- .inspector2$enable_input(accountIds = accountIds, clientToken = clientToken, resourceTypes = resourceTypes)
  output <- .inspector2$enable_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$enable <- inspector2_enable

#' Enables the Amazon Inspector delegated administrator for your
#' Organizations organization
#'
#' @description
#' Enables the Amazon Inspector delegated administrator for your Organizations organization.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_enable_delegated_admin_account/](https://www.paws-r-sdk.com/docs/inspector2_enable_delegated_admin_account/) for full documentation.
#'
#' @param clientToken The idempotency token for the request.
#' @param delegatedAdminAccountId &#91;required&#93; The Amazon Web Services account ID of the Amazon Inspector delegated
#' administrator.
#'
#' @keywords internal
#'
#' @rdname inspector2_enable_delegated_admin_account
inspector2_enable_delegated_admin_account <- function(clientToken = NULL, delegatedAdminAccountId) {
  op <- new_operation(
    name = "EnableDelegatedAdminAccount",
    http_method = "POST",
    http_path = "/delegatedadminaccounts/enable",
    paginator = list()
  )
  input <- .inspector2$enable_delegated_admin_account_input(clientToken = clientToken, delegatedAdminAccountId = delegatedAdminAccountId)
  output <- .inspector2$enable_delegated_admin_account_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$enable_delegated_admin_account <- inspector2_enable_delegated_admin_account

#' Retrieves setting configurations for Inspector scans
#'
#' @description
#' Retrieves setting configurations for Inspector scans.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_get_configuration/](https://www.paws-r-sdk.com/docs/inspector2_get_configuration/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_configuration
inspector2_get_configuration <- function() {
  op <- new_operation(
    name = "GetConfiguration",
    http_method = "POST",
    http_path = "/configuration/get",
    paginator = list()
  )
  input <- .inspector2$get_configuration_input()
  output <- .inspector2$get_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_configuration <- inspector2_get_configuration

#' Retrieves information about the Amazon Inspector delegated administrator
#' for your organization
#'
#' @description
#' Retrieves information about the Amazon Inspector delegated administrator for your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_get_delegated_admin_account/](https://www.paws-r-sdk.com/docs/inspector2_get_delegated_admin_account/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_delegated_admin_account
inspector2_get_delegated_admin_account <- function() {
  op <- new_operation(
    name = "GetDelegatedAdminAccount",
    http_method = "POST",
    http_path = "/delegatedadminaccounts/get",
    paginator = list()
  )
  input <- .inspector2$get_delegated_admin_account_input()
  output <- .inspector2$get_delegated_admin_account_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_delegated_admin_account <- inspector2_get_delegated_admin_account

#' Retrieves the activation status of Amazon Inspector deep inspection and
#' custom paths associated with your account
#'
#' @description
#' Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_get_ec_2_deep_inspection_configuration/](https://www.paws-r-sdk.com/docs/inspector2_get_ec_2_deep_inspection_configuration/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_ec_2_deep_inspection_configuration
inspector2_get_ec_2_deep_inspection_configuration <- function() {
  op <- new_operation(
    name = "GetEc2DeepInspectionConfiguration",
    http_method = "POST",
    http_path = "/ec2deepinspectionconfiguration/get",
    paginator = list()
  )
  input <- .inspector2$get_ec_2_deep_inspection_configuration_input()
  output <- .inspector2$get_ec_2_deep_inspection_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_ec_2_deep_inspection_configuration <- inspector2_get_ec_2_deep_inspection_configuration

#' Gets an encryption key
#'
#' @description
#' Gets an encryption key.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_get_encryption_key/](https://www.paws-r-sdk.com/docs/inspector2_get_encryption_key/) for full documentation.
#'
#' @param resourceType &#91;required&#93; The resource type the key encrypts.
#' @param scanType &#91;required&#93; The scan type the key encrypts.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_encryption_key
inspector2_get_encryption_key <- function(resourceType, scanType) {
  op <- new_operation(
    name = "GetEncryptionKey",
    http_method = "GET",
    http_path = "/encryptionkey/get",
    paginator = list()
  )
  input <- .inspector2$get_encryption_key_input(resourceType = resourceType, scanType = scanType)
  output <- .inspector2$get_encryption_key_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_encryption_key <- inspector2_get_encryption_key

#' Gets the status of a findings report
#'
#' @description
#' Gets the status of a findings report.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_get_findings_report_status/](https://www.paws-r-sdk.com/docs/inspector2_get_findings_report_status/) for full documentation.
#'
#' @param reportId The ID of the report to retrieve the status of.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_findings_report_status
inspector2_get_findings_report_status <- function(reportId = NULL) {
  op <- new_operation(
    name = "GetFindingsReportStatus",
    http_method = "POST",
    http_path = "/reporting/status/get",
    paginator = list()
  )
  input <- .inspector2$get_findings_report_status_input(reportId = reportId)
  output <- .inspector2$get_findings_report_status_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_findings_report_status <- inspector2_get_findings_report_status

#' Gets member information for your organization
#'
#' @description
#' Gets member information for your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_get_member/](https://www.paws-r-sdk.com/docs/inspector2_get_member/) for full documentation.
#'
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the member account to retrieve
#' information on.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_member
inspector2_get_member <- function(accountId) {
  op <- new_operation(
    name = "GetMember",
    http_method = "POST",
    http_path = "/members/get",
    paginator = list()
  )
  input <- .inspector2$get_member_input(accountId = accountId)
  output <- .inspector2$get_member_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_member <- inspector2_get_member

#' Gets details of a software bill of materials (SBOM) report
#'
#' @description
#' Gets details of a software bill of materials (SBOM) report.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_get_sbom_export/](https://www.paws-r-sdk.com/docs/inspector2_get_sbom_export/) for full documentation.
#'
#' @param reportId &#91;required&#93; The report ID of the SBOM export to get details for.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_sbom_export
inspector2_get_sbom_export <- function(reportId) {
  op <- new_operation(
    name = "GetSbomExport",
    http_method = "POST",
    http_path = "/sbomexport/get",
    paginator = list()
  )
  input <- .inspector2$get_sbom_export_input(reportId = reportId)
  output <- .inspector2$get_sbom_export_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_sbom_export <- inspector2_get_sbom_export

#' Lists the permissions an account has to configure Amazon Inspector
#'
#' @description
#' Lists the permissions an account has to configure Amazon Inspector.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_list_account_permissions/](https://www.paws-r-sdk.com/docs/inspector2_list_account_permissions/) for full documentation.
#'
#' @param maxResults The maximum number of results the response can return. If your request
#' would return more than the maximum the response will return a
#' `nextToken` value, use this value when you call the action again to get
#' the remaining results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. If your response returns more than the `maxResults` maximum
#' value it will also return a `nextToken` value. For subsequent calls, use
#' the NextToken value returned from the previous request to continue
#' listing results after the first page.
#' @param service The service scan type to check permissions for.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_account_permissions
inspector2_list_account_permissions <- function(maxResults = NULL, nextToken = NULL, service = NULL) {
  op <- new_operation(
    name = "ListAccountPermissions",
    http_method = "POST",
    http_path = "/accountpermissions/list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "permissions")
  )
  input <- .inspector2$list_account_permissions_input(maxResults = maxResults, nextToken = nextToken, service = service)
  output <- .inspector2$list_account_permissions_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_account_permissions <- inspector2_list_account_permissions

#' Lists coverage details for you environment
#'
#' @description
#' Lists coverage details for you environment.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_list_coverage/](https://www.paws-r-sdk.com/docs/inspector2_list_coverage/) for full documentation.
#'
#' @param filterCriteria An object that contains details on the filters to apply to the coverage
#' data for your environment.
#' @param maxResults The maximum number of results the response can return. If your request
#' would return more than the maximum the response will return a
#' `nextToken` value, use this value when you call the action again to get
#' the remaining results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. If your response returns more than the `maxResults` maximum
#' value it will also return a `nextToken` value. For subsequent calls, use
#' the `nextToken` value returned from the previous request to continue
#' listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_coverage
inspector2_list_coverage <- function(filterCriteria = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListCoverage",
    http_method = "POST",
    http_path = "/coverage/list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "coveredResources")
  )
  input <- .inspector2$list_coverage_input(filterCriteria = filterCriteria, maxResults = maxResults, nextToken = nextToken)
  output <- .inspector2$list_coverage_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_coverage <- inspector2_list_coverage

#' Lists Amazon Inspector coverage statistics for your environment
#'
#' @description
#' Lists Amazon Inspector coverage statistics for your environment.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_list_coverage_statistics/](https://www.paws-r-sdk.com/docs/inspector2_list_coverage_statistics/) for full documentation.
#'
#' @param filterCriteria An object that contains details on the filters to apply to the coverage
#' data for your environment.
#' @param groupBy The value to group the results by.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_coverage_statistics
inspector2_list_coverage_statistics <- function(filterCriteria = NULL, groupBy = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListCoverageStatistics",
    http_method = "POST",
    http_path = "/coverage/statistics/list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "countsByGroup")
  )
  input <- .inspector2$list_coverage_statistics_input(filterCriteria = filterCriteria, groupBy = groupBy, nextToken = nextToken)
  output <- .inspector2$list_coverage_statistics_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_coverage_statistics <- inspector2_list_coverage_statistics

#' Lists information about the Amazon Inspector delegated administrator of
#' your organization
#'
#' @description
#' Lists information about the Amazon Inspector delegated administrator of your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_list_delegated_admin_accounts/](https://www.paws-r-sdk.com/docs/inspector2_list_delegated_admin_accounts/) for full documentation.
#'
#' @param maxResults The maximum number of results the response can return. If your request
#' would return more than the maximum the response will return a
#' `nextToken` value, use this value when you call the action again to get
#' the remaining results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. If your response returns more than the `maxResults` maximum
#' value it will also return a `nextToken` value. For subsequent calls, use
#' the `nextToken` value returned from the previous request to continue
#' listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_delegated_admin_accounts
inspector2_list_delegated_admin_accounts <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDelegatedAdminAccounts",
    http_method = "POST",
    http_path = "/delegatedadminaccounts/list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "delegatedAdminAccounts")
  )
  input <- .inspector2$list_delegated_admin_accounts_input(maxResults = maxResults, nextToken = nextToken)
  output <- .inspector2$list_delegated_admin_accounts_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_delegated_admin_accounts <- inspector2_list_delegated_admin_accounts

#' Lists the filters associated with your account
#'
#' @description
#' Lists the filters associated with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_list_filters/](https://www.paws-r-sdk.com/docs/inspector2_list_filters/) for full documentation.
#'
#' @param action The action the filter applies to matched findings.
#' @param arns The Amazon resource number (ARN) of the filter.
#' @param maxResults The maximum number of results the response can return. If your request
#' would return more than the maximum the response will return a
#' `nextToken` value, use this value when you call the action again to get
#' the remaining results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. If your response returns more than the `maxResults` maximum
#' value it will also return a `nextToken` value. For subsequent calls, use
#' the `nextToken` value returned from the previous request to continue
#' listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_filters
inspector2_list_filters <- function(action = NULL, arns = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFilters",
    http_method = "POST",
    http_path = "/filters/list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "filters")
  )
  input <- .inspector2$list_filters_input(action = action, arns = arns, maxResults = maxResults, nextToken = nextToken)
  output <- .inspector2$list_filters_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_filters <- inspector2_list_filters

#' Lists aggregated finding data for your environment based on specific
#' criteria
#'
#' @description
#' Lists aggregated finding data for your environment based on specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_list_finding_aggregations/](https://www.paws-r-sdk.com/docs/inspector2_list_finding_aggregations/) for full documentation.
#'
#' @param accountIds The Amazon Web Services account IDs to retrieve finding aggregation data
#' for.
#' @param aggregationRequest Details of the aggregation request that is used to filter your
#' aggregation results.
#' @param aggregationType &#91;required&#93; The type of the aggregation request.
#' @param maxResults The maximum number of results the response can return. If your request
#' would return more than the maximum the response will return a
#' `nextToken` value, use this value when you call the action again to get
#' the remaining results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. If your response returns more than the `maxResults` maximum
#' value it will also return a `nextToken` value. For subsequent calls, use
#' the `nextToken` value returned from the previous request to continue
#' listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_finding_aggregations
inspector2_list_finding_aggregations <- function(accountIds = NULL, aggregationRequest = NULL, aggregationType, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFindingAggregations",
    http_method = "POST",
    http_path = "/findings/aggregation/list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "responses")
  )
  input <- .inspector2$list_finding_aggregations_input(accountIds = accountIds, aggregationRequest = aggregationRequest, aggregationType = aggregationType, maxResults = maxResults, nextToken = nextToken)
  output <- .inspector2$list_finding_aggregations_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_finding_aggregations <- inspector2_list_finding_aggregations

#' Lists findings for your environment
#'
#' @description
#' Lists findings for your environment.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_list_findings/](https://www.paws-r-sdk.com/docs/inspector2_list_findings/) for full documentation.
#'
#' @param filterCriteria Details on the filters to apply to your finding results.
#' @param maxResults The maximum number of results the response can return. If your request
#' would return more than the maximum the response will return a
#' `nextToken` value, use this value when you call the action again to get
#' the remaining results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. If your response returns more than the `maxResults` maximum
#' value it will also return a `nextToken` value. For subsequent calls, use
#' the `nextToken` value returned from the previous request to continue
#' listing results after the first page.
#' @param sortCriteria Details on the sort criteria to apply to your finding results.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_findings
inspector2_list_findings <- function(filterCriteria = NULL, maxResults = NULL, nextToken = NULL, sortCriteria = NULL) {
  op <- new_operation(
    name = "ListFindings",
    http_method = "POST",
    http_path = "/findings/list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "findings")
  )
  input <- .inspector2$list_findings_input(filterCriteria = filterCriteria, maxResults = maxResults, nextToken = nextToken, sortCriteria = sortCriteria)
  output <- .inspector2$list_findings_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_findings <- inspector2_list_findings

#' List members associated with the Amazon Inspector delegated
#' administrator for your organization
#'
#' @description
#' List members associated with the Amazon Inspector delegated administrator for your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_list_members/](https://www.paws-r-sdk.com/docs/inspector2_list_members/) for full documentation.
#'
#' @param maxResults The maximum number of results the response can return. If your request
#' would return more than the maximum the response will return a
#' `nextToken` value, use this value when you call the action again to get
#' the remaining results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. If your response returns more than the `maxResults` maximum
#' value it will also return a `nextToken` value. For subsequent calls, use
#' the `nextToken` value returned from the previous request to continue
#' listing results after the first page.
#' @param onlyAssociated Specifies whether to list only currently associated members if `True` or
#' to list all members within the organization if `False`.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_members
inspector2_list_members <- function(maxResults = NULL, nextToken = NULL, onlyAssociated = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "POST",
    http_path = "/members/list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "members")
  )
  input <- .inspector2$list_members_input(maxResults = maxResults, nextToken = nextToken, onlyAssociated = onlyAssociated)
  output <- .inspector2$list_members_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_members <- inspector2_list_members

#' Lists all tags attached to a given resource
#'
#' @description
#' Lists all tags attached to a given resource.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/inspector2_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon resource number (ARN) of the resource to list tags of.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_tags_for_resource
inspector2_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .inspector2$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .inspector2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_tags_for_resource <- inspector2_list_tags_for_resource

#' Lists the Amazon Inspector usage totals over the last 30 days
#'
#' @description
#' Lists the Amazon Inspector usage totals over the last 30 days.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_list_usage_totals/](https://www.paws-r-sdk.com/docs/inspector2_list_usage_totals/) for full documentation.
#'
#' @param accountIds The Amazon Web Services account IDs to retrieve usage totals for.
#' @param maxResults The maximum number of results the response can return. If your request
#' would return more than the maximum the response will return a
#' `nextToken` value, use this value when you call the action again to get
#' the remaining results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. If your response returns more than the `maxResults` maximum
#' value it will also return a `nextToken` value. For subsequent calls, use
#' the `nextToken` value returned from the previous request to continue
#' listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_usage_totals
inspector2_list_usage_totals <- function(accountIds = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListUsageTotals",
    http_method = "POST",
    http_path = "/usage/list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "totals")
  )
  input <- .inspector2$list_usage_totals_input(accountIds = accountIds, maxResults = maxResults, nextToken = nextToken)
  output <- .inspector2$list_usage_totals_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_usage_totals <- inspector2_list_usage_totals

#' Resets an encryption key
#'
#' @description
#' Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned key.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_reset_encryption_key/](https://www.paws-r-sdk.com/docs/inspector2_reset_encryption_key/) for full documentation.
#'
#' @param resourceType &#91;required&#93; The resource type the key encrypts.
#' @param scanType &#91;required&#93; The scan type the key encrypts.
#'
#' @keywords internal
#'
#' @rdname inspector2_reset_encryption_key
inspector2_reset_encryption_key <- function(resourceType, scanType) {
  op <- new_operation(
    name = "ResetEncryptionKey",
    http_method = "PUT",
    http_path = "/encryptionkey/reset",
    paginator = list()
  )
  input <- .inspector2$reset_encryption_key_input(resourceType = resourceType, scanType = scanType)
  output <- .inspector2$reset_encryption_key_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$reset_encryption_key <- inspector2_reset_encryption_key

#' Lists Amazon Inspector coverage details for a specific vulnerability
#'
#' @description
#' Lists Amazon Inspector coverage details for a specific vulnerability.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_search_vulnerabilities/](https://www.paws-r-sdk.com/docs/inspector2_search_vulnerabilities/) for full documentation.
#'
#' @param filterCriteria &#91;required&#93; The criteria used to filter the results of a vulnerability search.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_search_vulnerabilities
inspector2_search_vulnerabilities <- function(filterCriteria, nextToken = NULL) {
  op <- new_operation(
    name = "SearchVulnerabilities",
    http_method = "POST",
    http_path = "/vulnerabilities/search",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "vulnerabilities")
  )
  input <- .inspector2$search_vulnerabilities_input(filterCriteria = filterCriteria, nextToken = nextToken)
  output <- .inspector2$search_vulnerabilities_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$search_vulnerabilities <- inspector2_search_vulnerabilities

#' Adds tags to a resource
#'
#' @description
#' Adds tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_tag_resource/](https://www.paws-r-sdk.com/docs/inspector2_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to apply a tag to.
#' @param tags &#91;required&#93; The tags to be added to a resource.
#'
#' @keywords internal
#'
#' @rdname inspector2_tag_resource
inspector2_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .inspector2$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .inspector2$tag_resource_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$tag_resource <- inspector2_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_untag_resource/](https://www.paws-r-sdk.com/docs/inspector2_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource to remove tags from.
#' @param tagKeys &#91;required&#93; The tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname inspector2_untag_resource
inspector2_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .inspector2$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .inspector2$untag_resource_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$untag_resource <- inspector2_untag_resource

#' Updates setting configurations for your Amazon Inspector account
#'
#' @description
#' Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization cannot update this setting.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_update_configuration/](https://www.paws-r-sdk.com/docs/inspector2_update_configuration/) for full documentation.
#'
#' @param ecrConfiguration &#91;required&#93; Specifies how the ECR automated re-scan will be updated for your
#' environment.
#'
#' @keywords internal
#'
#' @rdname inspector2_update_configuration
inspector2_update_configuration <- function(ecrConfiguration) {
  op <- new_operation(
    name = "UpdateConfiguration",
    http_method = "POST",
    http_path = "/configuration/update",
    paginator = list()
  )
  input <- .inspector2$update_configuration_input(ecrConfiguration = ecrConfiguration)
  output <- .inspector2$update_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$update_configuration <- inspector2_update_configuration

#' Activates, deactivates Amazon Inspector deep inspection, or updates
#' custom paths for your account
#'
#' @description
#' Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_update_ec_2_deep_inspection_configuration/](https://www.paws-r-sdk.com/docs/inspector2_update_ec_2_deep_inspection_configuration/) for full documentation.
#'
#' @param activateDeepInspection Specify `TRUE` to activate Amazon Inspector deep inspection in your
#' account, or `FALSE` to deactivate. Member accounts in an organization
#' cannot deactivate deep inspection, instead the delegated administrator
#' for the organization can deactivate a member account using
#' [`batch_update_member_ec_2_deep_inspection_status`][inspector2_batch_update_member_ec_2_deep_inspection_status].
#' @param packagePaths The Amazon Inspector deep inspection custom paths you are adding for
#' your account.
#'
#' @keywords internal
#'
#' @rdname inspector2_update_ec_2_deep_inspection_configuration
inspector2_update_ec_2_deep_inspection_configuration <- function(activateDeepInspection = NULL, packagePaths = NULL) {
  op <- new_operation(
    name = "UpdateEc2DeepInspectionConfiguration",
    http_method = "POST",
    http_path = "/ec2deepinspectionconfiguration/update",
    paginator = list()
  )
  input <- .inspector2$update_ec_2_deep_inspection_configuration_input(activateDeepInspection = activateDeepInspection, packagePaths = packagePaths)
  output <- .inspector2$update_ec_2_deep_inspection_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$update_ec_2_deep_inspection_configuration <- inspector2_update_ec_2_deep_inspection_configuration

#' Updates an encryption key
#'
#' @description
#' Updates an encryption key. A `ResourceNotFoundException` means that an AWS owned key is being used for encryption.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_update_encryption_key/](https://www.paws-r-sdk.com/docs/inspector2_update_encryption_key/) for full documentation.
#'
#' @param kmsKeyId &#91;required&#93; A KMS key ID for the encryption key.
#' @param resourceType &#91;required&#93; The resource type for the encryption key.
#' @param scanType &#91;required&#93; The scan type for the encryption key.
#'
#' @keywords internal
#'
#' @rdname inspector2_update_encryption_key
inspector2_update_encryption_key <- function(kmsKeyId, resourceType, scanType) {
  op <- new_operation(
    name = "UpdateEncryptionKey",
    http_method = "PUT",
    http_path = "/encryptionkey/update",
    paginator = list()
  )
  input <- .inspector2$update_encryption_key_input(kmsKeyId = kmsKeyId, resourceType = resourceType, scanType = scanType)
  output <- .inspector2$update_encryption_key_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$update_encryption_key <- inspector2_update_encryption_key

#' Specifies the action that is to be applied to the findings that match
#' the filter
#'
#' @description
#' Specifies the action that is to be applied to the findings that match the filter.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_update_filter/](https://www.paws-r-sdk.com/docs/inspector2_update_filter/) for full documentation.
#'
#' @param action Specifies the action that is to be applied to the findings that match
#' the filter.
#' @param description A description of the filter.
#' @param filterArn &#91;required&#93; The Amazon Resource Number (ARN) of the filter to update.
#' @param filterCriteria Defines the criteria to be update in the filter.
#' @param name The name of the filter.
#' @param reason The reason the filter was updated.
#'
#' @keywords internal
#'
#' @rdname inspector2_update_filter
inspector2_update_filter <- function(action = NULL, description = NULL, filterArn, filterCriteria = NULL, name = NULL, reason = NULL) {
  op <- new_operation(
    name = "UpdateFilter",
    http_method = "POST",
    http_path = "/filters/update",
    paginator = list()
  )
  input <- .inspector2$update_filter_input(action = action, description = description, filterArn = filterArn, filterCriteria = filterCriteria, name = name, reason = reason)
  output <- .inspector2$update_filter_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$update_filter <- inspector2_update_filter

#' Updates the Amazon Inspector deep inspection custom paths for your
#' organization
#'
#' @description
#' Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector delegated administrator to use this API.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_update_org_ec_2_deep_inspection_configuration/](https://www.paws-r-sdk.com/docs/inspector2_update_org_ec_2_deep_inspection_configuration/) for full documentation.
#'
#' @param orgPackagePaths &#91;required&#93; The Amazon Inspector deep inspection custom paths you are adding for
#' your organization.
#'
#' @keywords internal
#'
#' @rdname inspector2_update_org_ec_2_deep_inspection_configuration
inspector2_update_org_ec_2_deep_inspection_configuration <- function(orgPackagePaths) {
  op <- new_operation(
    name = "UpdateOrgEc2DeepInspectionConfiguration",
    http_method = "POST",
    http_path = "/ec2deepinspectionconfiguration/org/update",
    paginator = list()
  )
  input <- .inspector2$update_org_ec_2_deep_inspection_configuration_input(orgPackagePaths = orgPackagePaths)
  output <- .inspector2$update_org_ec_2_deep_inspection_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$update_org_ec_2_deep_inspection_configuration <- inspector2_update_org_ec_2_deep_inspection_configuration

#' Updates the configurations for your Amazon Inspector organization
#'
#' @description
#' Updates the configurations for your Amazon Inspector organization.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector2_update_organization_configuration/](https://www.paws-r-sdk.com/docs/inspector2_update_organization_configuration/) for full documentation.
#'
#' @param autoEnable &#91;required&#93; Defines which scan types are enabled automatically for new members of
#' your Amazon Inspector organization.
#'
#' @keywords internal
#'
#' @rdname inspector2_update_organization_configuration
inspector2_update_organization_configuration <- function(autoEnable) {
  op <- new_operation(
    name = "UpdateOrganizationConfiguration",
    http_method = "POST",
    http_path = "/organizationconfiguration/update",
    paginator = list()
  )
  input <- .inspector2$update_organization_configuration_input(autoEnable = autoEnable)
  output <- .inspector2$update_organization_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$update_organization_configuration <- inspector2_update_organization_configuration
