% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_get_certificate_authority_csr}
\alias{acmpca_get_certificate_authority_csr}
\title{Retrieves the certificate signing request (CSR) for your private
certificate authority (CA)}
\usage{
acmpca_get_certificate_authority_csr(CertificateAuthorityArn)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called the
\code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}}
action. This must be of the form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }}
}
\description{
Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created when you call the \code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}} action. Sign the CSR with your Amazon Web Services Private CA-hosted or on-premises root or subordinate CA. Then import the signed certificate back into Amazon Web Services Private CA by calling the \code{\link[=acmpca_import_certificate_authority_certificate]{import_certificate_authority_certificate}} action. The CSR is returned as a base64 PEM-encoded string.

See \url{https://www.paws-r-sdk.com/docs/acmpca_get_certificate_authority_csr/} for full documentation.
}
\keyword{internal}
