% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_get_secret_value}
\alias{secretsmanager_get_secret_value}
\title{Retrieves the contents of the encrypted fields SecretString or
SecretBinary from the specified version of a secret, whichever contains
content}
\usage{
secretsmanager_get_secret_value(
  SecretId,
  VersionId = NULL,
  VersionStage = NULL
)
}
\arguments{
\item{SecretId}{[required] The ARN or name of the secret to retrieve. To retrieve a secret from
another account, you must use an ARN.

For an ARN, we recommend that you specify a complete ARN rather than a
partial ARN. See \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen}{Finding a secret from a partial ARN}.}

\item{VersionId}{The unique identifier of the version of the secret to retrieve. If you
include both this parameter and \code{VersionStage}, the two parameters must
refer to the same secret version. If you don't specify either a
\code{VersionStage} or \code{VersionId}, then Secrets Manager returns the
\code{AWSCURRENT} version.

This value is typically a
\href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID-type}
value with 32 hexadecimal digits.}

\item{VersionStage}{The staging label of the version of the secret to retrieve.

Secrets Manager uses staging labels to keep track of different versions
during the rotation process. If you include both this parameter and
\code{VersionId}, the two parameters must refer to the same secret version.
If you don't specify either a \code{VersionStage} or \code{VersionId}, Secrets
Manager returns the \code{AWSCURRENT} version.}
}
\description{
Retrieves the contents of the encrypted fields \code{SecretString} or \code{SecretBinary} from the specified version of a secret, whichever contains content.

See \url{https://www.paws-r-sdk.com/docs/secretsmanager_get_secret_value/} for full documentation.
}
\keyword{internal}
