% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_get_backup_plan}
\alias{backup_get_backup_plan}
\title{Returns BackupPlan details for the specified BackupPlanId}
\usage{
backup_get_backup_plan(BackupPlanId, VersionId)
}
\arguments{
\item{BackupPlanId}{[required] Uniquely identifies a backup plan.}

\item{VersionId}{Unique, randomly generated, Unicode, UTF-8 encoded strings that are at
most 1,024 bytes long. Version IDs cannot be edited.}
}
\value{
A list with the following syntax:\preformatted{list(
  BackupPlan = list(
    BackupPlanName = "string",
    Rules = list(
      list(
        RuleName = "string",
        TargetBackupVaultName = "string",
        ScheduleExpression = "string",
        StartWindowMinutes = 123,
        CompletionWindowMinutes = 123,
        Lifecycle = list(
          MoveToColdStorageAfterDays = 123,
          DeleteAfterDays = 123
        ),
        RecoveryPointTags = list(
          "string"
        ),
        RuleId = "string",
        CopyActions = list(
          list(
            Lifecycle = list(
              MoveToColdStorageAfterDays = 123,
              DeleteAfterDays = 123
            ),
            DestinationBackupVaultArn = "string"
          )
        )
      )
    ),
    AdvancedBackupSettings = list(
      list(
        ResourceType = "string",
        BackupOptions = list(
          "string"
        )
      )
    )
  ),
  BackupPlanId = "string",
  BackupPlanArn = "string",
  VersionId = "string",
  CreatorRequestId = "string",
  CreationDate = as.POSIXct(
    "2015-01-01"
  ),
  DeletionDate = as.POSIXct(
    "2015-01-01"
  ),
  LastExecutionDate = as.POSIXct(
    "2015-01-01"
  ),
  AdvancedBackupSettings = list(
    list(
      ResourceType = "string",
      BackupOptions = list(
        "string"
      )
    )
  )
)
}
}
\description{
Returns \code{BackupPlan} details for the specified \code{BackupPlanId}. Returns
the body of a backup plan in JSON format, in addition to plan metadata.
}
\section{Request syntax}{
\preformatted{svc$get_backup_plan(
  BackupPlanId = "string",
  VersionId = "string"
)
}
}

\keyword{internal}
