% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_delete_access_point_policy}
\alias{s3control_delete_access_point_policy}
\title{Deletes the access point policy for the specified access point}
\usage{
s3control_delete_access_point_policy(AccountId, Name)
}
\arguments{
\item{AccountId}{[required] The account ID for the account that owns the specified access point.}

\item{Name}{[required] The name of the access point whose policy you want to delete.

For using this parameter with Amazon S3 on Outposts with the REST API,
you must specify the name and the x-amz-outpost-id as well.

For using this parameter with S3 on Outposts with the AWS SDK and CLI,
you must specify the ARN of the access point accessed in the format
\verb{arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>}.
For example, to access the access point \code{reports-ap} through outpost
\code{my-outpost} owned by account \code{123456789012} in Region \code{us-west-2}, use
the URL encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap}.
The value must be URL encoded.}
}
\value{
An empty list.
}
\description{
Deletes the access point policy for the specified access point.

All Amazon S3 on Outposts REST API requests for this action require an
additional parameter of \code{x-amz-outpost-id} to be passed with the request
and an S3 on Outposts endpoint hostname prefix instead of \code{s3-control}.
For an example of the request syntax for Amazon S3 on Outposts that uses
the S3 on Outposts endpoint hostname prefix and the \code{x-amz-outpost-id}
derived using the access point ARN, see the
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html#API_control_DeleteAccessPointPolicy_Examples}{Examples}
section.

The following actions are related to
\code{\link[=s3control_delete_access_point_policy]{delete_access_point_policy}}:
\itemize{
\item \code{\link[=s3control_put_access_point_policy]{put_access_point_policy}}
\item \code{\link[=s3control_get_access_point_policy]{get_access_point_policy}}
}
}
\section{Request syntax}{
\preformatted{svc$delete_access_point_policy(
  AccountId = "string",
  Name = "string"
)
}
}

\keyword{internal}
