% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_object_retention}
\alias{s3_put_object_retention}
\title{Places an Object Retention configuration on an object}
\usage{
s3_put_object_retention(Bucket, Key, Retention, RequestPayer, VersionId,
  BypassGovernanceRetention, ContentMD5)
}
\arguments{
\item{Bucket}{[required] The bucket that contains the object you want to apply this Object
Retention configuration to.}

\item{Key}{[required] The key name for the object that you want to apply this Object Retention
configuration to.}

\item{Retention}{The container element for the Object Retention configuration.}

\item{RequestPayer}{}

\item{VersionId}{The version ID for the object that you want to apply this Object
Retention configuration to.}

\item{BypassGovernanceRetention}{Indicates whether this operation should bypass Governance-mode
restrictions.j}

\item{ContentMD5}{The MD5 hash for the request body.}
}
\description{
Places an Object Retention configuration on an object.
}
\section{Request syntax}{
\preformatted{svc$put_object_retention(
  Bucket = "string",
  Key = "string",
  Retention = list(
    Mode = "GOVERNANCE"|"COMPLIANCE",
    RetainUntilDate = as.POSIXct(
      "2015-01-01"
    )
  ),
  RequestPayer = "requester",
  VersionId = "string",
  BypassGovernanceRetention = TRUE|FALSE,
  ContentMD5 = "string"
)
}
}

\keyword{internal}
