# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include s3control_service.R
NULL

#' Creates an access point and associates it with the specified bucket
#'
#' Creates an access point and associates it with the specified bucket.
#'
#' @usage
#' s3control_create_access_point(AccountId, Name, Bucket, VpcConfiguration,
#'   PublicAccessBlockConfiguration)
#'
#' @param AccountId &#91;required&#93; The AWS account ID for the owner of the bucket for which you want to
#' create an access point.
#' @param Name &#91;required&#93; The name you want to assign to this access point.
#' @param Bucket &#91;required&#93; The name of the bucket that you want to associate this access point
#' with.
#' @param VpcConfiguration If you include this field, Amazon S3 restricts access to this access
#' point to requests from the specified Virtual Private Cloud (VPC).
#' @param PublicAccessBlockConfiguration 
#'
#' @section Request syntax:
#' ```
#' svc$create_access_point(
#'   AccountId = "string",
#'   Name = "string",
#'   Bucket = "string",
#'   VpcConfiguration = list(
#'     VpcId = "string"
#'   ),
#'   PublicAccessBlockConfiguration = list(
#'     BlockPublicAcls = TRUE|FALSE,
#'     IgnorePublicAcls = TRUE|FALSE,
#'     BlockPublicPolicy = TRUE|FALSE,
#'     RestrictPublicBuckets = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_create_access_point
s3control_create_access_point <- function(AccountId, Name, Bucket, VpcConfiguration = NULL, PublicAccessBlockConfiguration = NULL) {
  op <- new_operation(
    name = "CreateAccessPoint",
    http_method = "PUT",
    http_path = "/v20180820/accesspoint/{name}",
    paginator = list()
  )
  input <- .s3control$create_access_point_input(AccountId = AccountId, Name = Name, Bucket = Bucket, VpcConfiguration = VpcConfiguration, PublicAccessBlockConfiguration = PublicAccessBlockConfiguration)
  output <- .s3control$create_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_access_point <- s3control_create_access_point

#' Creates an Amazon S3 batch operations job
#'
#' Creates an Amazon S3 batch operations job.
#'
#' @usage
#' s3control_create_job(AccountId, ConfirmationRequired, Operation, Report,
#'   ClientRequestToken, Manifest, Description, Priority, RoleArn)
#'
#' @param AccountId &#91;required&#93; 
#' @param ConfirmationRequired Indicates whether confirmation is required before Amazon S3 runs the
#' job. Confirmation is only required for jobs created through the Amazon
#' S3 console.
#' @param Operation &#91;required&#93; The operation that you want this job to perform on each object listed in
#' the manifest. For more information about the available operations, see
#' [Available
#' Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html)
#' in the *Amazon Simple Storage Service Developer Guide*.
#' @param Report &#91;required&#93; Configuration parameters for the optional job-completion report.
#' @param ClientRequestToken &#91;required&#93; An idempotency token to ensure that you don\'t accidentally submit the
#' same request twice. You can use any string up to the maximum length.
#' @param Manifest &#91;required&#93; Configuration parameters for the manifest.
#' @param Description A description for this job. You can use any string within the permitted
#' length. Descriptions don\'t need to be unique and can be used for
#' multiple jobs.
#' @param Priority &#91;required&#93; The numerical priority for this job. Higher numbers indicate higher
#' priority.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) for the Identity and Access Management
#' (IAM) Role that batch operations will use to execute this job\'s
#' operation on each object in the manifest.
#'
#' @section Request syntax:
#' ```
#' svc$create_job(
#'   AccountId = "string",
#'   ConfirmationRequired = TRUE|FALSE,
#'   Operation = list(
#'     LambdaInvoke = list(
#'       FunctionArn = "string"
#'     ),
#'     S3PutObjectCopy = list(
#'       TargetResource = "string",
#'       CannedAccessControlList = "private"|"public-read"|"public-read-write"|"aws-exec-read"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control",
#'       AccessControlGrants = list(
#'         list(
#'           Grantee = list(
#'             TypeIdentifier = "id"|"emailAddress"|"uri",
#'             Identifier = "string",
#'             DisplayName = "string"
#'           ),
#'           Permission = "FULL_CONTROL"|"READ"|"WRITE"|"READ_ACP"|"WRITE_ACP"
#'         )
#'       ),
#'       MetadataDirective = "COPY"|"REPLACE",
#'       ModifiedSinceConstraint = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       NewObjectMetadata = list(
#'         CacheControl = "string",
#'         ContentDisposition = "string",
#'         ContentEncoding = "string",
#'         ContentLanguage = "string",
#'         UserMetadata = list(
#'           "string"
#'         ),
#'         ContentLength = 123,
#'         ContentMD5 = "string",
#'         ContentType = "string",
#'         HttpExpiresDate = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         RequesterCharged = TRUE|FALSE,
#'         SSEAlgorithm = "AES256"|"KMS"
#'       ),
#'       NewObjectTagging = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       ),
#'       RedirectLocation = "string",
#'       RequesterPays = TRUE|FALSE,
#'       StorageClass = "STANDARD"|"STANDARD_IA"|"ONEZONE_IA"|"GLACIER"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE",
#'       UnModifiedSinceConstraint = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       SSEAwsKmsKeyId = "string",
#'       TargetKeyPrefix = "string",
#'       ObjectLockLegalHoldStatus = "OFF"|"ON",
#'       ObjectLockMode = "COMPLIANCE"|"GOVERNANCE",
#'       ObjectLockRetainUntilDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     S3PutObjectAcl = list(
#'       AccessControlPolicy = list(
#'         AccessControlList = list(
#'           Owner = list(
#'             ID = "string",
#'             DisplayName = "string"
#'           ),
#'           Grants = list(
#'             list(
#'               Grantee = list(
#'                 TypeIdentifier = "id"|"emailAddress"|"uri",
#'                 Identifier = "string",
#'                 DisplayName = "string"
#'               ),
#'               Permission = "FULL_CONTROL"|"READ"|"WRITE"|"READ_ACP"|"WRITE_ACP"
#'             )
#'           )
#'         ),
#'         CannedAccessControlList = "private"|"public-read"|"public-read-write"|"aws-exec-read"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control"
#'       )
#'     ),
#'     S3PutObjectTagging = list(
#'       TagSet = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     ),
#'     S3InitiateRestoreObject = list(
#'       ExpirationInDays = 123,
#'       GlacierJobTier = "BULK"|"STANDARD"
#'     )
#'   ),
#'   Report = list(
#'     Bucket = "string",
#'     Format = "Report_CSV_20180820",
#'     Enabled = TRUE|FALSE,
#'     Prefix = "string",
#'     ReportScope = "AllTasks"|"FailedTasksOnly"
#'   ),
#'   ClientRequestToken = "string",
#'   Manifest = list(
#'     Spec = list(
#'       Format = "S3BatchOperations_CSV_20180820"|"S3InventoryReport_CSV_20161130",
#'       Fields = list(
#'         "Ignore"|"Bucket"|"Key"|"VersionId"
#'       )
#'     ),
#'     Location = list(
#'       ObjectArn = "string",
#'       ObjectVersionId = "string",
#'       ETag = "string"
#'     )
#'   ),
#'   Description = "string",
#'   Priority = 123,
#'   RoleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_create_job
s3control_create_job <- function(AccountId, ConfirmationRequired = NULL, Operation, Report, ClientRequestToken, Manifest, Description = NULL, Priority, RoleArn) {
  op <- new_operation(
    name = "CreateJob",
    http_method = "POST",
    http_path = "/v20180820/jobs",
    paginator = list()
  )
  input <- .s3control$create_job_input(AccountId = AccountId, ConfirmationRequired = ConfirmationRequired, Operation = Operation, Report = Report, ClientRequestToken = ClientRequestToken, Manifest = Manifest, Description = Description, Priority = Priority, RoleArn = RoleArn)
  output <- .s3control$create_job_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_job <- s3control_create_job

#' Deletes the specified access point
#'
#' Deletes the specified access point.
#'
#' @usage
#' s3control_delete_access_point(AccountId, Name)
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_access_point(
#'   AccountId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_point
s3control_delete_access_point <- function(AccountId, Name) {
  op <- new_operation(
    name = "DeleteAccessPoint",
    http_method = "DELETE",
    http_path = "/v20180820/accesspoint/{name}",
    paginator = list()
  )
  input <- .s3control$delete_access_point_input(AccountId = AccountId, Name = Name)
  output <- .s3control$delete_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_point <- s3control_delete_access_point

#' Deletes the access point policy for the specified access point
#'
#' Deletes the access point policy for the specified access point.
#'
#' @usage
#' s3control_delete_access_point_policy(AccountId, Name)
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose policy you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_access_point_policy(
#'   AccountId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_point_policy
s3control_delete_access_point_policy <- function(AccountId, Name) {
  op <- new_operation(
    name = "DeleteAccessPointPolicy",
    http_method = "DELETE",
    http_path = "/v20180820/accesspoint/{name}/policy",
    paginator = list()
  )
  input <- .s3control$delete_access_point_policy_input(AccountId = AccountId, Name = Name)
  output <- .s3control$delete_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_point_policy <- s3control_delete_access_point_policy

#' Removes the PublicAccessBlock configuration for an Amazon Web Services
#' account
#'
#' Removes the `PublicAccessBlock` configuration for an Amazon Web Services
#' account.
#'
#' @usage
#' s3control_delete_public_access_block(AccountId)
#'
#' @param AccountId &#91;required&#93; The account ID for the Amazon Web Services account whose
#' `PublicAccessBlock` configuration you want to remove.
#'
#' @section Request syntax:
#' ```
#' svc$delete_public_access_block(
#'   AccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_delete_public_access_block
s3control_delete_public_access_block <- function(AccountId) {
  op <- new_operation(
    name = "DeletePublicAccessBlock",
    http_method = "DELETE",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$delete_public_access_block_input(AccountId = AccountId)
  output <- .s3control$delete_public_access_block_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_public_access_block <- s3control_delete_public_access_block

#' Retrieves the configuration parameters and status for a batch operations
#' job
#'
#' Retrieves the configuration parameters and status for a batch operations
#' job.
#'
#' @usage
#' s3control_describe_job(AccountId, JobId)
#'
#' @param AccountId &#91;required&#93; 
#' @param JobId &#91;required&#93; The ID for the job whose information you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_job(
#'   AccountId = "string",
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_describe_job
s3control_describe_job <- function(AccountId, JobId) {
  op <- new_operation(
    name = "DescribeJob",
    http_method = "GET",
    http_path = "/v20180820/jobs/{id}",
    paginator = list()
  )
  input <- .s3control$describe_job_input(AccountId = AccountId, JobId = JobId)
  output <- .s3control$describe_job_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$describe_job <- s3control_describe_job

#' Returns configuration information about the specified access point
#'
#' Returns configuration information about the specified access point.
#'
#' @usage
#' s3control_get_access_point(AccountId, Name)
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose configuration information you want to
#' retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_access_point(
#'   AccountId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point
s3control_get_access_point <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPoint",
    http_method = "GET",
    http_path = "/v20180820/accesspoint/{name}",
    paginator = list()
  )
  input <- .s3control$get_access_point_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point <- s3control_get_access_point

#' Returns the access point policy associated with the specified access
#' point
#'
#' Returns the access point policy associated with the specified access
#' point.
#'
#' @usage
#' s3control_get_access_point_policy(AccountId, Name)
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose policy you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_access_point_policy(
#'   AccountId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_policy
s3control_get_access_point_policy <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointPolicy",
    http_method = "GET",
    http_path = "/v20180820/accesspoint/{name}/policy",
    paginator = list()
  )
  input <- .s3control$get_access_point_policy_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_policy <- s3control_get_access_point_policy

#' Indicates whether the specified access point currently has a policy that
#' allows public access
#'
#' Indicates whether the specified access point currently has a policy that
#' allows public access. For more information about public access through
#' access points, see [Managing Data Access with Amazon S3 Access
#' Points](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html)
#' in the *Amazon Simple Storage Service Developer Guide*.
#'
#' @usage
#' s3control_get_access_point_policy_status(AccountId, Name)
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose policy status you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_access_point_policy_status(
#'   AccountId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_policy_status
s3control_get_access_point_policy_status <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointPolicyStatus",
    http_method = "GET",
    http_path = "/v20180820/accesspoint/{name}/policyStatus",
    paginator = list()
  )
  input <- .s3control$get_access_point_policy_status_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_policy_status_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_policy_status <- s3control_get_access_point_policy_status

#' Retrieves the PublicAccessBlock configuration for an Amazon Web Services
#' account
#'
#' Retrieves the `PublicAccessBlock` configuration for an Amazon Web
#' Services account.
#'
#' @usage
#' s3control_get_public_access_block(AccountId)
#'
#' @param AccountId &#91;required&#93; The account ID for the Amazon Web Services account whose
#' `PublicAccessBlock` configuration you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_public_access_block(
#'   AccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_get_public_access_block
s3control_get_public_access_block <- function(AccountId) {
  op <- new_operation(
    name = "GetPublicAccessBlock",
    http_method = "GET",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$get_public_access_block_input(AccountId = AccountId)
  output <- .s3control$get_public_access_block_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_public_access_block <- s3control_get_public_access_block

#' Returns a list of the access points currently associated with the
#' specified bucket
#'
#' Returns a list of the access points currently associated with the
#' specified bucket. You can retrieve up to 1000 access points per call. If
#' the specified bucket has more than 1000 access points (or the number
#' specified in `maxResults`, whichever is less), then the response will
#' include a continuation token that you can use to list the additional
#' access points.
#'
#' @usage
#' s3control_list_access_points(AccountId, Bucket, NextToken, MaxResults)
#'
#' @param AccountId &#91;required&#93; The AWS account ID for owner of the bucket whose access points you want
#' to list.
#' @param Bucket The name of the bucket whose associated access points you want to list.
#' @param NextToken A continuation token. If a previous call to `ListAccessPoints` returned
#' a continuation token in the `NextToken` field, then providing that value
#' here causes Amazon S3 to retrieve the next page of results.
#' @param MaxResults The maximum number of access points that you want to include in the
#' list. If the specified bucket has more than this number of access
#' points, then the response will include a continuation token in the
#' `NextToken` field that you can use to retrieve the next page of access
#' points.
#'
#' @section Request syntax:
#' ```
#' svc$list_access_points(
#'   AccountId = "string",
#'   Bucket = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_list_access_points
s3control_list_access_points <- function(AccountId, Bucket = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccessPoints",
    http_method = "GET",
    http_path = "/v20180820/accesspoint",
    paginator = list()
  )
  input <- .s3control$list_access_points_input(AccountId = AccountId, Bucket = Bucket, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_access_points_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_access_points <- s3control_list_access_points

#' Lists current jobs and jobs that have ended within the last 30 days for
#' the AWS account making the request
#'
#' Lists current jobs and jobs that have ended within the last 30 days for
#' the AWS account making the request.
#'
#' @usage
#' s3control_list_jobs(AccountId, JobStatuses, NextToken, MaxResults)
#'
#' @param AccountId &#91;required&#93; 
#' @param JobStatuses The `List Jobs` request returns jobs that match the statuses listed in
#' this element.
#' @param NextToken A pagination token to request the next page of results. Use the token
#' that Amazon S3 returned in the `NextToken` element of the
#' `ListJobsResult` from the previous `List Jobs` request.
#' @param MaxResults The maximum number of jobs that Amazon S3 will include in the
#' `List Jobs` response. If there are more jobs than this number, the
#' response will include a pagination token in the `NextToken` field to
#' enable you to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_jobs(
#'   AccountId = "string",
#'   JobStatuses = list(
#'     "Active"|"Cancelled"|"Cancelling"|"Complete"|"Completing"|"Failed"|"Failing"|"New"|"Paused"|"Pausing"|"Preparing"|"Ready"|"Suspended"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_list_jobs
s3control_list_jobs <- function(AccountId, JobStatuses = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListJobs",
    http_method = "GET",
    http_path = "/v20180820/jobs",
    paginator = list()
  )
  input <- .s3control$list_jobs_input(AccountId = AccountId, JobStatuses = JobStatuses, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_jobs_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_jobs <- s3control_list_jobs

#' Associates an access policy with the specified access point
#'
#' Associates an access policy with the specified access point. Each access
#' point can have only one policy, so a request made to this API replaces
#' any existing policy associated with the specified access point.
#'
#' @usage
#' s3control_put_access_point_policy(AccountId, Name, Policy)
#'
#' @param AccountId &#91;required&#93; The AWS account ID for owner of the bucket associated with the specified
#' access point.
#' @param Name &#91;required&#93; The name of the access point that you want to associate with the
#' specified policy.
#' @param Policy &#91;required&#93; The policy that you want to apply to the specified access point. For
#' more information about access point policies, see [Managing Data Access
#' with Amazon S3 Access
#' Points](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html)
#' in the *Amazon Simple Storage Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$put_access_point_policy(
#'   AccountId = "string",
#'   Name = "string",
#'   Policy = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_put_access_point_policy
s3control_put_access_point_policy <- function(AccountId, Name, Policy) {
  op <- new_operation(
    name = "PutAccessPointPolicy",
    http_method = "PUT",
    http_path = "/v20180820/accesspoint/{name}/policy",
    paginator = list()
  )
  input <- .s3control$put_access_point_policy_input(AccountId = AccountId, Name = Name, Policy = Policy)
  output <- .s3control$put_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_access_point_policy <- s3control_put_access_point_policy

#' Creates or modifies the PublicAccessBlock configuration for an Amazon
#' Web Services account
#'
#' Creates or modifies the `PublicAccessBlock` configuration for an Amazon
#' Web Services account.
#'
#' @usage
#' s3control_put_public_access_block(PublicAccessBlockConfiguration,
#'   AccountId)
#'
#' @param PublicAccessBlockConfiguration &#91;required&#93; The `PublicAccessBlock` configuration that you want to apply to the
#' specified Amazon Web Services account.
#' @param AccountId &#91;required&#93; The account ID for the Amazon Web Services account whose
#' `PublicAccessBlock` configuration you want to set.
#'
#' @section Request syntax:
#' ```
#' svc$put_public_access_block(
#'   PublicAccessBlockConfiguration = list(
#'     BlockPublicAcls = TRUE|FALSE,
#'     IgnorePublicAcls = TRUE|FALSE,
#'     BlockPublicPolicy = TRUE|FALSE,
#'     RestrictPublicBuckets = TRUE|FALSE
#'   ),
#'   AccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_put_public_access_block
s3control_put_public_access_block <- function(PublicAccessBlockConfiguration, AccountId) {
  op <- new_operation(
    name = "PutPublicAccessBlock",
    http_method = "PUT",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$put_public_access_block_input(PublicAccessBlockConfiguration = PublicAccessBlockConfiguration, AccountId = AccountId)
  output <- .s3control$put_public_access_block_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_public_access_block <- s3control_put_public_access_block

#' Updates an existing job's priority
#'
#' Updates an existing job\'s priority.
#'
#' @usage
#' s3control_update_job_priority(AccountId, JobId, Priority)
#'
#' @param AccountId &#91;required&#93; 
#' @param JobId &#91;required&#93; The ID for the job whose priority you want to update.
#' @param Priority &#91;required&#93; The priority you want to assign to this job.
#'
#' @section Request syntax:
#' ```
#' svc$update_job_priority(
#'   AccountId = "string",
#'   JobId = "string",
#'   Priority = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_update_job_priority
s3control_update_job_priority <- function(AccountId, JobId, Priority) {
  op <- new_operation(
    name = "UpdateJobPriority",
    http_method = "POST",
    http_path = "/v20180820/jobs/{id}/priority",
    paginator = list()
  )
  input <- .s3control$update_job_priority_input(AccountId = AccountId, JobId = JobId, Priority = Priority)
  output <- .s3control$update_job_priority_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$update_job_priority <- s3control_update_job_priority

#' Updates the status for the specified job
#'
#' Updates the status for the specified job. Use this operation to confirm
#' that you want to run a job or to cancel an existing job.
#'
#' @usage
#' s3control_update_job_status(AccountId, JobId, RequestedJobStatus,
#'   StatusUpdateReason)
#'
#' @param AccountId &#91;required&#93; 
#' @param JobId &#91;required&#93; The ID of the job whose status you want to update.
#' @param RequestedJobStatus &#91;required&#93; The status that you want to move the specified job to.
#' @param StatusUpdateReason A description of the reason why you want to change the specified job\'s
#' status. This field can be any string up to the maximum length.
#'
#' @section Request syntax:
#' ```
#' svc$update_job_status(
#'   AccountId = "string",
#'   JobId = "string",
#'   RequestedJobStatus = "Cancelled"|"Ready",
#'   StatusUpdateReason = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3control_update_job_status
s3control_update_job_status <- function(AccountId, JobId, RequestedJobStatus, StatusUpdateReason = NULL) {
  op <- new_operation(
    name = "UpdateJobStatus",
    http_method = "POST",
    http_path = "/v20180820/jobs/{id}/status",
    paginator = list()
  )
  input <- .s3control$update_job_status_input(AccountId = AccountId, JobId = JobId, RequestedJobStatus = RequestedJobStatus, StatusUpdateReason = StatusUpdateReason)
  output <- .s3control$update_job_status_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$update_job_status <- s3control_update_job_status
