% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_bucket_encryption}
\alias{s3_delete_bucket_encryption}
\title{This implementation of the DELETE action removes default encryption from
the bucket}
\usage{
s3_delete_bucket_encryption(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The name of the bucket containing the server-side encryption
configuration to delete.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
This implementation of the DELETE action removes default encryption from the bucket. For information about the Amazon S3 default encryption feature, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html}{Amazon S3 Default Bucket Encryption} in the \emph{Amazon S3 User Guide}.

See \url{https://paws-r.github.io/docs/s3/delete_bucket_encryption.html} for full documentation.
}
\keyword{internal}
