% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_list_recovery_points_by_backup_vault}
\alias{backup_list_recovery_points_by_backup_vault}
\title{Returns detailed information about the recovery points stored in a
backup vault}
\usage{
backup_list_recovery_points_by_backup_vault(
  BackupVaultName,
  BackupVaultAccountId = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  ByResourceArn = NULL,
  ByResourceType = NULL,
  ByBackupPlanId = NULL,
  ByCreatedBefore = NULL,
  ByCreatedAfter = NULL,
  ByParentRecoveryPointArn = NULL
)
}
\arguments{
\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Backup vaults
are identified by names that are unique to the account used to create
them and the Amazon Web Services Region where they are created. They
consist of lowercase letters, numbers, and hyphens.

Backup vault name might not be available when a supported service
creates the backup.}

\item{BackupVaultAccountId}{This parameter will sort the list of recovery points by account ID.}

\item{NextToken}{The next item following a partial list of returned items. For example,
if a request is made to return \code{maxResults} number of items, \code{NextToken}
allows you to return more items in your list starting at the location
pointed to by the next token.}

\item{MaxResults}{The maximum number of items to be returned.}

\item{ByResourceArn}{Returns only recovery points that match the specified resource Amazon
Resource Name (ARN).}

\item{ByResourceType}{Returns only recovery points that match the specified resource type.}

\item{ByBackupPlanId}{Returns only recovery points that match the specified backup plan ID.}

\item{ByCreatedBefore}{Returns only recovery points that were created before the specified
timestamp.}

\item{ByCreatedAfter}{Returns only recovery points that were created after the specified
timestamp.}

\item{ByParentRecoveryPointArn}{This returns only recovery points that match the specified parent
(composite) recovery point Amazon Resource Name (ARN).}
}
\description{
Returns detailed information about the recovery points stored in a backup vault.

See \url{https://www.paws-r-sdk.com/docs/backup_list_recovery_points_by_backup_vault/} for full documentation.
}
\keyword{internal}
