% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_object}
\alias{s3_delete_object}
\title{Removes the null version (if there is one) of an object and inserts a
delete marker, which becomes the latest version of the object}
\usage{
s3_delete_object(
  Bucket,
  Key,
  MFA = NULL,
  VersionId = NULL,
  RequestPayer = NULL,
  BypassGovernanceRetention = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The bucket name of the bucket containing the object.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

When you use this action with Amazon S3 on Outposts, you must direct
requests to the S3 on Outposts hostname. The S3 on Outposts hostname
takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When you use this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts access point ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{What is S3 on Outposts?}
in the \emph{Amazon S3 User Guide}.}

\item{Key}{[required] Key name of the object to delete.}

\item{MFA}{The concatenation of the authentication device's serial number, a space,
and the value that is displayed on your authentication device. Required
to permanently delete a versioned object if versioning is configured
with MFA delete enabled.}

\item{VersionId}{VersionId used to reference a specific version of the object.}

\item{RequestPayer}{}

\item{BypassGovernanceRetention}{Indicates whether S3 Object Lock should bypass Governance-mode
restrictions to process this operation. To use this header, you must
have the \code{s3:BypassGovernanceRetention} permission.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Removes the null version (if there is one) of an object and inserts a delete marker, which becomes the latest version of the object. If there isn't a null version, Amazon S3 does not remove any objects but will still respond that the command was successful.

See \url{https://www.paws-r-sdk.com/docs/s3_delete_object/} for full documentation.
}
\keyword{internal}
