% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_logic.r
\docType{methods}
\name{Comparators}
\alias{!=,ddmatrix,ddmatrix-method}
\alias{!=,ddmatrix,numeric-method}
\alias{!=,numeric,ddmatrix-method}
\alias{&,ddmatrix,ddmatrix-method}
\alias{&,ddmatrix,numeric-method}
\alias{&,numeric,ddmatrix-method}
\alias{<,ddmatrix,ddmatrix-method}
\alias{<,ddmatrix,numeric-method}
\alias{<,numeric,ddmatrix-method}
\alias{<=,ddmatrix,ddmatrix-method}
\alias{<=,ddmatrix,numeric-method}
\alias{<=,numeric,ddmatrix-method}
\alias{==,ddmatrix,ddmatrix-method}
\alias{==,ddmatrix,numeric-method}
\alias{==,numeric,ddmatrix-method}
\alias{>,ddmatrix,ddmatrix-method}
\alias{>,ddmatrix,numeric-method}
\alias{>,numeric,ddmatrix-method}
\alias{>=,ddmatrix,ddmatrix-method}
\alias{>=,ddmatrix,numeric-method}
\alias{>=,numeric,ddmatrix-method}
\alias{Comparators}
\alias{all,ddmatrix-method}
\alias{any,ddmatrix-method}
\alias{|,ddmatrix,ddmatrix-method}
\alias{|,ddmatrix,numeric-method}
\alias{|,numeric,ddmatrix-method}
\title{Logical Comparisons}
\usage{
\S4method{==}{ddmatrix,ddmatrix}(e1, e2)

\S4method{!=}{ddmatrix,ddmatrix}(e1, e2)

\S4method{all}{ddmatrix}(x, na.rm = FALSE)

\S4method{any}{ddmatrix}(x, na.rm = FALSE)

\S4method{<}{ddmatrix,ddmatrix}(e1, e2)

\S4method{>}{ddmatrix,ddmatrix}(e1, e2)

\S4method{<=}{ddmatrix,ddmatrix}(e1, e2)

\S4method{>=}{ddmatrix,ddmatrix}(e1, e2)

\S4method{|}{ddmatrix,ddmatrix}(e1, e2)

\S4method{&}{ddmatrix,ddmatrix}(e1, e2)

\S4method{<}{ddmatrix,numeric}(e1, e2)

\S4method{<}{numeric,ddmatrix}(e1, e2)

\S4method{>}{ddmatrix,numeric}(e1, e2)

\S4method{>}{numeric,ddmatrix}(e1, e2)

\S4method{<=}{ddmatrix,numeric}(e1, e2)

\S4method{<=}{numeric,ddmatrix}(e1, e2)

\S4method{>=}{ddmatrix,numeric}(e1, e2)

\S4method{>=}{numeric,ddmatrix}(e1, e2)

\S4method{==}{ddmatrix,numeric}(e1, e2)

\S4method{==}{numeric,ddmatrix}(e1, e2)

\S4method{!=}{ddmatrix,numeric}(e1, e2)

\S4method{!=}{numeric,ddmatrix}(e1, e2)

\S4method{|}{ddmatrix,numeric}(e1, e2)

\S4method{|}{numeric,ddmatrix}(e1, e2)

\S4method{&}{ddmatrix,numeric}(e1, e2)

\S4method{&}{numeric,ddmatrix}(e1, e2)
}
\arguments{
\item{e1, e2, x}{distributed matrix or numeric vector}

\item{na.rm}{logical, indicating whether or not \code{NA}'s should first be
removed. If not and an NA is present, \code{NA} is returned.}
}
\value{
Returns a distributed matrix.
}
\description{
Logical comparisons.
}
\details{
Performs the indicated logical comparison.

If \code{na.rm} is \code{TRUE} and only \code{NA}'s are present, then
\code{TRUE} is returned.
}
\examples{

\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

# don't do this in production code
x <- matrix(sample(0, 1, 9, replace=T), 3)
comm.print(x)

x <- as.ddmatrix(x, bldim=2)

y <- any(x)
comm.print(y)

finalize()
}

}
\keyword{Extraction}
\keyword{Methods}
\keyword{Type}

