% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_reductions.R
\docType{methods}
\name{reductions}
\alias{reductions}
\alias{rowMin}
\alias{rowMax}
\alias{colMin}
\alias{colMax}
\alias{rowSums,ddmatrix-method}
\alias{colSums,ddmatrix-method}
\alias{rowMeans,ddmatrix-method}
\alias{colMeans,ddmatrix-method}
\alias{rowMin,ddmatrix-method}
\alias{rowMin,matrix-method}
\alias{colMin,ddmatrix-method}
\alias{colMin,matrix-method}
\alias{rowMax,ddmatrix-method}
\alias{rowMax,matrix-method}
\alias{colMax,ddmatrix-method}
\title{Arithmetic Reductions: Sums, Means, and Prods}
\usage{
rowMin(x, ...)

rowMax(x, ...)

colMin(x, ...)

colMax(x, ...)

\S4method{rowSums}{ddmatrix}(x, na.rm = FALSE)

\S4method{colSums}{ddmatrix}(x, na.rm = FALSE)

\S4method{rowMeans}{ddmatrix}(x, na.rm = FALSE)

\S4method{colMeans}{ddmatrix}(x, na.rm = FALSE)

\S4method{rowMin}{ddmatrix}(x, na.rm = FALSE)

\S4method{rowMin}{matrix}(x, na.rm = FALSE)

\S4method{colMin}{ddmatrix}(x, na.rm = FALSE)

\S4method{colMin}{matrix}(x, na.rm = FALSE)

\S4method{rowMax}{ddmatrix}(x, na.rm = FALSE)

\S4method{rowMax}{matrix}(x, na.rm = FALSE)

\S4method{colMax}{ddmatrix}(x, na.rm = FALSE)

\S4method{colMin}{matrix}(x, na.rm = FALSE)
}
\arguments{
\item{x}{numeric distributed matrix}

\item{...}{additional arguments}

\item{na.rm}{logical. Should missing (including \code{NaN}) be removed?}
}
\value{
Returns a global numeric vector.
}
\description{
Arithmetic reductions for distributed matrices.
}
\details{
Performs the reduction operation on a distributed matrix.

There are several legitimately new operations, including \code{rowMin()},
\code{rowMax()}, \code{colMin()}, and \code{colMax()}.  These
implementations are not really necessary in R because one can easily (and
reasonably efficiently) do something like

\code{apply(X=x, MARGIN=1L, FUN=min, na.rm=TRUE)}

But \code{apply()} on a \code{ddmatrix} is \emph{very} costly, and should be
used sparingly.

\code{sd()} will compute the standard deviations of the columns, equivalent
to calling \code{apply(x, MARGIN=2, FUN=sd)} (which will work for
distributed matrices, by the way). However, this should be much faster and
use less memory than \code{apply()}.  If \code{reduce=FALSE} then the return
is a distributed matrix consisting of one (global) row; otherwise, an
\code{R} vector is returned, with ownership of this vector determined by
\code{proc.dest}.
}
\keyword{Methods}
