# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

ccc_mat_rcpp <- function(dx, pc, version = 9L) {
    .Call('_pccc_ccc_mat_rcpp', PACKAGE = 'pccc', dx, pc, version)
}

#' Get (view) Diagnostic and Procedure Codes
#'
#' View the ICD, version 9 or 10, for the Complex Chronic Conditions (CCC)
#' categories.
#'
#'  The CCC categories for diagnostic and procedure codes are:
#'  \tabular{lcccc}{
#'  category        \tab \code{dx} \tab \code{dx_fixed} \tab \code{pc} \tab \code{pc_fixed} \cr
#'  neuromuscul     \tab      X    \tab      X           \tab     X    \tab        \cr
#'  cvd             \tab      X    \tab      X           \tab     X    \tab        \cr
#'  respiratory     \tab      X    \tab      X           \tab     X    \tab        \cr
#'  renal           \tab      X    \tab                  \tab     X    \tab        \cr
#'  gi              \tab      X    \tab                  \tab     X    \tab        \cr
#'  hemato_immu     \tab      X    \tab                  \tab     X    \tab        \cr
#'  metabolic       \tab      X    \tab                  \tab     X    \tab      X \cr
#'  congeni_genetic \tab      X    \tab                  \tab          \tab        \cr
#'  malignancy      \tab      X    \tab                  \tab     X    \tab        \cr
#'  neonatal        \tab      X    \tab                  \tab          \tab        \cr
#'  tech_dep        \tab      X    \tab                  \tab     X    \tab        \cr
#'  transplant      \tab      X    \tab                  \tab     X    \tab        \cr
#'  }
#'
#' The ICD codes were taken from the SAS macro provided by the reference paper.
#'
#' @references
#' Feudtner C, et al. Pediatric complex chronic conditions classification system
#' version 2: updated for ICD-10 and complex medical technology dependence and
#' transplantation, BMC Pediatrics, 2014, 14:199, DOI: 10.1186/1471-2431-14-199
#'
#' @param icdv and integer value specifying ICD version.  Accepted values are 9
#' or 10.
#'
#' @example examples/get_codes.R
#'
#' @return
#' A matrix of character vectors.  Rows are the categories and columns for
#' diagnostic and procedure codes.
#'
#' @export
get_codes <- function(icdv) {
    .Call('_pccc_get_codes', PACKAGE = 'pccc', icdv)
}

