% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSimUG2D.R
\name{num.edgesCSstd.tri}
\alias{num.edgesCSstd.tri}
\title{Number of edges in the underlying or reflexivity graphs of
Central Similarity Proximity Catch Digraphs (CS-PCDs) -
standard equilateral triangle case}
\usage{
num.edgesCSstd.tri(
  Xp,
  t,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity")
)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying
or reflexivity graphs based on the CS-PCD.}

\item{t}{A positive real number
which serves as the expansion parameter for CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center
in the interior of the standard equilateral triangle \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}

\item{ugraph}{The type of the graph based on CS-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
A \code{list} with the elements
\item{desc}{A short description of the output: number of edges
and quantities related to the standard equilateral triangle}
\item{und.graph}{Type of the graph as "Underlying" or "Reflexivity" for the CS-PCD}
\item{num.edges}{Number of edges of the underlying
or reflexivity graphs based on the CS-PCD
with vertices in the standard equilateral triangle \eqn{T_e}}
\item{num.in.tri}{Number of \code{Xp} points
in the standard equilateral triangle, \eqn{T_e}}
\item{ind.in.tri}{The vector of indices of the \code{Xp} points
that reside in \eqn{T_e}}
\item{tess.points}{Tessellation points,
i.e., points on which the tessellation of the study region is performed,
here, tessellation is the support triangle \eqn{T_e}.}
\item{vertices}{Vertices of the underlying or reflexivity graph, \code{Xp}.}
}
\description{
An object of class \code{"NumEdges"}.
Returns the number of edges of
the underlying or reflexivity graphs of
Central Similarity Proximity Catch Digraphs (CS-PCDs)
whose vertices are the
given 2D numerical data set, \code{Xp}
in the standard equilateral triangle.
It also provides number of vertices
(i.e., number of data points inside the triangle)
and indices of the data points that reside in the triangle.

CS proximity region \eqn{N_{CS}(x,t)} is defined
with respect to the standard equilateral triangle
\eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}
with expansion parameter \eqn{t > 0}
and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \eqn{T_e}.
For the number of edges, loops are not allowed so
edges are only possible for points inside \eqn{T_e} for this function.

See also (\insertCite{ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
n<-10

set.seed(1)
Xp<-pcds::runif.std.tri(n)$gen.points

M<-c(.6,.2)

Nedges = num.edgesCSstd.tri(Xp,t=1.5,M)
Nedges
summary(Nedges)
plot(Nedges)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{num.edgesCStri}}, \code{\link{num.edgesCS}},
and \code{\link[pcds]{num.arcsCSstd.tri}}
}
\author{
Elvan Ceyhan
}
