% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{Gam2CS.Te.onesixth}
\alias{Gam2CS.Te.onesixth}
\title{The indicator for two points constituting a dominating set for Central Similarity Proximity Catch Digraphs
(CS-PCDs) - first one-sixth of the standard equilateral triangle case}
\usage{
Gam2CS.Te.onesixth(p1, p2, Xp, ch.data.pnts = FALSE)
}
\arguments{
\item{p1, p2}{Two 2D points to be tested for constituting a dominating set of the CS-PCD.}

\item{Xp}{A set of 2D points which constitutes the vertices of the CS-PCD.}

\item{ch.data.pnts}{A logical argument for checking whether points \code{p1} and \code{p2} are
data points in \code{Xp} or not (default is \code{FALSE}).}
}
\value{
\eqn{I(}\{\code{p1,p2}\} is a dominating set of the CS-PCD\eqn{)} where the vertices of the CS-PCD are the 2D data set \code{Xp}),
that is, returns 1 if \{\code{p1,p2}\} is a dominating set of CS-PCD, returns 0 otherwise
}
\description{
Returns \eqn{I(}\{\code{p1,p2}\} is a dominating set of the CS-PCD\eqn{)} where the vertices of the CS-PCD are the 2D data set \code{Xp}),
that is, returns 1 if \code{p} is a dominating point of CS-PCD, returns 0 otherwise.

CS proximity region is
constructed with respect to the standard equilateral triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} and
with expansion parameter \eqn{t=1}. Point, \code{p1}, must lie in the first one-sixth of \eqn{T_e}, which is the triangle with
vertices \eqn{T(A,D_3,CM)=T((0,0),(1/2,0),CM)}.

\code{ch.data.pnts} is for checking whether points \code{p1} and \code{p2} are data points in \code{Xp} or not
(default is \code{FALSE}), so by default this function checks whether the points \code{p1} and \code{p2} would be a
dominating set if they actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis;textual}{pcds}).
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Gam2CSTe}}
}
\author{
Elvan Ceyhan
}
