% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{IncMatCS}
\alias{IncMatCS}
\title{Incidence matrix for Central Similarity Proximity Catch Digraphs (CS-PCDs) - multiple triangle case}
\usage{
IncMatCS(Xp, Yp, t, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the CS-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 3D point in barycentric coordinates which serves as a center in the interior of each Delaunay
triangle, default for \eqn{M=(1,1,1)} which is the center of mass of each triangle.}
}
\value{
Incidence matrix for the CS-PCD with vertices being 2D data set, \code{Xp}.
CS proximity regions are constructed with respect to the Delaunay triangles and \code{M}-edge regions.
}
\description{
Returns the incidence matrix of Central Similarity Proximity Catch Digraph (CS-PCD) whose vertices are the
data points in \code{Xp} in the multiple triangle case.

CS proximity regions are defined with respect to the
Delaunay triangles based on \code{Yp} points with expansion parameter \eqn{t>0} and edge regions in each triangle are
based on the center \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of each Delaunay
triangle (default for \eqn{M=(1,1,1)} which is the center of mass of the triangle).
Each Delaunay triangle is first converted to an (nonscaled) basic triangle so that \code{M} will be the same
type of center for each Delaunay triangle (this conversion is not necessary when \code{M} is \eqn{CM}).

Convex hull of \code{Yp} is partitioned by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles whose union constitutes the
convex hull of \code{Yp} points). For the incidence matrix loops are allowed,
so the diagonal entries are all equal to 1.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}) for more on CS-PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
\dontrun{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

t<-1.5  #try also t<-2

IM<-IncMatCS(Xp,Yp,t,M)
IM
dom.greedy(IM) #try also dom.exact(IM)  #takes a very long time for large nx, try smaller nx
IndUBdom(IM,3)  #takes a very long time for large nx, try smaller nx
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IncMatCStri}}, \code{\link{IncMatCSTe}}, \code{\link{IncMatAS}},
and \code{\link{IncMatPE}}
}
\author{
Elvan Ceyhan
}
