% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{re.bas.tri.cent}
\alias{re.bas.tri.cent}
\title{The index of the edge region in a standard basic triangle form that contains a point}
\usage{
re.bas.tri.cent(p, c1, c2, M)
}
\arguments{
\item{p}{A 2D point for which \code{M}-edge region it resides in is to be determined in the
standard basic triangle form \eqn{T_b}.}

\item{c1, c2}{Positive real numbers which constitute the upper vertex of the standard basic triangle form (i.e., the vertex
adjacent to the shorter edges of \eqn{T_b}); \eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and
\eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard basic triangle form \eqn{T_b}.}
}
\value{
A \code{list} with three elements

\item{re}{Index of the \code{M}-edge region that contains point, \code{p} in the standard basic triangle form \eqn{T_b}.}
\item{tri}{The vertices of the triangle, where row labels are \eqn{A}, \eqn{B}, and \eqn{C}
with edges are labeled as 3 for edge \eqn{AB}, 1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.}
\item{desc}{Description of the edge labels}
}
\description{
Returns the index of the edge whose region contains point, \code{p}, in
the standard basic triangle form \eqn{T_b=T(A=(0,0),B=(1,0),C=(c_1,c_2))} and edge regions based on center
\eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the standard basic triangle form \eqn{T_b}.

Edges are labeled as 3 for edge \eqn{AB}, 1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.
If the point, \code{p}, is not inside \code{tri}, then the function yields \code{NA} as output.
Edge region 1 is the triangle \eqn{T(B,C,M)}, edge region 2 is \eqn{T(A,C,M)}, and edge region 3 is \eqn{T(A,B,M)}.
In the standard basic triangle form \eqn{T_b} \eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Any given triangle can be mapped to the standard basic triangle form by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling, preserving uniformity of the points in the
original triangle. Hence standard basic triangle form is useful for simulation
studies under the uniformity hypothesis.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
\dontrun{
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C);
M<-c(.6,.2)

P<-c(.4,.2)
re.bas.tri.cent(P,c1,c2,M)

A<-c(0,0);B<-c(1,0);C<-c(c1,c2);
Tb<-rbind(A,B,C)

n<-20  #try also n<-40
Xp<-runif.bas.tri(n,c1,c2)$g

M<-as.numeric(runif.bas.tri(1,c1,c2)$g)  #try also M<-c(.6,.2)

re<-vector()
for (i in 1:n)
  re<-c(re,re.bas.tri.cent(Xp[i,],c1,c2,M)$re)
re

Xlim<-range(Tb[,1],Xp[,1])
Ylim<-range(Tb[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tb,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(Xp,pch=".")
polygon(Tb)
L<-Tb; R<-rbind(M,M,M)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
text(Xp,labels=factor(re))

txt<-rbind(Tb,M)
xc<-txt[,1]+c(-.03,.03,.02,0)
yc<-txt[,2]+c(.02,.02,.02,-.03)
txt.str<-c("A","B","C","M")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{re.triCM}}, \code{\link{re.tri.cent}},
\code{\link{re.bas.tri.cent}}, \code{\link{reTeCM}}, and \code{\link{edge.reg.triCM}}
}
\author{
Elvan Ceyhan
}
