% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxExtrema.R
\name{cl2faces.vert.reg.tetra}
\alias{cl2faces.vert.reg.tetra}
\title{The closest points among a data set in the vertex regions
to the respective faces in a tetrahedron}
\usage{
cl2faces.vert.reg.tetra(Xp, th, M = "CM")
}
\arguments{
\item{Xp}{A set of 3D points
representing the set of data points.}

\item{th}{A \eqn{4 \times 3} matrix with each row
representing a vertex of the tetrahedron.}

\item{M}{The center to be used in the construction of the vertex regions
in the tetrahedron, \code{th}.
Currently it only takes \code{"CC"} for circumcenter
and \code{"CM"} for center of mass; default=\code{"CM"}.}
}
\value{
A \code{list} with the elements
\item{txt1}{Vertex labels are \eqn{A=1}, \eqn{B=2}, \eqn{C=3},
and \eqn{D=4} (correspond to row number in Extremum Points).}
\item{txt2}{A short description of the distances
as \code{"Distances from Closest Points to Faces ..."}.}
\item{type}{Type of the extrema points}
\item{desc}{A short description of the extrema points}
\item{mtitle}{The \code{"main"} title for the plot of the extrema}
\item{ext}{The extrema points, here,
closest points to faces in the respective vertex region.}
\item{ind.ext}{The data indices of extrema points, \code{ext}.}
\item{X}{The input data, \code{Xp},
can be a \code{matrix} or \code{data frame}}
\item{num.points}{The number of data points, i.e., size of \code{Xp}}
\item{supp}{Support of the data points,
here, it is \code{th}}
\item{cent}{The center point used for construction of vertex regions,
it is circumcenter of center of mass for this function}
\item{ncent}{Name of the center, it is circumcenter \code{"CC"}
or center of mass \code{"CM"} for this function.}
\item{regions}{Vertex regions
inside the tetrahedron \code{th} provided as a list.}
\item{region.names}{Names of the vertex regions
as \code{"vr=1","vr=2","vr=3","vr=4"}}
\item{region.centers}{Centers of mass of the vertex regions
inside \code{th}.}
\item{dist2ref}{Distances from closest points
in each vertex region to the corresponding face.}
}
\description{
An object of class \code{"Extrema"}.
Returns the closest data points among the data set, \code{Xp},
to face \eqn{i} in \code{M}-vertex region \eqn{i} for \eqn{i=1,2,3,4}
in the tetrahedron \eqn{th=T(A,B,C,D)}.
Vertex labels are \eqn{A=1}, \eqn{B=2}, \eqn{C=3}, and \eqn{D=4}
and corresponding face labels are
\eqn{BCD=1}, \eqn{ACD=2}, \eqn{ABD=3}, and \eqn{ABC=4}.

Vertex regions are based on center \code{M}
which can be the center of mass (\code{"CM"})
or circumcenter (\code{"CC"}) of \code{th}.
}
\examples{
\dontrun{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0);
D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
set.seed(1)
tetra<-rbind(A,B,C,D)+matrix(runif(12,-.25,.25),ncol=3)
n<-10  #try also n<-20
Cent<-"CC"  #try also "CM"

n<-20  #try also n<-100
Xp<-runif.tetra(n,tetra)$g  #try also Xp<-cbind(runif(n),runif(n),runif(n))

Ext<-cl2faces.vert.reg.tetra(Xp,tetra,Cent)
Ext
summary(Ext)
plot(Ext)

clf<-Ext$ext

if (Cent=="CC") {M<-circumcenter.tetra(tetra)}
if (Cent=="CM") {M<-apply(tetra,2,mean)}

Xlim<-range(tetra[,1],Xp[,1],M[1])
Ylim<-range(tetra[,2],Xp[,2],M[2])
Zlim<-range(tetra[,3],Xp[,3],M[3])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]
zd<-Zlim[2]-Zlim[1]

plot3D::scatter3D(Xp[,1],Xp[,2],Xp[,3], phi =0,theta=40, bty = "g",
main="Closest Pointsin CC-Vertex Regions \n to the Opposite Faces",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05), zlim=Zlim+zd*c(-.05,.05),
          pch = 20, cex = 1, ticktype = "detailed")
#add the vertices of the tetrahedron
plot3D::points3D(tetra[,1],tetra[,2],tetra[,3], add=TRUE)
L<-rbind(A,A,A,B,B,C); R<-rbind(B,C,D,C,D,D)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3], add=TRUE,lwd=2)
plot3D::points3D(clf[,1],clf[,2],clf[,3], pch=4,col="red", add=TRUE)

plot3D::text3D(tetra[,1],tetra[,2],tetra[,3],
labels=c("A","B","C","D"), add=TRUE)

#for center of mass use #Cent<-apply(tetra,2,mean)
D1<-(A+B)/2; D2<-(A+C)/2; D3<-(A+D)/2;
D4<-(B+C)/2; D5<-(B+D)/2; D6<-(C+D)/2;
L<-rbind(D1,D2,D3,D4,D5,D6); R<-rbind(M,M,M,M,M,M)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3], add=TRUE,lty=2)
}

}
\seealso{
\code{\link{fr2vertsCCvert.reg}}, \code{\link{fr2edgesCMedge.reg.std.tri}},
\code{\link{fr2vertsCCvert.reg.basic.tri}} and \code{\link{kfr2vertsCCvert.reg}}
}
\author{
Elvan Ceyhan
}
