% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desire_lines.R
\name{get_od}
\alias{get_od}
\title{Get origin destination data from the 2011 Census}
\usage{
get_od(
  region = NULL,
  n = NULL,
  type = "within",
  omit_intrazonal = FALSE,
  base_url = paste0("https://s3-eu-west-1.amazonaws.com/",
    "statistics.digitalresources.jisc.ac.uk", "/dkan/files/FLOW/"),
  filename = "wu03ew_v2"
)
}
\arguments{
\item{region}{The PCT region or local authority to download data from (e.g. \code{west-yorkshire} or \code{Leeds}).
See \code{View(pct_regions_lookup)} for a full list of possible region names.}

\item{n}{top n number of destinations with most trips in the 2011 census
within the \code{region}.}

\item{type}{the type of subsetting: one of \code{from}, \code{to} or \code{within}, specifying how
the od dataset should be subset in relation to the \code{region}.}

\item{omit_intrazonal}{should intrazonal OD pairs be omited from result?
\code{FALSE} by default.}

\item{base_url}{the base url where the OD dataset is stored}

\item{filename}{the name of the file to download, if not the default MSOA level
data.}
}
\description{
This function downloads a .csv file representing movement
between MSOA zones in England and Wales.
By default it returns national data, but
\code{region} can be set to subset the output to a specific
local authority or region.
}
\details{
OD datasets available include \href{https://www.statistics.digitalresources.jisc.ac.uk/}{wu03uk_v3}
and others listed on the Wicid website.
}
\examples{
\donttest{
get_od("wight", n = 3)
get_od()
get_od(filename = "wu03uk_v3")
}
}
