% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgram.R
\name{pdPgram}
\alias{pdPgram}
\title{Multitaper HPD periodogram matrix}
\usage{
pdPgram(X, B, method = c("multitaper", "bartlett"), bias.corr = F, nw = 3)
}
\arguments{
\item{X}{an (\eqn{n,d})-dimensional matrix corresponding to a multivariate time series,
with the \code{d} columns corresponding to the components of the time series.}

\item{B}{depending on the argument \code{method}, either the number of orthogonal DPSS tapers, or the number of
non-overlapping segments to compute Bartlett's averaged periodogram. By default,
\code{B = d}, such that the averaged periodogram is guaranteed to be positive definite.}

\item{method}{the tapering method, either \code{"multitaper"} or \code{"bartlett"} explained in the Details
section below. Defaults to \code{"multitaper"}.}

\item{bias.corr}{should an asymptotic bias-correction under the affine-invariant Riemannian metric be applied to
the HPD periodogram matrix? Defaults to \code{FALSE}.}

\item{nw}{a positive numeric value corresponding to the time-bandwidth parameter of the DPSS tapering functions,
see also \code{\link[multitaper]{dpss}}, defaults to \code{nw = 3}.}
}
\value{
A list containing two components:
   \item{\code{freq} }{ vector of \eqn{n/2} frequencies in the range \eqn{[0,0.5)} at which the periodogram is evaluated.}
   \item{\code{P} }{ a \eqn{(d, d, n/2)}-dimensional array containing the
     (\eqn{d,d})-dimensional multitaper periodogram matrices at frequencies corresponding
     to \code{freq}.}
}
\description{
Given a multivariate time series, \code{pdPgram} computes a multitapered HPD periodogram matrix based on
averaging raw Hermitian PSD periodogram matrices of tapered multivariate time series segments.
}
\details{
If \code{method = "multitaper"}, \code{pdPgram} calculates a \eqn{(d,d)}-dimensional multitaper
periodogram matrix based on \eqn{B} DPSS (Discrete Prolate Spheroidal Sequence or Slepian) orthogonal tapering functions
as in \code{\link[multitaper]{dpss}} applied to the \eqn{d}-dimensional time series \code{X}. If \code{method = "bartlett"},
\code{pdPgram} computes a Bartlett spectral estimator by averaging the periodogram matrices of \code{B} non-overlapping
segments of the \eqn{d}-dimensional time series \code{X}. Note that Bartlett's spectral estimator is a
specific (trivial) case of a multitaper spectral estimator with uniform orthogonal tapering windows.\cr
In the case of subsequent periodogram matrix denoising in the space of HPD matrices equipped with the
affine-invariant Riemannian metric, one should set \code{bias.corr = T}, thereby correcting for the asymptotic
bias of the periodogram matrix in the manifold of HPD matrices equipped with the affine-invariant metric as explained in
\insertCite{CvS17}{pdSpecEst} and Chapter 3 of \insertCite{C18}{pdSpecEst}. The pre-smoothed HPD periodogram matrix
(i.e., an initial noisy HPD spectral estimator) can be given as input to the function \code{\link{pdSpecEst1D}} to perform
intrinsic wavelet-based spectral matrix estimation. In this case, set \code{bias.corr = F} (the default) as the appropriate
bias-corrections are applied internally by the function \code{\link{pdSpecEst1D}}.
}
\examples{
## ARMA(1,1) process: Example 11.4.1 in (Brockwell and Davis, 1991)
Phi <- array(c(0.7, 0, 0, 0.6, rep(0, 4)), dim = c(2, 2, 2))
Theta <- array(c(0.5, -0.7, 0.6, 0.8, rep(0, 4)), dim = c(2, 2, 2))
Sigma <- matrix(c(1, 0.71, 0.71, 2), nrow = 2)
ts.sim <- rARMA(200, 2, Phi, Theta, Sigma)
ts.plot(ts.sim$X) # plot generated time series traces
pgram <- pdPgram(ts.sim$X)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{pdPgram2D}}, \code{\link[multitaper]{dpss}}
}
