% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cow_mids.R
\name{add_cow_mids}
\alias{add_cow_mids}
\title{Add Correlates of War (CoW) Militarized Interstate Dispute (MID) data to dyad-year data frame}
\usage{
add_cow_mids(data, keep)
}
\arguments{
\item{data}{a dyad-year data frame (either "directed" or "non-directed")}

\item{keep}{an optional parameter, specified as a character vector, passed to the function in a \code{select(one_of(.))} wrapper. This
allows the user to discard unwanted columns from the directed dispute data so that the output does not consume
too much space in memory. Note: the Correlates of War system codes (\code{ccode1}, \code{ccode2}), the observation year
(\code{year}), the presence or absence of an ongoing MID (\code{cowmidongoing}), and the presence or absence of a unique
MID onset (\code{cowmidonset}) are \emph{always} returned. It would be foolish and self-defeating to eliminate those observations.
The user is free to keep or discard anything else they see fit.

If \code{keep} is not specified in the function, the ensuing output returns everything.}
}
\value{
\code{add_cow_mids()} takes a dyad-year data frame and adds dyad-year dispute information
from the CoW-MID data.
}
\description{
\code{add_cow_mids()} merges in CoW's MID data to a dyad-year data frame.
The version of the CoW-MID data in this package is version 5.0.
}
\details{
Dyads are capable of having multiple disputes in a given year, which can
create a problem for merging into a complete dyad-year data frame.
Consider the case of France and Italy in 1860, which
had three separate dispute onsets that year (MID#0112, MID#0113,
MID#0306), as illustrative of the problem. This merging process employs
several rules to whittle down these duplicate dyad-years for merging
into a dyad-year data frame.

The function will also return a message to the user about the
case-exclusion rules that went into this process. Users who are
interested in implementing their own case-exclusion rules should
look up the "whittle" class of functions also provided in this
package.
}
\examples{

\donttest{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)
cow_ddy \%>\% add_cow_mids()

# keep just the dispute number and Side A/B identifiers
cow_ddy \%>\% add_cow_mids(keep=c("dispnum","sidea1", "sidea2"))
}

}
\references{
Palmer, Glenn, and Roseanne W. McManus and Vito D'Orazio and Michael R. Kenwick and Mikaela Karstens
and Chase Bloch and Nick Dietrich and Kayla Kahn and Kellan Ritter and Michael J. Soules. 2021.
"The MID5 Dataset, 2011–2014: Procedures, coding rules, and description" \emph{Conflict Management and Peace Science}.
}
\author{
Steven V. Miller
}
