% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_distribution.R
\name{bp_distribution}
\alias{bp_distribution}
\alias{p_bp}
\alias{q_bp}
\title{Estimate Pediatric Blood Pressure Distribution}
\usage{
p_bp(q_sbp, q_dbp, age, male, height = NA, height_percentile = 0.5, ...)

q_bp(p_sbp, p_dbp, age, male, height = NA, height_percentile = 0.5, ...)
}
\arguments{
\item{q_sbp}{a vector of systolic blood pressures}

\item{q_dbp}{a vector of diastolic blood pressures}

\item{age}{numeric age, in months}

\item{male}{integer value, 1 = male, 0 = female}

\item{height}{numeric, in centimeters, can be missing.}

\item{height_percentile}{default height percentile to use if \code{height} is
missing.}

\item{...}{not currently used}

\item{p_sbp}{a vector of systolic blood percentiles}

\item{p_dbp}{a vector of diastolic blood percentiles}
}
\value{
a \code{pedbp_bp} object.  This is a list of two numeric vectors:
\code{sbp_percentile} (systolic blood pressure) and \code{dbp_percentile}
(diastolic blood pressure).  Additionally, the \code{bp_params} attribute
provides details on the data source and parameters used in the percentile
estimates.
}
\description{
Percentile and quantile functions for pediatric blood pressure.
}
\examples{

x <- p_bp( q_sbp = 100, q_dbp = 60, age = 8, male = 0)
x
str(x)

x <- p_bp(q_sbp = c(NA, 82), q_dbp = c(60, 72), age = 9.2, male = 0)
x
str(x)

x <- p_bp(q_sbp = c(NA, 82), q_dbp = c(60, 72), age = 29.2, male = 0, height = 82.8)
x
str(x)

x <- q_bp(p_sbp = 0.78, p_dbp = 0.65, age = 8, male = 0)
x
str(x)

#############################################################################
# Working with multiple patients records
d <- read.csv(system.file("example_data", "for_batch.csv", package = "pedbp"))
d

bp_percentiles <-
  p_bp(
      q_sbp = d$sbp..mmHg.
    , q_dbp = d$dbp..mmHg.
    , age   = d$age_months
    , male  = d$male
    )
bp_percentiles

q_bp(
    p_sbp = bp_percentiles$sbp_percentile
  , p_dbp = bp_percentiles$dbp_percentile
  , age   = d$age_months
  , male  = d$male
  )


}
\seealso{
\code{vignette("bp-distriution", package = "pedbp")}
}
