## ----label = "setup", include = FALSE-----------------------------------------
################################################################################
#                        !!! DO NOT EDIT .Rmd files !!!                        #
#                                                                              #
# .Rmd files are generated by their corresponding .R files found in the        #
# vignette-spinners/ directory.  Any changes needed to the .Rmd file need to   #
# be made in the .R file                                                       #
################################################################################
knitr::opts_chunk$set(collapse = TRUE, fig.align = "center")
library(qwraps2)

## ----label = "helper functions", include = FALSE------------------------------
percentile_factor <- function(p) {
  factor(p, levels = sort(unique(p)), labels = paste0(sort(unique(p)) * 100, "th"))
}

## -----------------------------------------------------------------------------
library(pedbp)

## ----echo = FALSE, results = "asis"-------------------------------------------
knitr::include_graphics("../man/figures/flowchart.png")

## -----------------------------------------------------------------------------
p_bp(q_sbp = 100, q_dbp = 60, age = 44, male = 1)

## -----------------------------------------------------------------------------
p_bp(q_sbp = 100, q_dbp = 60, age = 44, male = 1, source = "lo2013")

## -----------------------------------------------------------------------------
p_bp(q_sbp = 100, q_dbp = 60, age = 44, male = 1, height = 103)
p_bp(q_sbp = 100, q_dbp = 60, age = 44, male = 1, height = 103, source = "nhlbi")

## -----------------------------------------------------------------------------
p_height_for_age(103, male = 1, age = 44)
x <- p_bp(q_sbp = 100, q_dbp = 60, age = 44, male = 1, height_percentile = 0.80, source = "nhlbi")
x

## ----fig.width = 5, fig.height = 5--------------------------------------------
bp_cdf(sbp = 100, dbp = 60, age = 44, male = 1, height_percentile = 0.80, source = "nhlbi")

## -----------------------------------------------------------------------------
bps <-
  p_bp(
         q_sbp  = c(100, NA, 90)
       , q_dbp  = c(60, 82, 48)
       , age    = 44
       , male   = 1
      )
bps

## -----------------------------------------------------------------------------
attr(bps, "bp_params")
str(bps)

## -----------------------------------------------------------------------------
q_bp(
       p_sbp = c(0.701, NA, 0.36)
     , p_dbp = c(0.85, 0.99, 0.50)
     , age = 44
     , male = 1
    )

## ----label = "bp_batch_example"-----------------------------------------------
eg_data <- read.csv(system.file("example_data", "for_batch.csv", package = "pedbp"))
eg_data

bp_percentiles <-
  p_bp(
         q_sbp  = eg_data$sbp..mmHg.
       , q_dbp  = eg_data$dbp..mmHg.
       , age    = eg_data$age
       , male   = eg_data$male
       , height = eg_data$height
       )
bp_percentiles

str(bp_percentiles)

## -----------------------------------------------------------------------------
q_bp(
       p_sbp  = bp_percentiles$sbp_p
     , p_dbp  = bp_percentiles$dbp_p
     , age    = eg_data$age
     , male   = eg_data$male
     , height = eg_data$height
     )

## -----------------------------------------------------------------------------
bp_chart()

## -----------------------------------------------------------------------------
bp_chart(male = 1, height_percentile = 75, source = "flynn2017")

