% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals-methods.R
\name{residuals.pense_fit}
\alias{residuals.pense_fit}
\title{Extract Residuals}
\usage{
\method{residuals}{pense_fit}(object, alpha = NULL, lambda, ...)
}
\arguments{
\item{object}{PENSE regularization path to extract residuals from.}

\item{alpha}{Either a single number or \code{NULL} (default).
If given, only fits with the given \code{alpha} value are considered.
If \code{object} was fit with multiple \code{alpha} values, and no value is provided, the
first value in \code{object$alpha} is used with a warning.}

\item{lambda}{a single number for the penalty level.}

\item{...}{currently not used.}
}
\value{
a numeric vector of residuals for the given penalization level.
}
\description{
Extract residuals from a PENSE (or LS-EN) regularization path fitted by
\code{\link[=pense]{pense()}}, \code{\link[=regmest]{regmest()}} or \code{\link[=elnet]{elnet()}}.
}
\examples{
# Compute the LS-EN regularization path for Freeny's revenue data
# (see ?freeny)
data(freeny)
x <- as.matrix(freeny[ , 2:5])

regpath <- elnet(x, freeny$y, alpha = 0.75)

# Predict the response using a specific penalization level
predict(regpath, newdata = freeny[1:5, 2:5],
        lambda = regpath$lambda[[1]][[10]])

# Extract the residuals at a certain penalization level
residuals(regpath, lambda = regpath$lambda[[1]][[5]])

# Select penalization level via cross-validation
set.seed(123)
cv_results <- elnet_cv(x, freeny$y, alpha = 0.5,
                       cv_repl = 10, cv_k = 4)

# Predict the response using the "best" penalization level
predict(cv_results, newdata = freeny[1:5, 2:5])

# Extract the residuals at the "best" penalization level
residuals(cv_results)
# Extract the residuals at a more parsimonious penalization level
residuals(cv_results, lambda = "1.5-se")
}
\seealso{
Other functions for extracting components: 
\code{\link{coef.pense_cvfit}()},
\code{\link{coef.pense_fit}()},
\code{\link{predict.pense_cvfit}()},
\code{\link{predict.pense_fit}()},
\code{\link{residuals.pense_cvfit}()}
}
\concept{functions for extracting components}
