% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/looic.R
\name{looic}
\alias{looic}
\title{LOO-related Indices for Bayesian regressions.}
\usage{
looic(model, verbose = TRUE)
}
\arguments{
\item{model}{A Bayesian regression model.}

\item{verbose}{Toggle off warnings.}
}
\value{
A list with four elements, the ELPD, LOOIC and their standard errors.
}
\description{
Compute LOOIC (leave-one-out cross-validation (LOO) information
criterion) and ELPD (expected log predictive density) for Bayesian
regressions. For LOOIC and ELPD, smaller and larger values are respectively
indicative of a better fit.
}
\examples{
\dontshow{if (require("rstanarm")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
model <- suppressWarnings(rstanarm::stan_glm(
  mpg ~ wt + cyl,
  data = mtcars,
  chains = 1,
  iter = 500,
  refresh = 0
))
looic(model)
}
\dontshow{\}) # examplesIf}
}
