% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadFile.R
\name{downloadFile}
\alias{downloadFile}
\title{downloadFile module server function}
\usage{
downloadFile(
  id,
  logger = NULL,
  filenameroot = "download",
  datafxns = NULL,
  aspectratio = 1
)
}
\arguments{
\item{id}{ID of the Module's UI element}

\item{logger}{logger to use}

\item{filenameroot}{the base text used for user-downloaded file - can be
either a character string or a reactive expression that returns a character
string}

\item{datafxns}{a \strong{named} list of functions providing the data as
return values.  The names for the list should be the same names that were used
when the button UI was created.}

\item{aspectratio}{the downloaded chart image width:height ratio (ex:
1 = square, 1.3 = 4:3, 0.5 = 1:2). Where not applicable for a download type
it is ignored (e.g. data downloads).}
}
\value{
no return value, called for downloading selected file type
}
\description{
Server-side function for the downloadFileButton.  This is a custom
high-functionality button for file downloads supporting single or multiple
download types.  The server function is used to provide the data for download.
}
\section{Shiny Usage}{

This function is not called directly by consumers - it is accessed in
server.R using the same id provided in \code{downloadFileButton}:

\strong{\code{downloadFile(id, logger, filenameroot, datafxns)}}
}

\examples{
if (interactive()) {
   library(shiny)
   library(periscope2)
   shinyApp(ui = fluidPage(fluidRow(column(width = 6,
     # single download type
     downloadFileButton("object_id1",
                        downloadtypes = c("csv"),
                        hovertext     = "Button 1 Tooltip")),
      column(width = 6,
      # multiple download types
      downloadFileButton("object_id2",
                         downloadtypes = c("csv", "tsv"),
                         hovertext     = "Button 2 Tooltip")))),
     server = function(input, output) {
       # single download type
       downloadFile(id           = "object_id1",
                    logger       = "",
                    filenameroot = "mydownload1",
                    datafxns     = list(csv = reactiveVal(iris)),
                    aspectratio  = 1)
       # multiple download types
       downloadFile(id           = "object_id2",
                    logger       = "",
                    filenameroot = "mydownload2",
                    datafxns     = list(csv = reactiveVal(mtcars),
                    tsv = reactiveVal(mtcars)))
   })
}

}
\seealso{
\link[periscope2]{downloadFileButton}

\link[periscope2]{downloadFile_ValidateTypes}

\link[periscope2]{downloadFile_AvailableTypes}

\link[periscope2]{logViewerOutput}

\link[periscope2]{downloadablePlot}

\link[periscope2]{downloadableTableUI}

\link[periscope2]{downloadableTable}
}
