% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ladlasso.R
\name{ladlasso}
\alias{ladlasso}
\alias{ladlasso.fit}
\title{LAD-lasso with penalty parameter selection}
\usage{
ladlasso(
  x,
  y,
  lambda,
  standardize = TRUE,
  intercept = TRUE,
  splits = foldControl(),
  cost = mape,
  selectBest = c("hastie", "min"),
  seFactor = 1,
  ncores = 1,
  cl = NULL,
  seed = NULL,
  ...
)

ladlasso.fit(x, y, lambda, standardize = TRUE, intercept = TRUE, ...)
}
\arguments{
\item{x}{a numeric matrix containing the predictor variables.}

\item{y}{a numeric vector containing the response variable.}

\item{lambda}{for \code{ladlasso}, a numeric vector of non-negative values
to be used as penalty parameter.  For \code{ladlasso.fit}, a single
non-negative value to be used as penalty parameter.}

\item{standardize}{a logical indicating whether the predictor variables
should be standardized to have unit MAD (the default is \code{TRUE}).}

\item{intercept}{a logical indicating whether a constant term should be
included in the model (the default is \code{TRUE}).}

\item{splits}{an object giving data splits to be used for prediction error
estimation (see \code{\link[perry]{perryTuning}}).}

\item{cost}{a cost function measuring prediction loss (see
\code{\link[perry]{perryTuning}} for some requirements).  The
default is to use the mean absolute prediction error (see
\code{\link[perry]{cost}}).}

\item{selectBest, seFactor}{arguments specifying a criterion for selecting
the best model (see \code{\link[perry]{perryTuning}}).  The default is to
use a one-standard-error rule.}

\item{ncores, cl}{arguments for parallel computing (see
\code{\link[perry]{perryTuning}}).}

\item{seed}{optional initial seed for the random number generator (see
\code{\link{.Random.seed}} and \code{\link[perry]{perryTuning}}).}

\item{\dots}{for \code{ladlasso}, additional arguments to be passed to the
prediction loss function \code{cost}.  For \code{ladlasso.fit}, additional
arguments to be passed to \code{\link[quantreg]{rq.fit.lasso}}.}
}
\value{
For \code{ladlasso}, an object of class \code{"perryTuning"}, see
\code{\link[perry]{perryTuning}}).  It contains information on the
prediction error criterion, and includes the final model with the optimal
tuning paramter as component \code{finalModel}.

For \code{ladlasso.fit}, an object of class \code{ladlasso} with the
following components:
\describe{
  \item{\code{lambda}}{numeric; the value of the penalty parameter.}
  \item{\code{coefficients}}{a numeric vector containing the coefficient
  estimates.}
  \item{\code{fitted.values}}{a numeric vector containing the fitted values.}
  \item{\code{residuals}}{a numeric vector containing the residuals.}
  \item{\code{standardize}}{a logical indicating whether the predictor
  variables were standardized to have unit MAD.}
  \item{\code{intercept}}{a logical indicating whether the model includes a
  constant term.}
  \item{\code{muX}}{a numeric vector containing the medians of the
  predictors.}
  \item{\code{sigmaX}}{a numeric vector containing the MADs of the
  predictors.}
  \item{\code{muY}}{numeric; the median of the response.}
  \item{\code{call}}{the matched function call.}
}
}
\description{
Fit LAD-lasso models and select the penalty parameter by estimating the
respective prediction error via (repeated) \eqn{K}-fold cross-validation,
(repeated) random splitting (also known as random subsampling or Monte Carlo
cross-validation), or the bootstrap.
}
\examples{
## load data
data("Bundesliga")
Bundesliga <- Bundesliga[, -(1:2)]
f <- log(MarketValue) ~ Age + I(Age^2) + .
mf <- model.frame(f, data=Bundesliga)
x <- model.matrix(terms(mf), mf)[, -1]
y <- model.response(mf)

## set up repeated random splits
splits <- splitControl(m = 40, R = 10)

## select optimal penalty parameter
lambda <- seq(40, 0, length.out = 20)
fit <- ladlasso(x, y, lambda = lambda, splits = splits, seed = 2014)
fit

## plot prediction error results
plot(fit, method = "line")
}
\references{
Wang, H., Li, G. and Jiang, G. (2007) Robust regression shrinkage and
consistent variable selection through the LAD-lasso.  \emph{Journal of
Business & Economic Statistics}, \bold{25}(3), 347--355.
}
\seealso{
\code{\link[perry]{perryTuning}}, \code{\link[quantreg]{rq.fit.lasso}}
}
\author{
Andreas Alfons
}
\keyword{regression}
\keyword{robust}
