% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridge.R
\name{ridge}
\alias{ridge}
\alias{ridge.fit}
\title{Ridge regression with penalty parameter selection}
\usage{
ridge(
  x,
  y,
  lambda,
  standardize = TRUE,
  intercept = TRUE,
  splits = foldControl(),
  cost = rmspe,
  selectBest = c("hastie", "min"),
  seFactor = 1,
  ncores = 1,
  cl = NULL,
  seed = NULL,
  ...
)

ridge.fit(x, y, lambda, standardize = TRUE, intercept = TRUE, ...)
}
\arguments{
\item{x}{a numeric matrix containing the predictor variables.}

\item{y}{a numeric vector containing the response variable.}

\item{lambda}{a numeric vector of non-negative values to be used as penalty
parameter.}

\item{standardize}{a logical indicating whether the predictor variables
should be standardized to have unit variance (the default is \code{TRUE}).}

\item{intercept}{a logical indicating whether a constant term should be
included in the model (the default is \code{TRUE}).}

\item{splits}{an object giving data splits to be used for prediction error
estimation (see \code{\link[perry]{perryTuning}}).}

\item{cost}{a cost function measuring prediction loss (see
\code{\link[perry]{perryTuning}} for some requirements).  The
default is to use the root mean squared prediction error (see
\code{\link[perry]{cost}}).}

\item{selectBest, seFactor}{arguments specifying a criterion for selecting
the best model (see \code{\link[perry]{perryTuning}}).  The default is to
use a one-standard-error rule.}

\item{ncores, cl}{arguments for parallel computing (see
\code{\link[perry]{perryTuning}}).}

\item{seed}{optional initial seed for the random number generator (see
\code{\link{.Random.seed}} and \code{\link[perry]{perryTuning}}).}

\item{\dots}{for \code{ridge}, additional arguments to be passed to the
prediction loss function \code{cost}.  For \code{ridge.fit}, additional
arguments are currently ignored.}
}
\value{
For \code{ridge}, an object of class \code{"perryTuning"}, see
\code{\link[perry]{perryTuning}}).  It contains information on the
prediction error criterion, and includes the final model with the optimal
tuning paramter as component \code{finalModel}.

For \code{ridge.fit}, an object of class \code{ridge} with the following
components:
\describe{
  \item{\code{lambda}}{a numeric vector containing the values of the penalty
  parameter.}
  \item{\code{coefficients}}{a numeric vector or matrix containing the
  coefficient estimates.}
  \item{\code{fitted.values}}{a numeric vector or matrix containing the
  fitted values.}
  \item{\code{residuals}}{a numeric vector or matrix containing the
  residuals.}
  \item{\code{standardize}}{a logical indicating whether the predictor
  variables were standardized to have unit variance.}
  \item{\code{intercept}}{a logical indicating whether the model includes a
  constant term.}
  \item{\code{muX}}{a numeric vector containing the means of the predictors.}
  \item{\code{sigmaX}}{a numeric vector containing the standard deviations
  of the predictors.}
  \item{\code{muY}}{numeric; the mean of the response.}
  \item{\code{call}}{the matched function call.}
}
}
\description{
Fit ridge regression models and select the penalty parameter by estimating
the respective prediction error via (repeated) \eqn{K}-fold
cross-validation, (repeated) random splitting (also known as random
subsampling or Monte Carlo cross-validation), or the bootstrap.
}
\examples{
## load data
data("Bundesliga")
Bundesliga <- Bundesliga[, -(1:2)]
f <- log(MarketValue) ~ Age + I(Age^2) + .
mf <- model.frame(f, data=Bundesliga)
x <- model.matrix(terms(mf), mf)[, -1]
y <- model.response(mf)

## set up repeated random splits
splits <- splitControl(m = 40, R = 10)

## select optimal penalty parameter
lambda <- seq(600, 0, length.out = 50)
fit <- ridge(x, y, lambda = lambda, splits = splits, seed = 2014)
fit

## plot prediction error results
plot(fit, method = "line")
}
\references{
Hoerl, A.E. and Kennard, R.W. (1970) Ridge regression: biased estimation for
nonorthogonal problems.  \emph{Technometrics}, \bold{12}(1), 55--67.
}
\seealso{
\code{\link[perry]{perryTuning}}
}
\author{
Andreas Alfons
}
\keyword{regression}
