% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eppo_database_tools.R
\name{eppo_database}
\alias{eppo_database}
\alias{eppo_database_check}
\alias{eppo_database_download}
\alias{eppo_database_connect}
\title{EPPO Data Services Database connection tools}
\usage{
eppo_database_check(filepath = getwd(), filename = "eppocodes.sqlite")

eppo_database_download(filepath = getwd())

eppo_database_connect(filepath = getwd(), filename = "eppocodes.sqlite")
}
\arguments{
\item{filepath}{A string with path where eppocodes.sqlite file is stored. By
default it points to working directory.}

\item{filename}{A string with name of the file. By default it takes name
eppocodes.sqlite.}
}
\value{
Checks if database file exist in directory, if it is outdated, and
establishes SQLite database connection
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}
\code{eppo_database_check} checks if there is a file \emph{eppocodes.sqlite}
and informs user if it is outdated and should be downloaded.
\code{eppo_database_download} downloads database in \emph{SQLite} format directly.
The downloaded file is \emph{zip} archive. On Linux this database will be
extracted automatically. On Windows user will need to extract the file
manually.
\code{eppo_database_connect} allows user to connect to SQLite database
downloaded from EPPO Data Services.
}
\section{Manual download}{
If you will, you can download database directly from
\strong{EPPO Data Services} \url{https://data.eppo.int}
}

\examples{
\dontrun{
#to check if the db file exist in the directory (default working directory)

eppo_database_check(filepath = getwd())

#to download EPPO SQLite database into directory (default working directory).
#If you are Windows user, after download finishes you will need to unzip file
#manualy.

eppo_database_download(filepath = getwd())

#prior to use functions that check pest names in SQLite database,
#you need to set up connection to SQLite database. Doing so is
#straightforward with function below (once per sesion):

eppo_connection <- eppo_database_connect(filepath = getwd(),
                                         filename = "eppocodes.sqlite")
}
}
