# `petersenlab`

<!-- badges: start -->
  [![R-CMD-check](https://github.com/DevPsyLab/petersenlab/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/DevPsyLab/petersenlab/actions/workflows/R-CMD-check.yaml)
  <!-- badges: end -->

# Package Overview

The `petersenlab` package contains a collection `R` functions that are widely used by the Petersen Lab (the [Developmental Psychopathology Lab](https://developmental-psychopathology.lab.uiowa.edu) at the University of Iowa).
Included are functions for various purposes, including evaluating the accuracy of judgments and predictions, performing scoring of assessments, generating correlation matrices, conversion of data between various types, data management, psychometric evaluation, extensions related to latent variable modeling, various plotting capabilities, and other miscellaneous useful functions.
By making the package available, we hope to make our methods reproducible and replicable by others and to help others perform their data processing and analysis methods more easily and efficiently.
The package website is here: https://devpsylab.github.io/petersenlab.
The source code for the package is here: https://github.com/DevPsyLab/petersenlab.

# Installing the Package

To install the package, run the following in `R`:

```
install.packages("remotes")
remotes::install_github("DevPsyLab/petersenlab")
```

# Package Functions

A list of the functions included in the package is here: https://devpsylab.github.io/petersenlab/reference

# Citing the Package

To obtain the citation for the `petersenlab` package, run `citation("petersenlab")`; the citation is:

Petersen, I. T. (2024). *petersenlab: A collection of R Functions by the Petersen Lab*. R package version 1.0.0. https://github.com/DevPsyLab/petersenlab, https://doi.org/10.5281/zenodo.7602890

A `BibTeX` entry for `LaTeX` users is:
```
@software{petersenlab,
  author = {Isaac T. Petersen},
  title = {{petersenlab}: A collection of {R} Functions by the {Petersen Lab}},
  url = {https://github.com/DevPsyLab/petersenlab},
  doi = {10.5281/zenodo.7602890},
  version = {1.0.0},
  year = {2024}
}
```

# License

[![License: MIT][mit-shield]][mit]

This work is licensed under [The MIT License][mit].

[![MIT License][mit-image]][mit]

[mit]: https://opensource.org/licenses/MIT
[mit-image]: https://upload.wikimedia.org/wikipedia/commons/0/0b/License_icon-mit-2.svg
[mit-shield]: https://img.shields.io/badge/License-MIT-blue.svg
