% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dissimilarity}
\alias{dissimilarity}
\title{Calculate (phylogenetic) dissimilarity: compare assemblages to
one-another}
\usage{
dissimilarity(data, metric = c("all", "unifrac", "pcd", "phylosor",
  "comdist"), abundance = TRUE, permute = 100, sqrt.phy = FALSE,
  traitgram = NULL, traitgram.p = 2, ext.dist = NULL, ...)
}
\arguments{
\item{data}{\code{comparative.comm} object}

\item{metric}{default (\code{all}) calculates everything;
individually call-able metrics are: \code{unifrac}, \code{pcd},
\code{phylosor}, \code{comdist}.}

\item{abundance}{If TRUE (default) metrics are calculated
incorporating species abundances (currently only comdist)}

\item{permute}{Number of permutations for metric (currently only
for \code{pcd})}

\item{sqrt.phy}{If TRUE (default is FALSE) your phylogenetic
distance matrix will be square-rooted; specifying TRUE will force
the square-root transformation on phylogenetic distance matrices
(in the spirit of Leitten and Cornwell, 2014). See `details' for
details about different metric calculations when a distance matrix
is used.}

\item{traitgram}{If not NULL (default), a number to be passed to
\code{funct.phylo.dist} (\code{phyloWeight}; the `a' parameter),
causing analysis on a distance matrix reflecting both traits and
phylogeny (0 --> only phylogeny, 1 --> only traits; see
\code{funct.phylo.dist}). If a vector of numbers is given,
\code{shape} iterates across them and returns a \code{data.frame}
with coefficients from each iteration. See `details' for details
about different metric calculations when a distance matrix is used.}

\item{traitgram.p}{A value for `p' to be used in conjunction with
\code{traitgram} when calling \code{funct.phylo.dist}.}

\item{ext.dist}{Supply an external species-level distance matrix
for use in calculations. See `details' for comments on the use of
distance matrices in different metric calculations.}

\item{...}{additional parameters to be passed to `metric
function(s) you are calling}
}
\value{
list object of metric values. A \code{coef} method does not
exist for this function, because there's no nice way to simplify
all the distance matrices. Sorry!
}
\description{
As described in Pearse et al. (2014), a dissimilarity metric
compares diversity between communities. WARNING: Phylosor is
presented as a distance matrix here, i.e. it is *not* the fraction
of shared branch length among communities, but rather '1 - shared
branch length'. This means \code{dissimilarity} always returns a
*distance* object, not a similarity object; this is a different
convention from other packages.
}
\details{
Using square-rooted distance matrices, or distance matrices that
incorporate trait information, can be an excellent thing to do, but
(for the above reasons), \code{pez} won't give you an answer for
metrics for which WDP thinks it makes no sense. All results from
this other than \code{comdist} *will always be wrong* if you do not
have an ultrametric tree and square-root (branch lengths
proportional to time) and you will be warned about this. WDP
strongly feels you should only be using ultrametric phylogenies in
any case, but code to fix this bug is welcome.
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits)
\dontrun{dissimilarity(data)}
dissimilarity(data, "unifrac")
}
\author{
M.R. Helmus, Will Pearse
}
\references{
Pearse W.D., Purvis A., Cavender-Bares J. & Helmus
M.R. (2014). Metrics and Models of Community Phylogenetics. In:
Modern Phylogenetic Comparative Methods and Their Application in
Evolutionary Biology. Springer Berlin Heidelberg, pp. 451-464.

\code{unifrac} Lozupone C.A. & Knight
R. (2005). UniFrac: a new phylogenetic method for comparing
microbial communities. Applied and Environmental Microbiology, 71,
8228-8235.

\code{pcd} Ives A.R. & Helmus M.R. (2010). Phylogenetic
metrics of community similarity. The American Naturalist, 176,
E128-E142.

\code{phylosor} Bryant J.A., Lamanna C., Morlon H.,
Kerkhoff A.J., Enquist B.J. & Green J.L. (2008). Microbes on
mountainsides: Contrasting elevational patterns of bacterial and
plant diversity. Proceedings of the National Academy of Sciences of
the United States of America, 105, 11505-11511.

\code{comdist} C.O. Webb, D.D. Ackerly, and
S.W. Kembel. 2008. Phylocom: software for the analysis of
phylogenetic community structure and trait
evolution. Bioinformatics 18:2098-2100.
}
\seealso{
\code{\link{shape}} \code{\link{evenness}} \code{\link{dispersion}}
}

