% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.comparative.comm}
\alias{plot.comparative.comm}
\title{Dot-plots of community presence/absence or abundance}
\usage{
\method{plot}{comparative.comm}(x, sites = NULL, abundance = FALSE,
  pch = 20, dot.cex = NULL, site.col = "black", fraction = 3,
  x.increment = NULL, show.tip.label = FALSE, ...)
}
\arguments{
\item{x}{\code{\link{comparative.comm}} object}

\item{sites}{names of sites to plot (default: all); see examples}

\item{abundance}{make size proportional to species abundance
(default: FALSE)}

\item{pch}{plotting character to be used for sites (see
\code{\link{pch}})}

\item{dot.cex}{function to determine point size; see examples, this
isn't as terrible-sounding as it seems.}

\item{site.col}{colours to use when plotting sites; if not same
length as number of sites, only the first element is used (no
recycling)}

\item{fraction}{fraction of plot window to be taken up with
phylogeny; e.g., 3 (default) means phylogeny is 1/3 of plot}

\item{x.increment}{specify exact spacing of points along plot; see
examples}

\item{show.tip.label}{whether to plot species names on phylogeney
(default: \code{FALSE})}

\item{...}{additional arguments passed to plotting functions}
}
\value{
List containing plot.phylo information, as well as the used
x.adj values (compare with your \code{x.increment})
}
\description{
Dot-plots of community presence/absence or abundance
}
\details{
Take a look at the examples: this is (hopefully!) a lot
more straightforward than it might seem. Getting the right spacing
of dots on the phylogeny may take some playing around with the
\code{fraction} and \code{x.increment} arguments. It may seem a
little strange to set point size using a function, however, this
gives you much more flexibility and the ability to (usefully)
transform your data.
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits)
plot(data)
plot(data, sites=c("AT", "BP"), fraction=1.5)
settings <- plot(data, sites=c("AT", "BP"), site.col=rainbow(2), fraction=1.5)
plot(data, sites=c("AT", "BP"), site.col=rainbow(2),
fraction=1.2, x.increment=settings$x.increment/4)
#dot.cex isn't as scary as it sounds...
plot(data, site.col=rainbow(2), fraction=1.2, abundance=TRUE, dot.cex=sqrt)
#...or other trivial variants...
abund.sqrt <- function(x) ifelse(x>0, sqrt(x), 0)
plot(data, sites=c("AT", "BP"), site.col=rainbow(2), fraction=1.2,
x.increment=settings$x.increment/4, abundance=TRUE, dot.cex=abund.sqrt)
plot(data, sites=c("AT", "BP"), site.col=rainbow(2), fraction=1.2,
x.increment=settings$x.increment/4, abundance=TRUE, dot.cex=function(x) sqrt(x))
}
\author{
Will Pearse, Matt Helmus
}
\seealso{
\code{\link{comparative.comm}} \code{\link{traitgram.cc}}
}

