/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.colors;

import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.resources.colors.CIEBased;

public class CIEBasedA
extends CIEBased {
    public static final PSObjectName FAMILYNAME = new PSObjectName("/CIEBasedA");
    private static final PSObjectName RANGEA = new PSObjectName("/RangeA");
    private static final PSObjectName DECODEA = new PSObjectName("/DecodeA");
    private static final PSObjectName MATRIXA = new PSObjectName("/MatrixA");

    public CIEBasedA(PSObjectArray pSObjectArray) throws PSError, ProgramError {
        if (!pSObjectArray.get(0).eq(FAMILYNAME)) {
            throw new PSErrorTypeCheck();
        }
        this.setDict(CIEBasedA.checkEntries(pSObjectArray.get(1).toDict()));
    }

    private static PSObjectDict checkEntries(PSObjectDict pSObjectDict) throws PSError, ProgramError {
        double[] dArray;
        if (!pSObjectDict.known(RANGEA)) {
            dArray = new double[]{0.0, 1.0};
            pSObjectDict.setKey((PSObject)RANGEA, (PSObject)new PSObjectArray(dArray));
        }
        if (!pSObjectDict.known(DECODEA)) {
            pSObjectDict.setKey((PSObject)DECODEA, (PSObject)new PSObjectArray("{}"));
        }
        if (!pSObjectDict.known(MATRIXA)) {
            dArray = new double[]{1.0, 1.0, 1.0};
            pSObjectDict.setKey((PSObject)MATRIXA, (PSObject)new PSObjectArray(dArray));
        }
        CIEBasedA.checkCommonEntries(pSObjectDict);
        return pSObjectDict;
    }

    public PSObjectName getFamilyName() {
        return FAMILYNAME;
    }

    public int getNrComponents() {
        return 1;
    }

    public int getNrInputValues() {
        return 1;
    }

    public void setColor(double[] dArray) throws PSError, ProgramError {
        if (dArray.length != 1) {
            throw new PSErrorRangeCheck();
        }
        PSObjectDict pSObjectDict = this.getDict();
        PSObjectArray pSObjectArray = pSObjectDict.get(RANGEA).toArray();
        double d = pSObjectArray.getReal(0);
        double d2 = pSObjectArray.getReal(1);
        this.setLevel(0, Math.max(d, Math.min(d2, dArray[0])));
        PSObjectArray pSObjectArray2 = pSObjectDict.get(DECODEA).toArray();
        PSObjectArray pSObjectArray3 = pSObjectArray2.isLiteral() ? pSObjectArray2.get(0).toProc() : pSObjectArray2.toProc();
        double d3 = CIEBasedA.decode(this.getLevel(0), pSObjectArray3);
        double[] dArray2 = new double[3];
        PSObjectArray pSObjectArray4 = pSObjectDict.get(MATRIXA).toArray();
        for (int i = 0; i < 3; ++i) {
            dArray2[i] = d3 * pSObjectArray4.getReal(i);
        }
        this.setXyzLevels(this.lmnToXyz(dArray2));
    }
}

