/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.HashMap;
import net.sf.eps2pgf.io.SkipTexCommentsReader;

public class TextReplacements {
    static final String VERT_ALLOWED = "tcBb";
    static final String HOR_ALLOWED = "lcr";
    static final String ALL_ALLOWED = "tcBblcr";
    private HashMap<String, Rule> rules = new HashMap();

    public TextReplacements(Reader reader) throws IOException, ParseException {
        SkipTexCommentsReader skipTexCommentsReader = new SkipTexCommentsReader(reader);
        this.readRules(skipTexCommentsReader);
    }

    public TextReplacements(File file) throws IOException, ParseException {
        this(new BufferedReader(new FileReader(file)));
    }

    public TextReplacements() {
    }

    public final Rule findReplacement(String string) {
        return this.rules.get(string);
    }

    private int readRules(Reader reader) throws IOException, ParseException {
        while (TextReplacements.readToString(reader, "\\psfrag")) {
            String string;
            reader.mark(1);
            if (reader.read() != 42) {
                reader.reset();
            }
            if ((string = TextReplacements.readCurlyArgument(reader)) == null) continue;
            String string2 = TextReplacements.readSquareArgument(reader, "Bl");
            String string3 = TextReplacements.readSquareArgument(reader, "Bl");
            double d = Double.parseDouble(TextReplacements.readSquareArgument(reader, "1.0"));
            double d2 = Double.parseDouble(TextReplacements.readSquareArgument(reader, "0.0"));
            String string4 = TextReplacements.readCurlyArgument(reader);
            if (string4 == null) {
                string4 = "";
            }
            Rule rule = new Rule(string, string2, string3, d, d2, string4);
            this.rules.put(string, rule);
        }
        return this.rules.size();
    }

    public static Rule readEmbeddedRule(String string) {
        if (!string.matches("^\\s*\\\\tex.*")) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        try {
            TextReplacements.consumeWhitespace(stringReader);
            if (!TextReplacements.readToString(stringReader, "\\tex")) {
                return null;
            }
            String string2 = TextReplacements.readSquareArgument(stringReader, "Bl");
            String string3 = TextReplacements.readSquareArgument(stringReader, "Bl");
            String string4 = TextReplacements.readCurlyArgument(stringReader);
            if (string4 == null) {
                string4 = "";
            }
            Rule rule = new Rule(string, string2, string3, 1.0, 0.0, string4);
            return rule;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static boolean readToString(Reader reader, String string) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) != -1) {
            stringBuilder.append((char)n);
            if (stringBuilder.length() > string.length()) {
                stringBuilder.deleteCharAt(0);
            }
            if (stringBuilder.indexOf(string) != 0) continue;
            return true;
        }
        return false;
    }

    private static String readCurlyArgument(Reader reader) throws IOException {
        int n;
        TextReplacements.consumeWhitespace(reader);
        reader.mark(1);
        if (reader.read() != 123) {
            reader.reset();
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 1;
        while ((n = reader.read()) != -1) {
            if (n == 123 && stringBuilder.charAt(stringBuilder.length() - 1) != '\\') {
                ++n2;
            } else if (n == 125 && stringBuilder.charAt(stringBuilder.length() - 1) != '\\') {
                --n2;
            }
            if (n2 == 0) break;
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private static String readSquareArgument(Reader reader, String string) throws IOException {
        int n;
        TextReplacements.consumeWhitespace(reader);
        reader.mark(1);
        if (reader.read() != 91) {
            reader.reset();
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) != -1 && n != 93) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private static void consumeWhitespace(Reader reader) throws IOException {
        int n;
        do {
            reader.mark(1);
        } while (Character.isWhitespace(n = reader.read()));
        if (n != -1) {
            reader.reset();
        }
    }

    static String assertValidRefPoint(String string) throws ParseException {
        char c;
        String string2 = string;
        for (c = '\u0000'; c < string2.length(); ++c) {
            if (ALL_ALLOWED.indexOf(string2.charAt(c)) != -1) continue;
            throw new ParseException("Invalid character(s) in reference point (" + string2 + ") in text replacement rule.", -1);
        }
        if (string2.length() == 0) {
            string2 = "cc";
        } else if (string2.length() == 1) {
            string2 = string2 + "c";
        } else if (string2.length() > 2) {
            throw new ParseException("Reference point (" + string2 + ") in the" + " text replacement rules has more than two characters.", -1);
        }
        c = string2.charAt(0);
        char c2 = string2.charAt(1);
        if (VERT_ALLOWED.indexOf(c) != -1 && HOR_ALLOWED.indexOf(c2) != -1) {
            return Character.toString(c) + c2;
        }
        if (VERT_ALLOWED.indexOf(c2) != -1 && HOR_ALLOWED.indexOf(c) != -1) {
            return Character.toString(c2) + c;
        }
        throw new ParseException("Invalid reference point (" + string2 + ") in text replacement rules.", -1);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Rule rule : this.rules.values()) {
            stringBuilder.append(rule.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static final class Rule {
        private String tag;
        private String texRefPoint;
        private String psRefPoint;
        private double scale;
        private double rotation;
        private String texText;

        private Rule(String string, String string2, String string3, double d, double d2, String string4) throws ParseException {
            this.tag = string;
            this.texRefPoint = TextReplacements.assertValidRefPoint(string2);
            this.psRefPoint = TextReplacements.assertValidRefPoint(string3);
            this.scale = d;
            this.rotation = d2;
            this.texText = string4;
        }

        public String getTexRefPoint() {
            return this.texRefPoint;
        }

        public String getPsRefPoint() {
            return this.psRefPoint;
        }

        public String getTexText() {
            return this.texText;
        }

        public double getRotation() {
            return this.rotation;
        }

        public double getScaling() {
            return this.scale;
        }

        public String toString() {
            return "\\psfrag{" + this.tag + "}[" + this.texRefPoint + "][" + this.psRefPoint + "][" + this.scale + "][" + this.rotation + "]{" + this.texText + "}";
        }
    }
}

