% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networx.R
\name{createLabel}
\alias{createLabel}
\alias{addConfidences}
\alias{presenceAbsence}
\title{Compare splits and add support values to an object}
\usage{
createLabel(x, y, label_y, type = "edge", nomatch = NA)

addConfidences(x, y, ...)

presenceAbsence(x, y)
}
\arguments{
\item{x}{an object of class \code{splits}, \code{phylo} or \code{networx}}

\item{y}{an object of class \code{splits}, \code{phylo}, \code{multiPhylo}
or \code{networx}}

\item{label_y}{label of y matched on x. Will be usually of
length(as.splits(x)).}

\item{type}{should labels returned for edges (in \code{networx}) or splits.}

\item{nomatch}{default value if no match between x and y is found.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The object \code{x} with added bootstrap / MCMC support values.
}
\description{
Add support values to a \code{splits}, \code{phylo} or \code{networx}
object.
}
\examples{

data(woodmouse)
woodmouse <- phyDat(woodmouse)
tmpfile <- normalizePath(system.file("extdata/trees/RAxML_bootstrap.woodmouse", package="phangorn"))
boot_trees <- read.tree(tmpfile)

dm <- dist.ml(woodmouse)
tree <- upgma(dm)
nnet <- neighborNet(dm)

tree <- addConfidences(tree, boot_trees)
nnet <- addConfidences(nnet, boot_trees)

plot(tree, show.node.label=TRUE)
plot(nnet, "2D", show.edge.label=TRUE)

}
\seealso{
\code{\link{as.splits}}, \code{\link{as.networx}},
\code{\link{RF.dist}}, \code{\link{plot.phylo}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
