% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_hf.R
\name{titles_and_footnotes_from_df}
\alias{titles_and_footnotes_from_df}
\title{Read titles and footnotes from a dataframe}
\usage{
titles_and_footnotes_from_df(
  doc,
  from.df = NULL,
  from.file = NULL,
  reader = NULL,
  ...
)
}
\arguments{
\item{doc}{A \code{rtf_doc} object to append header and footnote
information.}

\item{from.df}{A \code{data.frame} object with title and footnote information.}

\item{from.file}{A file path to a file with title and footnote information.}

\item{reader}{A function to read the data from the from.file argument.}

\item{...}{Parameters passed to \code{read_hf} where they are processed and
constructed into \code{hf_line} objects.}
}
\value{
A \code{rtf_doc} object with header/footnote information attached.
}
\description{
Reads a data frame with header/footnote information and attaches it to an
\code{rtf_doc} object.The most effective way to use this function is to pass
information to a custom reader for your process. See Details section for more
information.
}
\details{
Titles_and_footnotes_from_df allows you to attach titles and footnotes
(as hf_line objects) from a data.frame. This data.frame could be a
data.frame in your local environment, or read in from an external file. The
best way to utilize this method is to create a custom reader function. This
custom reader function is a function that you develop to:

\itemize{
\item{Read a source file into a data.frame}
\item{Preprocess as necessary to keep only necessary records and variables}
\item{Ensure that variables are the correct data type}
}

Titles_and_footnotes_from_df allows you to pass arguments into the reader
function, which gives you the capability to keep titles and footnotes for
all of your outputs in a central file and pass a filtering option, or any
additional parameters as necessary. For an example implementation, see our
\href{https://atorus-research.github.io/tf_from_file.html}{vignette}.
}
\section{Required Columns}{

The following columns are required fields in a data.frame passed to
titles_and_footnotes_from_df:
\itemize{
\item{type(character - 'title' or 'footnote')}
\item{text1(character)}
\item{text2(character)}
\item{align(character - left, right, center, or split)}
\item{bold(logical)}
\item{italic(logical)}
\item{font(character)}
\item{index(numeric)}
}
}

