#' Demographics
#'
#' A raw dataset used to create pharmaversesdtm::dm
#'
#' @name dm_raw
#' @title Demographics Raw Dataset
#' @keywords dataset
#' @description A raw dataset used to create pharmaversesdtm::dm
#' @docType data
#' @format A data frame with 13 columns:
#'   \describe{
#'     \item{STUDY}{Study Identifier}
#'     \item{PATNUM}{Patient Number}
#'     \item{IT.AGE}{Age}
#'     \item{IT.SEX}{Sex}
#'     \item{IT.ETHNIC}{Ethnicity}
#'     \item{IT.RACE}{Race}
#'     \item{COUNTRY}{Country}
#'     \item{PLANNED_ARM}{Planned Arm}
#'     \item{PLANNED_ARMCD}{Planned Arm Code}
#'     \item{ACTUAL_ARM}{Actual Arm}
#'     \item{ACTUAL_ARMCD}{Actual Arm Code}
#'     \item{COL_DT}{Date of Collection}
#'     \item{IC_DT}{Date of Informed Consent}
#'   }
#'
#' @source [Access the source of the demographics dataset.](https://github.com/pharmaverse/pharmaverseraw/blob/main/data/dm_raw.rda)
#' @author Shiyu Chen
"dm_raw"
