% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_estimation_step}
\alias{add_estimation_step}
\title{add_estimation_step}
\usage{
add_estimation_step(
  model,
  method,
  interaction = TRUE,
  options = NULL,
  idx = NULL
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{method}{(str) estimation method to change to}

\item{interaction}{(logical) whether to use interaction or not, default is true}

\item{options}{(list) any additional tool specific options}

\item{idx}{(integer) index of estimation step, default is NULL (adds step at the end)}
}
\value{
(Model) Reference to the same model object
}
\description{
Add estimation step

Adds estimation step for a model in a given index. Methods currently supported are:
FO, FOCE, ITS, LAPLACE, IMPMAP, IMP, SAEM
}
\examples{
\dontrun{
model <- load_example_model("pheno")
opts <- list('NITER'=1000, 'ISAMPLE'=100, 'EONLY'=1)
add_estimation_step(model, "IMP", options=opts)
ests <- model$estimation_steps
len(ests)
ests[2]
}
}
\seealso{
set_estimation_step

remove_estimation_step

append_estimation_step_options
}
