% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{transform_etas_john_draper}
\alias{transform_etas_john_draper}
\title{transform_etas_john_draper}
\usage{
transform_etas_john_draper(model, list_of_etas = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model to apply John Draper transformation to.}

\item{list_of_etas}{(str, vector) Name/names of etas to transform. If NULL, all etas will be transformed (default).}
}
\value{
(Model) Reference to the same model
}
\description{
Applies a John Draper transformation (1) to spelected etas

Initial estimate for lambda is 0.1 with bounds (-3, 3).

(1) John, J., Draper, N. (1980). An Alternative Family of Transformations.
Journal of the Royal Statistical Society. Series C (Applied Statistics),
29(2), 190-197. doi:10.2307/2986305
}
\examples{
\dontrun{
model <- load_example_model("pheno")
transform_etas_john_draper(model, c("ETA(1)"))
model$statements$full_expression_from_odes("CL")
}
}
\seealso{
transform_etas_boxcox

transform_etas_tdist
}
