% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{get_parameter_rv}
\alias{get_parameter_rv}
\title{get_parameter_rv}
\usage{
get_parameter_rv(model, parameter, var_type = "iiv")
}
\arguments{
\item{model}{(Model) Pharmpy model to retrieve parameters from}

\item{parameter}{(str) Name of parameter to retrieve random variable from}

\item{var_type}{(str) Variability type: iiv (default) or iov}
}
\value{
(vectorc(str)) A vector of random variable names for the given parameter
}
\description{
Retrieves name of random variable in :class:\code{pharmpy.model.Model} given a parameter.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
get_parameter_rv(model, 'CL')
}
}
\seealso{
get_rv_parameters

has_random_effect

get_pk_parameters

get_individual_parameters
}
