% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_combined_error_model}
\alias{set_combined_error_model}
\title{set_combined_error_model}
\usage{
set_combined_error_model(model, dv = NULL, data_trans = NULL)
}
\arguments{
\item{model}{(Model) Set error model for this model}

\item{dv}{(str or Expr or numeric (optional)) Name or DVID of dependent variable. NULL for the default (first or only)}

\item{data_trans}{(numeric or str or Expr (optional)) A data transformation expression or NULL (default) to use the transformation
specified by the model.}
}
\value{
(Model) Pharmpy model object
}
\description{
Set a combined error model. Initial estimates for new sigmas are (equation could not be rendered, see API doc on website)
proportional and 0.09 for additive.

The error function being applied depends on the data transformation.

+------------------------+-----------------------------------------------------+
| Data transformation    | Combined error                                      |
+========================+=====================================================+
| (equation could not be rendered, see API doc on website)
+------------------------+-----------------------------------------------------+
| (equation could not be rendered, see API doc on website)
+------------------------+-----------------------------------------------------+
}
\examples{
\dontrun{
model <- remove_error_model(load_example_model("pheno"))
model <- set_combined_error_model(model)
model$statements$find_assignment("Y")
model <- remove_error_model(load_example_model("pheno"))
model <- set_combined_error_model(model, data_trans="log(Y)")
model$statements$find_assignment("Y")
}
}
\seealso{
set_additive_error_model : Additive error model

set_proportional_error_model: Proportional error model
}
